//
// Copyright (c) 1997-2001 Tony Givargis. Permission to copy is
// granted provided that this header remains intact. This software
// is provided with no warranties.
//

//----------------------------------------------------------------------------

#include <cassert>
#include "simultr.h"

//----------------------------------------------------------------------------

#define FOR_ALL_POINTS \
for(idx[ 0]=0; idx[ 0]<lmt[ 0]; idx[ 0]++) \
for(idx[ 1]=0; idx[ 1]<lmt[ 1]; idx[ 1]++) \
for(idx[ 2]=0; idx[ 2]<lmt[ 2]; idx[ 2]++) \
for(idx[ 3]=0; idx[ 3]<lmt[ 3]; idx[ 3]++) \
for(idx[ 4]=0; idx[ 4]<lmt[ 4]; idx[ 4]++) \
for(idx[ 5]=0; idx[ 5]<lmt[ 5]; idx[ 5]++) \
for(idx[ 6]=0; idx[ 6]<lmt[ 6]; idx[ 6]++) \
for(idx[ 7]=0; idx[ 7]<lmt[ 7]; idx[ 7]++) \
for(idx[ 8]=0; idx[ 8]<lmt[ 8]; idx[ 8]++) \
for(idx[ 9]=0; idx[ 9]<lmt[ 9]; idx[ 9]++) \
for(idx[10]=0; idx[10]<lmt[10]; idx[10]++) \
for(idx[11]=0; idx[11]<lmt[11]; idx[11]++) \
for(idx[12]=0; idx[12]<lmt[12]; idx[12]++) \
for(idx[13]=0; idx[13]<lmt[13]; idx[13]++) \
for(idx[14]=0; idx[14]<lmt[14]; idx[14]++) \
for(idx[15]=0; idx[15]<lmt[15]; idx[15]++) \
for(idx[16]=0; idx[16]<lmt[16]; idx[16]++) \
for(idx[17]=0; idx[17]<lmt[17]; idx[17]++) \
for(idx[18]=0; idx[18]<lmt[18]; idx[18]++)

//----------------------------------------------------------------------------

Simulator::Simulator(Loader *_loader) {
    
    loader = _loader;
    
    assert( loader );
    
    loader->totalPoints = 0;
    loader->currentPoint = 0;
}

//----------------------------------------------------------------------------

Simulator::~Simulator() {
}

//----------------------------------------------------------------------------

void Simulator::Simulate() {
    
    int idx[TotalParameters];
    int val[TotalParameters][MaxPointsPerParameter];
    int lmt[TotalParameters];
    
    memset(val, 0, sizeof(val));
    memset(lmt, 0, sizeof(lmt));
    
    for(int i=0; i<TotalParameters; i++) {
        
        for(int j=0; j<PointsPerParameter[i]; j++) {
            
            if( !loader->psData->space[i][j] ) continue;
            
            switch( i ) {
                
            case  0: val[i][lmt[i]++] = (128 << j); break;
            case  1: val[i][lmt[i]++] = (  4 << j); break;
            case  2: val[i][lmt[i]++] = (  1 << j); break;
            case  3: val[i][lmt[i]++] = (128 << j); break;
            case  4: val[i][lmt[i]++] = (  4 << j); break;
            case  5: val[i][lmt[i]++] = (  1 << j); break;
            case  6: val[i][lmt[i]++] = (  4 << j); break;
            case  7: val[i][lmt[i]++] = (       j); break;
            case  8: val[i][lmt[i]++] = (  4 << j); break;
            case  9: val[i][lmt[i]++] = (       j); break;
            case 10: val[i][lmt[i]++] = (  4 << j); break;
            case 11: val[i][lmt[i]++] = (       j); break;
            case 12: val[i][lmt[i]++] = (  4 << j); break;
            case 13: val[i][lmt[i]++] = (       j); break;
            case 14: val[i][lmt[i]++] = (  4 << j); break;
            case 15: val[i][lmt[i]++] = (       j); break;
            case 16: val[i][lmt[i]++] = (  4 << j); break;
            case 17: val[i][lmt[i]++] = (       j); break;
            case 18: val[i][lmt[i]++] = (10  +  j); break;
            default: assert( false );
            }
        }
    }
    
    loader->totalPoints = 1;
    loader->currentPoint = 0;
    for(i=0; i<TotalParameters; i++) {
        
        loader->totalPoints *= lmt[i];
    }
    
    loader->Reset();
    FOR_ALL_POINTS {
        
        loader->currentPoint++;
        
        if( loader->mvm->Reset(
            static_cast<int>      (val[ 0][idx[ 0]]),
            static_cast<int>      (val[ 1][idx[ 1]]),
            static_cast<int>      (val[ 2][idx[ 2]]),
            static_cast<int>      (val[ 3][idx[ 3]]),
            static_cast<int>      (val[ 4][idx[ 4]]),
            static_cast<int>      (val[ 5][idx[ 5]]),
            static_cast<int>      (val[ 6][idx[ 6]]),
            static_cast<Encoding> (val[ 7][idx[ 7]]),
            static_cast<int>      (val[ 8][idx[ 8]]),
            static_cast<Encoding> (val[ 9][idx[ 9]]),
            static_cast<int>      (val[10][idx[10]]),
            static_cast<Encoding> (val[11][idx[11]]),
            static_cast<int>      (val[12][idx[12]]),
            static_cast<Encoding> (val[13][idx[13]]),
            static_cast<int>      (val[14][idx[14]]),
            static_cast<Encoding> (val[15][idx[15]]),
            static_cast<int>      (val[16][idx[16]]),
            static_cast<Encoding> (val[17][idx[17]]),
            static_cast<int>      (val[18][idx[18]]) / 10.0) ) {
            
            loader->mvm->Execute();
            loader->Report();
        }
    }
}