//
// Copyright (c) 1997-2001 Tony Givargis. Permission to copy is
// granted provided that this header remains intact. This software
// is provided with no warranties.
//

//----------------------------------------------------------------------------

#ifndef mipsasm_h
#define mipsasm_h

//----------------------------------------------------------------------------

#include <fstream>
#include <list>
#include "mipsvm.h"
using namespace std;

//----------------------------------------------------------------------------

struct Symbol { 
    
    char *name;
    unsigned address;
};

//----------------------------------------------------------------------------

struct Fix { 
    
    Symbol *symbol;
    unsigned codeAddress;
    unsigned dataAddress;
    unsigned offset;
    int type;
};

//----------------------------------------------------------------------------

class MipsAssembler {
    
public:
    unsigned szDataSeg;
    unsigned szCodeSeg;
    unsigned char *dataSeg;
    unsigned char *copyOfDataSeg;
    MipsInstruction *codeSeg;
    
private:
    list<Symbol*> symb;
    list<Fix*> fixl;
    
public:
    unsigned dataAddress;
    unsigned codeAddress;
    
private:
    bool isText;
    ofstream errStr;
    
public:
    MipsAssembler(unsigned _szDataSeg, unsigned _szCodeSeg);
    ~MipsAssembler();
    
public:
    bool Assemble(const char *srcFileName, const char *errFileName);
    
private:
    void Initialize();
    bool Read(const char *srcFileName);
    bool BackAnotate();
    void Cleanup();
    
private:
    bool Directive(list<char*> &tokens);
    bool Instruction(list<char*> &tokens);
    bool Label(list<char*> &tokens);
    
private:
    void Translate_fmask(list<char*> &tokens);
    void Translate_align(list<char*> &tokens);
    void Translate_byte(list<char*> &tokens);
    void Translate_comm(list<char*> &tokens);
    void Translate_cpload(list<char*> &tokens);
    void Translate_cprestore(list<char*> &tokens);
    void Translate_data(list<char*> &tokens);
    void Translate_ent(list<char*> &tokens);
    void Translate_end(list<char*> &tokens);
    void Translate_extern(list<char*> &tokens);
    void Translate_file(list<char*> &tokens);
    void Translate_frame(list<char*> &tokens);
    void Translate_global(list<char*> &tokens);
    void Translate_gpword(list<char*> &tokens);
    void Translate_half(list<char*> &tokens);
    void Translate_lcomm(list<char*> &tokens);
    void Translate_loc(list<char*> &tokens);
    void Translate_mask(list<char*> &tokens);
    void Translate_rdata(list<char*> &tokens);
    void Translate_sdata(list<char*> &tokens);
    void Translate_set(list<char*> &tokens);
    void Translate_space(list<char*> &tokens);
    void Translate_text(list<char*> &tokens);
    void Translate_word(list<char*> &tokens);
    void Translate_asciiz(list<char*> &tokens);
    
private:
    void Translate_sb(list<char*> &tokens);
    void Translate_sh(list<char*> &tokens);
    void Translate_sw(list<char*> &tokens);
    void Translate_lb(list<char*> &tokens);
    void Translate_lh(list<char*> &tokens);
    void Translate_lw(list<char*> &tokens);
    void Translate_la(list<char*> &tokens);
    void Translate_lbu(list<char*> &tokens);
    void Translate_lhu(list<char*> &tokens);
    void Translate_div(list<char*> &tokens);
    void Translate_divu(list<char*> &tokens);
    void Translate_rem(list<char*> &tokens);
    void Translate_remu(list<char*> &tokens);
    void Translate_mul(list<char*> &tokens);
    void Translate_addu(list<char*> &tokens);
    void Translate_and(list<char*> &tokens);
    void Translate_or(list<char*> &tokens);
    void Translate_xor(list<char*> &tokens);
    void Translate_subu(list<char*> &tokens);
    void Translate_sll(list<char*> &tokens);
    void Translate_sra(list<char*> &tokens);
    void Translate_srl(list<char*> &tokens);
    void Translate_not(list<char*> &tokens);
    void Translate_negu(list<char*> &tokens);
    void Translate_move(list<char*> &tokens);
    void Translate_b(list<char*> &tokens);
    void Translate_j(list<char*> &tokens);
    void Translate_beq(list<char*> &tokens);
    void Translate_bge(list<char*> &tokens);
    void Translate_bgeu(list<char*> &tokens);
    void Translate_bgt(list<char*> &tokens);
    void Translate_bgtu(list<char*> &tokens);
    void Translate_ble(list<char*> &tokens);
    void Translate_bleu(list<char*> &tokens);
    void Translate_blt(list<char*> &tokens);
    void Translate_bltu(list<char*> &tokens);
    void Translate_bne(list<char*> &tokens);
    void Translate_jal(list<char*> &tokens);
    void Translate_l_d(list<char*> &tokens);
    void Translate_l_s(list<char*> &tokens);
    void Translate_s_d(list<char*> &tokens);
    void Translate_s_s(list<char*> &tokens);
    void Translate_trunc_w_d(list<char*> &tokens);
    void Translate_mfc1(list<char*> &tokens);
    void Translate_mtc1(list<char*> &tokens);
    void Translate_cvt_d_w(list<char*> &tokens);
    void Translate_cvt_s_d(list<char*> &tokens);
    void Translate_cvt_d_s(list<char*> &tokens);
    void Translate_add_d(list<char*> &tokens);
    void Translate_add_s(list<char*> &tokens);
    void Translate_div_d(list<char*> &tokens);
    void Translate_div_s(list<char*> &tokens);
    void Translate_mul_d(list<char*> &tokens);
    void Translate_mul_s(list<char*> &tokens);
    void Translate_sub_d(list<char*> &tokens);
    void Translate_sub_s(list<char*> &tokens);
    void Translate_mov_d(list<char*> &tokens);
    void Translate_mov_s(list<char*> &tokens);
    void Translate_neg_d(list<char*> &tokens);
    void Translate_neg_s(list<char*> &tokens);
    void Translate_c_eq_d(list<char*> &tokens);
    void Translate_c_eq_s(list<char*> &tokens);
    void Translate_c_le_d(list<char*> &tokens);
    void Translate_c_le_s(list<char*> &tokens);
    void Translate_c_lt_d(list<char*> &tokens);
    void Translate_c_lt_s(list<char*> &tokens);
    void Translate_bc1t(list<char*> &tokens);
    void Translate_bc1f(list<char*> &tokens);
    
private:
    long CrackArg(char *token, unsigned char &reg, long &value);
    long GetRegister(char *token);
    long GetValue(char *token, int address=0, int type=0);
    
private:
    Symbol *InsertSymbol(const char *name, unsigned address=0xffffffff);
    list<char*> &Tokenize(list<char*> &l, char *buf);
};

//----------------------------------------------------------------------------

#endif