//
// Copyright (c) 1997-2001 Tony Givargis. Permission to copy is
// granted provided that this header remains intact. This software
// is provided with no warranties.
//

//----------------------------------------------------------------------------

#ifndef loader_h
#define loader_h

//----------------------------------------------------------------------------

#include <fstream>
#include "mipsasm.h"
#include "mipsvm.h"
#include "psdata.h"
using namespace std;

//----------------------------------------------------------------------------

class Loader {
    
public:
    char baseDir[256];
    char cppFileName[256];
    char lccFileName[256];
    char errFileName[256];
    char outFileName[256];
    char repFileName[256];
    char parFileName[256];
    
public:
    MipsAssembler *ma;
    MipsVirtualMachine *mvm;
    ParameterSpaceData *psData;
    
public:
    unsigned long totalPoints;
    unsigned long currentPoint;
    
public:
    ofstream outStr;
    ofstream repStr;
    ofstream parStr;
    
public:
    Loader(const char *_baseDir);
    ~Loader();
    
public:
    bool Load(const char *fileName, char *msgBuf);
    
public:
    void Output(char c);
    void Report();
    void Pareto(int *params, double power, double time);
    void Reset();
};

//----------------------------------------------------------------------------

#endif