//
// Copyright (c) 1997-2001 Tony Givargis. Permission to copy is
// granted provided that this header remains intact. This software
// is provided with no warranties.
//

//----------------------------------------------------------------------------

#ifndef frame_h
#define frame_h

//----------------------------------------------------------------------------

#include <afxwin.h>
#include <afxext.h>
#include "thread.h"
#include "loader.h"
#include "simultr.h"
#include "explorer.h"

//----------------------------------------------------------------------------

class SimulateThread : public Thread {
    
    Simulator *simulator;
    
public:
    SimulateThread(Loader *loader);
    ~SimulateThread();
    
private:
    void Run();
};

//----------------------------------------------------------------------------

class ExploreThread : public Thread {
    
    Explorer *explorer;
    
public:
    ExploreThread(Loader *_loader);
    ~ExploreThread();
    
private:
    void Run();
};

//----------------------------------------------------------------------------

class Frame : public CMDIFrameWnd {
    
    CStatusBar statusBar;
    bool applicationLoaded;
    int state;
    
private:
    Loader *loader;
    SimulateThread *simThread;
    ExploreThread *expThread;
    unsigned long runTime;
    
public:
    Frame();
    ~Frame();
    
private:
    int OnCreate(LPCREATESTRUCT lpCreateStruct);
    void OnClose();
    void OnTimer(UINT id);
    
private:
    void OnLoad();
    void OnLoadUpdate(CCmdUI *pCmdUI);
    
private:
    void OnSetParameter();
    void OnSetParameterUpdate(CCmdUI *pCmdUI);
    
private:
    void OnAbort();
    void OnAbortUpdate(CCmdUI *pCmdUI);
    
private:
    void OnSimulate();
    void OnSimulateUpdate(CCmdUI *pCmdUI);
    
private:
    void OnExplore();
    void OnExploreUpdate(CCmdUI *pCmdUI);
    
private:
    void OnAbout();
    
private:
    DECLARE_MESSAGE_MAP();
    DECLARE_DYNAMIC(Frame);
};

//----------------------------------------------------------------------------

#endif