//
// Copyright (c) 1997-2001 Tony Givargis. Permission to copy is
// granted provided that this header remains intact. This software
// is provided with no warranties.
//

//----------------------------------------------------------------------------

#ifndef explorer_h
#define explorer_h

//----------------------------------------------------------------------------

#include <fstream>
#include "loader.h"
using namespace std;

//----------------------------------------------------------------------------

struct Point {
    
    double time;
    double power;
    int param[TotalParameters];
};

//----------------------------------------------------------------------------

struct Cluster {
    
    bool memberSet[TotalParameters];
    list<Point> points;
    
public:
    Cluster();
    ~Cluster();
    
public:
    void Clear();
    void AddParameter(int p);
    void UnionWith(const Cluster &c);
    
public:
    bool IsMember(int p) const;
    bool IsDisjoint(const Cluster &c) const;
};

//----------------------------------------------------------------------------

class Explorer {
    
    Loader *loader;
    
private:
    int val[TotalParameters][MaxPointsPerParameter];
    int lmt[TotalParameters];
    list<Cluster> clusters;
    
public:
    Explorer(Loader *_loader);
    ~Explorer();
    
public:
    void Explore();
    
private:
    void ComputeParameterSpace();
    void ComputeInitialClusters();
    void ExploreClusterInitial(Cluster &c);
    void ExploreClusterSubsequent(Cluster &c1, Cluster &c2);
    void SortParetoOptimal(Cluster &c);
};

//----------------------------------------------------------------------------

#endif