//
// Copyright (c) 1997-2001 Tony Givargis. Permission to copy is
// granted provided that this header remains intact. This software
// is provided with no warranties.
//

//----------------------------------------------------------------------------

#include "app.h"
#include "child.h"

//----------------------------------------------------------------------------

ChildWnd::ChildWnd(CMDIFrameWnd *parent, const string &_url) : url(_url) {
    
    DWORD w = WS_OVERLAPPEDWINDOW | WS_VISIBLE | WS_CHILD;
    
    htmlView = new HtmlView();
    Create(0, url.c_str(), w, rectDefault, parent);
}

//----------------------------------------------------------------------------

ChildWnd::~ChildWnd() {
}

//----------------------------------------------------------------------------

int ChildWnd::OnCreate(LPCREATESTRUCT lpCreateStruct) {
    
    DWORD w1 = WS_VISIBLE | WS_CHILD;
    DWORD w2 = AFX_IDW_PANE_FIRST;
    
    htmlView->Create(0, 0, w1, rectDefault, this, w2);
    htmlView->Navigate(url.c_str());
    return 0;
}

//----------------------------------------------------------------------------

void ChildWnd::OnSetFocus(CWnd *pOldWnd) {
    
    CMDIChildWnd::OnSetFocus(pOldWnd);
    htmlView->SetFocus();
}

//----------------------------------------------------------------------------

BOOL ChildWnd::OnCmdMsg(UINT nID, int nCode, void *pExtra, 
                        AFX_CMDHANDLERINFO *pHandlerInfo) {
    
    if( htmlView->OnCmdMsg(nID, nCode, pExtra, pHandlerInfo) ) {
        
        return 1;
    }
    return CMDIChildWnd::OnCmdMsg(nID, nCode, pExtra, pHandlerInfo);
}

//----------------------------------------------------------------------------

BEGIN_MESSAGE_MAP(ChildWnd, CMDIChildWnd)
ON_WM_SETFOCUS()
ON_WM_CREATE()
END_MESSAGE_MAP()