//
// Copyright (c) 1997-2001 Tony Givargis. Permission to copy is
// granted provided that this header remains intact. This software
// is provided with no warranties.
//

//----------------------------------------------------------------------------

#ifndef cachesim_h
#define cachesim_h

//----------------------------------------------------------------------------

struct Entry {
    
    unsigned *cnt;
    unsigned long *tag;
    bool *valid;
    bool *dirty;
};

//----------------------------------------------------------------------------

class CacheSimulator {
    
public:
    unsigned numRead;
    unsigned numWrite;
    unsigned numReadMiss;
    unsigned numWriteMiss;
    unsigned numWriteBack;
    
public:
    unsigned size;
    unsigned line;
    unsigned assoc;
    double voltage;
    
private:
    Entry *entries;
    unsigned szEntries;
    
public:
    CacheSimulator();
    ~CacheSimulator();
    
public:
    void Reset(unsigned _size, unsigned _line, unsigned _assoc, double _voltage);
    
public:
    double ComputePower();
    
public:
    int Read(unsigned long a);
    int Write(unsigned long a);
    
private:
    int ReadWrite(unsigned long a, bool dirty);
    unsigned GetLru(unsigned idx);
    unsigned GetMaxCnt(unsigned idx);
    
private:
    double Log2(double x);
};

//----------------------------------------------------------------------------

#endif