$!------------------------------------------------------------------
$! IEEE toolset tester
$
$!  p1 is a string with the following flags defined:
$!
$!     s = put the vhdl source in the log file
$!     v = do the vhdl
$!     m = do the model generation
$!     d = first delete everything in library
$!     u = do testing utilities first
$!     c = clean out units after each test
$!     q = be quiet (only output to logs is from tools)
$!     k = build the kernel
$!     x = sim the kernel
$!     w = write command files instead of executing
$!
$!  p2 is the name of the input file
$!  p3 is the test library
$!  p4 is the working directory
$!  p5 is the directory where the log files are to be placed
$!  p6 is the directory where the executables are
$!  p7 is the directory where testing utilities are
$!
$!------------------------------------------------------------------
$
$   say = "write sys$output"
$   ff    := 
$   page  = "''say' ff"
$
$ check_p2:
$   test_lis_sym = f$search(p2)
$   if test_lis_sym .nes. "" then goto check_p4
$   say ">>> Test list file not found"
$   goto missing_file_err
$ check_p4:
$   if f$parse(p4) .nes. "" then goto check_p5
$   say ">>> Working directory not found"
$   goto missing_file_err
$ check_p5:
$   if f$parse(p5) .nes. "" then goto check_p6
$   say ">>> Log file directory not found"
$   goto missing_file_err
$ check_p6:
$   if f$parse(p6) .nes. "" then goto check_p7
$   say ">>> Executables directory not found"
$   goto missing_file_err
$ check_p7:
$   if f$parse(p7) .nes. "" then goto end_check_p
$   say ">>> Testing utilities directory not found"
$   goto missing_file_err
$!
$ end_check_p:
$
$   opt_string      = p1
$   test_lib        = p3
$   working_dir_sym = f$parse(p4,,,"DEVICE") + f$parse(p4,,,"DIRECTORY")
$   log_dir_sym = f$parse(p5,,,"DEVICE") + f$parse(p5,,,"DIRECTORY")
$   exe_dir_sym = f$parse(p6,,,"DEVICE") + f$parse(p6,,,"DIRECTORY")
$   utils_dir_sym = f$parse(p7,,,"DEVICE") + f$parse(p7,,,"DIRECTORY")
$
$   do_source   = 0
$   do_vhdl     = 0
$   do_mg       = 0
$   do_build    = 0
$   do_sim      = 0
$   do_vls_del  = 0
$   do_utils    = 0
$   do_clean    = 0
$   be_quiet    = 0
$   do_com_file = 0
$
$   if opt_string .eqs. "" then goto no_params
$   opt_string = f$edit(opt_string,"collapse, upcase")
$
$   count = f$length(opt_string)
$
$ next_flag:
$
$   if count .eq. 0 then goto no_params
$   flag = f$extract(0, 1, opt_string)
$   opt_string = f$extract(1, f$length(opt_string), opt_string)
$   if flag .eqs. "V" then do_vhdl   = 1
$   if flag .eqs. "S" then do_source = 1
$   if flag .eqs. "M" then do_mg     = 1
$   if flag .eqs. "D" then do_vls_del = 1
$   if flag .eqs. "U" then do_utils  = 1
$   if flag .eqs. "C" then do_clean  = 1
$   if flag .eqs. "Q" then be_quiet  = 1
$   if flag .eqs. "K" then do_build  = 1
$   if flag .eqs. "X" then do_sim    = 1
$   if flag .eqs. "W" then do_com_file = 1
$   count = count - 1
$   goto next_flag
$
$
$ no_params:
$
$ @IEEE$DISK:[IEEE.VAL.TOOLS]VHDL_DEFS.COM
$   define test_lis    'test_lis_sym'
$   define working_dir 'working_dir_sym'
$   define log_dir     'log_dir_sym'
$   define exe_dir     'exe_dir_sym'
$   define utils_dir   'utils_dir_sym'
$
$   vhdl  = "$ exe_dir:vhdl.exe"
$   vls   = "$ exe_dir:vls.exe"
$   mg    = "$ exe_dir:mg.exe"
$   build = "$ exe_dir:build.exe"
$   sim   = "$ exe_dir:sim.exe"
$
$   vhdl_cmd     = "vhdl/nolist/nocopy/crash"
$   mg_cmd       = "mg/debug=cknd"
$   mg_top_cmd   = "mg/debug=cknd/top"
$   build_cmd    = "build/replace/kernel="
$   sim_cmd      = "sim/notrace"
$
$   set default working_dir
$
$   day      = f$cvtime(,,"DAY")
$   month    = f$cvtime(,,"MONTH")
$   hour     = f$cvtime(,,"HOUR")
$   minute   = f$cvtime(,,"MINUTE")
$
$   since = f$extract(0,6,f$time()) + ":" + hour + ":" + minute
$   run_id = month + "_" + day + "_" + hour + "_" + minute
$   rid = run_id + "."
$   log_file = run_id + ".run;0"
$   open/write def_last_run last_run.com
$   write def_last_run "$ define last_run " + working_dir_sym + log_file
$   close def_last_run
$
$   define sys$output 'log_file'
$
$   say "--------------------------------------------------------------------"
$   say "                         " + f$time()
$   say ""
$   say "PARAMETERS:"
$   say "   options string = " + p1
$   say "   name of the input file = " + p2
$   say "   test library = " + p3
$   say "   working directory = " + p4
$   say "   directory where log files are to be placed = " + p5
$   say "   executables directory = " + p6
$   say "   testing utilities directory = " + p7
$   say ""
$   say "OPTIONS:
$   say "   source      = " + f$string(do_source)
$   say "   vhdl        = " + f$string(do_vhdl)
$   say "   mg          = " + f$string(do_mg)
$   say "   vls del     = " + f$string(do_vls_del)
$   say "   utilities   = " + f$string(do_utils)
$   say "   cleanup     = " + f$string(do_clean)
$   say "   be quiet    = " + f$string(be_quiet)
$   say "   build       = " + f$string(do_build)
$   say "   sim         = " + f$string(do_sim)
$   say "   do com file = " + f$string(do_com_file)
$   say ""
$
$   directory/version=1/date/noheader/notrail exe_dir:vhdl.exe
$   directory/version=1/date/noheader/notrail exe_dir:mg.exe
$   directory/version=1/date/noheader/notrail exe_dir:build.exe
$   directory/version=1/date/noheader/notrail exe_dir:sim.exe
$   
$   say ""
$   say "--------------------------------------------------------------------"
$ 
$   vls setlib 'test_lib'
$
$   if .not. do_com_file then goto no_com_defs
$   say "$ set default ''working_dir_sym'"
$   say "$ @IEEE$DISK:[IEEE.VAL.TOOLS]VHDL_DEFS.COM"
$   say "$ define exe_dir     ''exe_dir_sym'"
$   say "$ vhdl  = ""$ exe_dir:vhdl.exe"""
$   say "$ vls   = ""$ exe_dir:vls.exe"""
$   say "$ mg    = ""$ exe_dir:mg.exe"""
$   say "$ build = ""$ exe_dir:build.exe"""
$   say "$ sim   = ""$ exe_dir:sim.exe"""
$   say "$ vls setlib ''test_lib'"
$
$ no_com_defs:
$   if .not. do_vls_del then goto utils
$   test_lib_dir = test_lib - "<<"
$   test_lib_dir = test_lib_dir - ">>"
$   if do_com_file then goto com_vls_del
$   vls del /library/all 'test_lib'
$   vls makelib 'test_lib' /dir=VHDL$DATA_ROOT::['test_lib_dir']
$   vls setlib 'test_lib'
$   goto utils
$
$ com_vls_del:
$   say "$ vls del /library/all ''test_lib'"
$   say "$ vls makelib ''test_lib' /dir=VHDL$DATA_ROOT::[''test_lib_dir']"
$   say "$ vls setlib ''test_lib'"
$
$ utils:
$   if .not. do_utils then goto open_file
$   if .not. do_vhdl then goto mg_utils
$   if do_com_file then goto com_utils
$   page
$   say ""
$   say "--------------------------------------------------------------------"
$   say "Analyzing testing utilities"
$   say "--------------------------------------------------------------------"
$   say ""
$   on error then goto bad_vhdl_utils_err
$   'vhdl_cmd' utils_dir:standard_types.vhd
$   on error then goto bad_vhdl_utils_err
$   'vhdl_cmd' utils_dir:generic_standard_types.vhd
$   on error then goto bad_vhdl_utils_err
$   'vhdl_cmd' utils_dir:arithmetic.vhd
$   goto mg_utils
$
$ com_utils:
$   say "$"
$   say "$! Analyze testing utilities"
$   say "$ ''vhdl_cmd' ''utils_dir_sym':standard_types.vhd"
$   say "$ ''vhdl_cmd' ''utils_dir_sym':generic_standard_types.vhd"
$   say "$ ''vhdl_cmd' ''utils_dir_sym':arithmetic.vhd"
$
$ mg_utils:
$   if .not. do_mg then goto open_file
$   if do_com_file then goto com_mg_utils
$   say ""
$   say "--------------------------------------------------------------------"
$   say "Model generating utilities"
$   say "--------------------------------------------------------------------"
$   say ""
$   on error then goto bad_mg_utils_err
$   'mg_cmd' standard_types
$   if ($severity .eq. 5) .or. ($severity .eq. 7) then goto bad_mg_utils_err
$   on error then goto bad_mg_utils_err
$   'mg_cmd' standard_types /body
$   if ($severity .eq. 5) .or. ($severity .eq. 7) then goto bad_mg_utils_err
$   on error then goto bad_mg_utils_err
$   'mg_cmd' arithmetic
$   if ($severity .eq. 5) .or. ($severity .eq. 7) then goto bad_mg_utils_err
$   goto open_file
$
$ com_mg_utils:
$   say "$"
$   say "$! Model generate utilities"
$   say "$ ''mg_cmd' standard_types"
$   say "$ ''mg_cmd' standard_types /body"
$   say "$ ''mg_cmd' arithmetic"
$
$ open_file:
$   open/read/err=open_test_lis_err infile test_lis
$   case_num = 0
$
$   prolog_not_needed = (.not. do_mg) .and. (.not. do_build) .and. -
                        (.not. do_sim)
$
$ test_lis_loop:
$   read/end_of_data=end_of_test_lis infile next_case
$   if f$extract(0,2,next_case) .eqs. "--" then goto test_lis_loop
$   case_num = case_num + 1
$   next_case = f$edit(next_case,"compress, trim, upcase")
$
$   if prolog_not_needed then goto skip_prolog
$
$   open/read/err=case_open_err next_file 'next_case'
$   unit_num = 0
$
$ test_prolog_loop:
$   read/end_of_data=end_of_prolog next_file prolog_line
$   prolog_line = f$edit(prolog_line,"collapse, upcase")
$   if f$length(prolog_line) .eq. 0 then goto test_prolog_loop
$   if f$locate("--DESIGNUNITORDERING",prolog_line) .ne. 0 -
    then goto test_prolog_loop
$
$ design_unit_loop:
$   read/end_of_data=end_of_prolog next_file prolog_line
$   prolog_line = f$edit(prolog_line,"collapse, upcase")
$   prolog_line = prolog_line - "--"
$   if prolog_line .eqs. "" then goto design_unit_loop
$   if f$locate("REVISIONHISTORY",prolog_line) .eq. 0 then goto end_of_prolog
$   unit_num = unit_num + 1
$   numstr = f$string(unit_num)
$   unit'numstr' = prolog_line
$   goto design_unit_loop
$   
$ end_of_prolog:
$   na_found = 0
$   if unit_num .eq. 0 then goto design_unit_ordering_err
$
$   if unit_num .ne. 1 then goto skip_na_check
$   if unit'numstr' .eqs. "N/A" then na_found = 1
$
$ skip_na_check:
$   close next_file
$
$   if .not. do_clean then goto skip_create_clean_file
$   if na_found then goto skip_create_clean_file
$
$   clean_file_name = f$getjpi(0, "PID") + ".clean"
$   open/write clean_file 'clean_file_name'
$   write clean_file "$ vls"
$   write clean_file "setlib ''test_lib'"
$   unit_to_del = unit_num
$
$   if unit_to_del .eq. 1 then goto end_create_clean_file
$   unit_to_del = unit_to_del - 1
$
$ clean_file_loop:
$   write clean_file "delete " + unit'unit_to_del'
$   if unit_to_del .eq. 1 then goto end_create_clean_file
$   unit_to_del = unit_to_del - 1
$   goto clean_file_loop
$
$ end_create_clean_file:
$   write clean_file "exit"
$   close clean_file
$
$ skip_create_clean_file:
$
$ skip_prolog:
$
$   if do_com_file then goto skip_deassign
$   deassign sys$output
$   this_case_log = f$parse(next_case,,,"name") + ".log"
$   this_case_sim = f$parse(next_case,,,"name") + ".sim"
$   define sys$output  log_dir:'this_case_log'
$ skip_deassign:
$   if do_com_file then say "$ "
$
$   if be_quiet .or. do_com_file then goto file_name_quiet
$   say ""
$   say "--------------------------------------------------------------------"
$   say "[" + rid + f$string(case_num) + "]  File: " + f$parse(next_case)
$   say "--------------------------------------------------------------------"
$   say ""
$ file_name_quiet:
$
$ source:
$   if .not. do_source then goto vhdl
$   if be_quiet .or. do_com_file then goto source_quiet
$   say ""
$   say "--------------------------------------------------------------------"
$   say "[" + rid + f$string(case_num) + "]  Source: " + f$parse(next_case)
$   say "--------------------------------------------------------------------"
$   say ""
$   type 'next_case'
$   say ""
$   say ""
$ source_quiet:
$
$ vhdl:
$   if .not. do_vhdl then goto mg
$   if be_quiet .or. do_com_file then goto alz_quiet
$   say ""
$   say "--------------------------------------------------------------------"
$   say "[" + rid + f$string(case_num) + "]  Analyzing: " + f$parse(next_case)
$   say "--------------------------------------------------------------------"
$   say ""
$ alz_quiet:
$
$   if do_com_file then goto com_vhdl
$   on error then goto del_units
$   'vhdl_cmd' 'next_case'
$   if ($severity .eq. 5) .or. ($severity .eq. 7) then goto del_units
$   goto mg
$
$ com_vhdl:
$   say "$ ''vhdl_cmd' ''next_case'"
$
$ mg:
$   if .not. do_mg then goto build
$   if na_found then goto test_lis_loop_bottom
$   if be_quiet .or. do_com_file then goto mg_quiet
$   say ""
$   say "--------------------------------------------------------------------"
$   say "[" + rid + f$string(case_num) + "]  Model Generating:"
$   say "--------------------------------------------------------------------"
$   say ""
$ mg_quiet:
$
$   mg_num = 1
$
$ mg_loop:
$   if mg_num .eq. unit_num then goto mg_top
$   mg_numstr = f$string(mg_num)
$   mg_unit = unit'mg_numstr'
$   if do_com_file then goto com_mg
$   on error then goto del_units
$   'mg_cmd' 'mg_unit'
$   if ($severity .eq. 5) .or. ($severity .eq. 7) then goto del_units
$   goto mg_loop_bottom
$
$ com_mg:
$   say "$ ''mg_cmd' ''mg_unit'"
$
$ mg_loop_bottom:
$   mg_num = mg_num + 1
$   goto mg_loop
$
$ mg_top:
$   mg_numstr = f$string(mg_num)
$   mg_unit = unit'mg_numstr'
$   if do_com_file then goto com_mg_top
$   on error then goto del_units
$   'mg_top_cmd' 'mg_unit'
$   if ($severity .eq. 5) .or. ($severity .eq. 7) then goto del_units
$   goto build
$
$ com_mg_top:
$   say "$ ''mg_top_cmd' ''mg_unit'"
$
$ build:
$   if .not. do_build then goto sim
$   if na_found then goto test_lis_loop_bottom
$   if be_quiet .or. do_com_file then goto build_quiet
$   say ""
$   say "--------------------------------------------------------------------"
$   say "[" + rid + f$string(case_num) + "]  Building:"
$   say "--------------------------------------------------------------------"
$   say ""
$
$ build_quiet:
$   top_name = unit'numstr'
$   kernel_name = f$extract(0,f$locate("(",top_name),top_name)
$   if do_com_file then goto com_build
$   on error then goto del_units
$   'build_cmd''kernel_name' 'top_name'
$   if ($severity .eq. 5) .or. ($severity .eq. 7) then goto del_units
$   goto sim
$
$ com_build:
$   say "$ ''build_cmd'''kernel_name' ''top_name'"
$
$ sim:
$   if .not. do_sim then goto del_units
$   if na_found then goto test_lis_loop_bottom
$   if be_quiet .or. do_com_file then goto sim_quiet
$   say ""
$   say "--------------------------------------------------------------------"
$   say "[" + rid + f$string(case_num) + "]  Sim:"
$   say "--------------------------------------------------------------------"
$   say ""
$
$ sim_quiet:
$   if do_com_file then goto com_sim
$   top_name = unit'numstr'
$   kernel_name = f$extract(0,f$locate("(",top_name),top_name)
$   on error then goto del_units
$
$! following circumlocution to get sim jobs on a queue with small max time
$   this_case_sub_file = f$parse(next_case,,,"name") + "_sub.com"
$   open/write sub_file 'this_case_sub_file'
$   sub_sim_line = "$ @IEEE$DISK:[IEEE.VAL.TOOLS]VHDL_DEFS.COM"
$   write sub_file sub_sim_line
$   sub_sim_line = "$ set default ''working_dir_sym'"
$   write sub_file sub_sim_line
$   sub_sim_line = "$ define exe_dir     ''exe_dir_sym'"
$   write sub_file sub_sim_line
$   sub_sim_line = "$ vls = ""$ exe_dir:vls.exe"""
$   write sub_file sub_sim_line
$   sub_sim_line = "$ sim = ""$ exe_dir:sim.exe"""
$   write sub_file sub_sim_line
$   sub_sim_line = "$ vls setlib ''test_lib'"
$   write sub_file sub_sim_line
$   sub_sim_line = "$ ''sim_cmd' ''kernel_name'"
$   write sub_file sub_sim_line
$   if .not. do_clean then goto skip_del_kernel
$   sub_sim_line = "$ vls delete/kernel/all ''kernel_name'"
$   write sub_file sub_sim_line
$   sub_sim_line = "$ vls delete ''kernel_name'"
$   write sub_file sub_sim_line
$
$ skip_del_kernel:
$   close sub_file
$   set file /version=0 'this_case_sub_file'
$   submit/noprinter/que=vhdl$fast_batch/log=log_dir:'this_case_sim' -
      'this_case_sub_file'/delete
$
$! here's what should happen
$!   'sim_cmd' 'kernel_name'
$   if ($severity .eq. 5) .or. ($severity .eq. 7) then goto del_units
$   goto del_units
$
$ com_sim:
$   say "$ ''sim_cmd' ''kernel_name'"
$
$ del_units:
$   if do_com_file then goto com_del
$   if .not. do_clean then goto test_lis_loop_bottom
$   if na_found then goto test_lis_loop_bottom
$
$   @ 'clean_file_name'
$   delete 'clean_file_name';0
$   goto test_lis_loop_bottom
$
$ com_del:
$   say "$ vls delete/kernel/all ''kernel_name'"
$   say "$ vls delete ''kernel_name'"
$   type 'clean_file_name'
$   delete 'clean_file_name';0
$
$ test_lis_loop_bottom:
$   if .not. do_com_file then deassign sys$output
$   goto test_lis_loop
$
$ end_of_test_lis:
$   close infile
$   if do_com_file then goto com_end_of_test_lis
$   say ""
$   say "--------------------------------------------------------------------"
$   say "Directory listing of new test log files with size > 0"
$   say ""
$   dir/column=1/select=size=min=1/since='since' log_dir:*.log
$   say ""
$   say "--------------------------------------------------------------------"
$   say ">>> Test terminating normally."
$
$ com_end_of_test_lis:
$   exit
$
$ open_test_lis_err:
$   msg = ">>> ERROR: Cannot open test input list file " + -
    f$trnlnm("test_lis")
$   say msg
$   say ">>> Test terminating abnormally."
$   exit
$
$ case_open_err:
$   msg = ">>> ERROR: Cannot open test case file " + next_case
$   say msg
$   say ">>> Test terminating abnormally."
$   exit
$
$ design_unit_ordering_err:
$   say ">>> ERROR: Design Unit Ordering missing"
$   say ">>> Test terminating abnormally."
$   close infile
$   close next_file
$   exit
$
$ bad_vhdl_utils_err:
$   say ">>> ERROR: Error analyzing utilities"
$   say ">>> Test terminating abnormally."
$   exit
$
$ bad_mg_utils_err:
$   say ">>> ERROR: Error model generating utilities"
$   say ">>> Test terminating abnormally."
$   exit
$
$ missing_file_err:
$   say ">>> Test terminating abnormally."
$   exit
