----------------------------------------------------------------------------  
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  rgrce.10.059.if.es.001.vhdl
--   Title     :  IEEE Std 1076-1987 Language Reference Manual test
--   Purpose   :  An example to verify that following note from LRM
--                is handled properly:
--               
--                If an entity X declared in package P is made potentially
--                visible within a package Q (e.g., by the inclusion of the
--                clause "use P.X;" in the context clause of package Q), and
--                the context clause for design unit R includes the clause
--                "use Q.all;", this does  not imply that X will be
--                potentially visible in R.  Only those entities that are
--                actually declared in package Q will be potentially 
--                visible in design unit R (in the absence of any other
--                use clauses).
--
--   Author(s) :  DBB
--   Notes     : 
----------------------------------------------------------------------------   

package P is
    type X is range 5 to 10;
end P;

use WORK.P;
use P.X;
package Q is
    -- verify that X is visible here
    constant Y: X;
end Q;

use WORK.Q;
use Q.all;
package R is
-- ERROR: X is not visible in Q.
    constant Z: X;
end R;

