----------------------------------------------------------------------------  
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  rgrce.10.009.ab.nt.002.vhdl
--   Title     :  IEEE Std 1076-1987 Language Reference Manual test
--   Purpose   :  Check that a declarative region is formed by the text of:
--                "A block statement."
--   Author(s) :  DBB
--   Notes     :  Do this by declaring a more than one generic with
--                the same name.
----------------------------------------------------------------------------   

entity ALIST1 is
end ALIST1;

architecture ALIST1 of ALIST1 is    

    signal G1: INTEGER;
    signal G2: INTEGER;
    signal A : INTEGER;
    signal B : INTEGER;
    signal S1: INTEGER;
    signal S2: INTEGER;

begin        

    ALIST1SUB:
        block
            generic (
                GS1: INTEGER := 3;
-- ERROR: duplicated generic name
                GS1: INTEGER := 9
            );
            generic map ( 3, 9 );
            port ( 
                PS1: out INTEGER;
                PS2: out INTEGER
            );
            port map ( S1, S2 );
        begin
            process
            begin
                PS1 <= GS1 + 1;
                PS2 <= GS1 + 2;
                wait;
            end process;
        end block ALIST1SUB;
    
end ALIST1;

