----------------------------------------------------------------------------  
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  rgrce.10.003.an.dy.003.vhdl
--   Title     :  IEEE Std 1076-1987 Language Reference Manual test
--   Purpose   :  Check that a declarative region is formed by the text of:
--                "An entity declaration, together with a corresponding
--                 architecture body."
--   Author(s) :  DBB
--   Notes     : 
----------------------------------------------------------------------------   

entity TEST_ENT is

    -- define a generic to be used elsewhere in the declarative region
    generic ( MID60S: INTEGER := 1965 );

    -- define a port to be used elsewhere in the declarative region
    port ( BITPORT: inout BIT );

    -- define a subtype to be used elsewhere in the declarative region
    subtype SIXTIES is INTEGER range 1960 to 1969;

    -- use generic and subtype inside entity_declarative_part
    signal EDP_SIGNAL: SIXTIES := MID60S;
    signal LATE60S   : SIXTIES := MID60S + 2;

begin

    -- use identifiers in entity_statement_part

    -- use EDP_SIGNAL
    assert ( ( EDP_SIGNAL >= SIXTIES'low ) and ( EDP_SIGNAL <= SIXTIES'high ) )
        report "EDP_SIGNAL out of bounds."
        severity FAILURE;

    -- use LATE60S
    assert ( LATE60s > MID60S )
        report "LATE60S is low."
        severity WARNING;

    -- use BITPORT
    assert ( ( BITPORT = '0' ) or ( BITPORT = '1' ) )
        report "BITPORT out of bounds."
        severity FAILURE;

end TEST_ENT;

----------------------------------------------------------------------------   

architecture TEST_ARC of TEST_ENT is

-- ERROR: reuse name in same declarative region
    signal EDP_SIGNAL: SIXTIES := MID60S - 2;

begin


end TEST_ARC;

