
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e9.09.th.ck.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the value of signal GUARD does not implicitly
--                extend to design entities bound to components instantiated
--                within a block.  Should result in an error.
--
--   Author(s) :  KES          
--
--   Remarks   :  
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity COMP is

end COMP;

architecture COMP_BEHAVIOR of COMP is

begin
   -- Error:  Should NOT be able to refer to GUARD within this architecture.
    assert( GUARD );
end COMP_BEHAVIOR;

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

    -- Component declarations.
    component comp
    end component;

begin

    TEST_BLOCK:  block( TRUE )
                 begin
                     C1: comp;
                 end block TEST_BLOCK;
end TEST_BEHAVIOR;

-------------------------------------------------------------------------
    
configuration BETA of TEST is

    for TEST_BEHAVIOR
        for TEST_BLOCK
            for C1: COMP use entity work.COMP (COMP_BEHAVIOR);
    
            end for;
        end for;
    end for;

end BETA;


    
    

         
