
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.44.th.te.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the base type of the expression on the right hand side n
--                of an aggregate variable assignment statement must be the same type   
--                as the base type of the aggregate which is being assigned.  All 
--                variable assignments in this file should result in errors.
--
--   Author(s) :  KES          
--
--   Remarks   :  
--
-- ---------------------------------------------------------------------------

-- Define this package for the types to be used in our tests.
package TEST2_PACK is

   -- Type declarations.
   subtype     BV1  is BIT_VECTOR( 0 to 0 );
   subtype     CH1  is STRING( 1 to 1 );
   subtype     BV2  is BIT_VECTOR( 0 to 1 );
   subtype     CH2  is STRING( 1 to 2 );
   subtype     BV3  is BIT_VECTOR( 0 to 2 );
   subtype     CH3  is STRING( 1 to 3 );
end TEST2_PACK;

package body TEST2_PACK is
end TEST2_PACK;



------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
use work.TEST2_PACK.all;
architecture TEST_BEHAVIOR of TEST is
begin

    TEST_PROCESS:  process

                       -- local variables
                       variable BIT1     : BV1 := B"1";      
                       variable STR1     : CH1 := "a";
                       variable BITV     : BV2 := B"11";      
                       variable STRV     : CH2 := "ab";
                       variable BIT3     : BV3 := B"111";      
                       variable STR3     : CH3 := "abc";

                       variable S        : BIT;
                       variable T        : BIT;
               
                       variable C1, C2   : CHARACTER;

                   begin
                       -- Illegal assignments.
                       -- A. too MANY values in expression.
                       ( S, T )  := BIT3;
                       ( C1,C2 ) := STR3;

                       -- B. too FEW values in expression.
                       ( S, T )  := BIT1;
                       ( C1,C2 ) := STR1;

                       -- C. Different base types.
                       ( S, T )  := STRV;
                       ( C1,C2 ) := BITV;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
