
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.44.if.pe.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the target of an aggregate variable assignment statement
--                must be determinable from the context, excluding the aggregate
--                itself, but including the fact that the type of the aggregate
--                must be a composite type.
--
--   Author(s) :  KES          
--
--   Remarks   :  In language simpler than the LRM, this states that basically
--                an aggregate variable assignment statement needs to be able to
--                figure out the base type of the target.  The only place from
--                which it can induce this type is the right hand side of the
--                target.  It therefore follows that the right hand side of the
--                target must be a value whose base type can easily be determined.
--                This could be either:
--                   o An object.
--                   o A function return value.
--                   o A qualified expression.
--
--                This leaves out the following possibilities:
--                   o An unqualified aggregate.
--                   o A literal string or bitstring.
--                
--                In this file we will test the latter.
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is
begin

    TEST_PROCESS:  process
                       -- Local variables.
                       variable S, T   : BIT;
                       variable C1, C2 : CHARACTER;

                   begin
                       -- Illegal assignments.
                       ( S, T )  := ( '1', '0' );
                       ( S, T )  := X"3"        ;
                       ( S, T )  := O"3"        ;
                       ( S, T )  := B"11"       ;

                       ( C1,C2 ) := ( 'a', 'b' );
                       ( C1,C2 ) := "ab"        ;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
