
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.27.th.rd.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Check that the base type of the time expression in each waveform
--                element must be the predefined physical type TIME as defined in
--                package standard.
--
--   Author(s) :  KES          
--
--   Remarks   :                                
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is
    -- enumerated types.
    type    SWITCH_LEVEL is ('0', '1', 'X');
    subtype LOGIC_SWITCH is SWITCH_LEVEL range '0' to '1';

    -- integer types.
    type POSITIVE        is range 0 to INTEGER'HIGH;

    -- user defined physical types.
    type DISTANCE is range 0 to 1E9
        units
            -- Base units.
            A;                    -- angstrom
 
            -- Metric lengths.
            nm       = 10 A;      -- nanometer
            um       = 1000 nm;   -- micrometer (or micron)
            mm       = 1000 um;   -- millimeter
            cm       = 10 mm;     -- centimeter
--          m        = 100 cm;    -- meter
 
            -- English lengths.
            mil      = 254000 A;  -- mil
            inch     = 1000 mil;  -- inch
--          ft       = 12 inch;   -- foot
--          yd       = 3 ft;      -- yard
        end units;

    -- floating point types.
    type POSITIVE_R    is range 0.0 to REAL'HIGH;

    -- array types.
    type MEMORY is array(INTEGER range <>) of BIT;
    type WORD   is array(0 to 31) of BIT;
    type BYTE   is array(7 downto 0) of BIT;

    -- record types.
    type DATE is
        record
           DAY           : INTEGER range 1 to 31;
           MONTH         : INTEGER range 1 to 12;
           YEAR          : INTEGER range -10000 to 1988;
        end record;

    -- Our simple signal.
    signal   S         : BIT;

begin

    TEST_PROCESS:  process
                       -- Variables of all types but TIME.
                        variable SWITCHVAR : SWITCH_LEVEL;
                        variable LOGICVAR  : LOGIC_SWITCH;
                        variable CHARVAR   : CHARACTER;
                        variable BOOLVAR   : BOOLEAN;
                        variable SEVERVAR  : SEVERITY_LEVEL;
                        variable INTVAR    : INTEGER;
                        variable POSVAR    : POSITIVE;
                        variable DISTVAR   : DISTANCE;
                        variable REALVAR   : REAL;
                        variable POSRVAR   : POSITIVE_R;
                        variable BYTEVAR   : BYTE;
                        variable RECVAR    : DATE;
                   begin
                       -- Each signal assignment should be an error.
                       S <= '1' after SWITCHVAR;  -- ERROR:
                       S <= '1' after LOGICVAR;   -- ERROR:
                       S <= '1' after CHARVAR;    -- ERROR:
                       S <= '1' after BOOLVAR;    -- ERROR:
                       S <= '1' after SEVERVAR;   -- ERROR:
                       S <= '1' after INTVAR;     -- ERROR:
                       S <= '1' after POSVAR;     -- ERROR:
                       S <= '1' after DISTVAR;    -- ERROR:
                       S <= '1' after REALVAR;    -- ERROR:
                       S <= '1' after POSRVAR;    -- ERROR:
                       S <= '1' after BYTEVAR;    -- ERROR:
                       S <= '1' after RECVAR;     -- ERROR:
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
