
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.22.th.te.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the base type of the value component of each transaction
--                produced by a waveform element on the right-hand side of an aggregate
--                signal assignment statement must be the same as the base type
--                of the aggregate which is being assigned.  All signals assignments
--                in this file should result in errors.
--
--   Author(s) :  KES          
--
--   Remarks   :  
--
-- ---------------------------------------------------------------------------

-- Define this package for the types to be used in our tests.
package TEST2_PACK is

   -- Type declarations.
   subtype     BV1  is BIT_VECTOR( 0 to 0 );
   subtype     CH1  is STRING( 1 to 1 );
   subtype     BV2  is BIT_VECTOR( 0 to 1 );
   subtype     CH2  is STRING( 1 to 2 );
   subtype     BV3  is BIT_VECTOR( 0 to 2 );
   subtype     CH3  is STRING( 1 to 3 );
end TEST2_PACK;

package body TEST2_PACK is
end TEST2_PACK;



------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
use work.TEST2_PACK.all;
architecture TEST_BEHAVIOR of TEST is
    -- Local signals.
    signal S       : BIT;
    signal T       : BIT;

    signal C1, C2  : CHARACTER;

begin

    TEST_PROCESS:  process

                       -- local variables
                       variable BIT1     : BV1 := B"1";      
                       variable STR1     : CH1 := "a";
                       variable BITV     : BV2 := B"11";      
                       variable STRV     : CH2 := "ab";
                       variable BIT3     : BV3 := B"111";      
                       variable STR3     : CH3 := "abc";
                       variable ShouldBeTime : TIME;

                   begin
                       -- Illegal assignments.
                       -- A. too MANY values in waveform.
                       ( S, T )  <= BIT3 after 20ns;
                       ( C1,C2 ) <= STR3 after 20ns;

                       -- B. too FEW values in waveform.
                       ( S, T )  <= BIT1 after 20ns;
                       ( C1,C2 ) <= STR1 after 20ns;

                       -- C. Different base types.
                       ( S, T )  <= STRV after 20ns;
                       ( C1,C2 ) <= BITV after 20ns;

                       -- D. Make sure it type-checks all elements of waveform.
                       ( S, T )  <= BITV after 20ns, STRV after 40ns;
                       ( C1,C2 ) <= STRV after 20ns, BITV after 40ns;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
