
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.22.if.pe.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the target of an aggregate signal assignment statement
--                must be determinable from the context, excluding the aggregate
--                itself, but including the fact that the type of the aggregate
--                must be a composite type.
--
--   Author(s) :  KES          
--
--   Remarks   :  In language simpler than the LRM, this states that basically
--                an aggregate signal assignment statement needs to be able to
--                figure out the base type of the target.  The only place from
--                which it can induce this type is the right hand side of the
--                target.  It therefore follows that the right hand side of the
--                target must be a value whose base type can easily be determined.
--                This could be either:
--                   o An object.
--                   o A function return value.
--                   o A qualified expression.
--
--                This leaves out the following possibilities:
--                   o An unqualified aggregate.
--                   o A literal string or bitstring.
--                
--                In this file we will test the latter.
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is
    -- Local signals.
    signal S       : BIT;
    signal T       : BIT;

    signal C1, C2  : CHARACTER;

begin

    TEST_PROCESS:  process

                   begin
                       -- Illegal assignments.
                       ( S, T )  <= ( '1', '0' ) after 10ns;
                       ( S, T )  <= X"3"         after 10ns;
                       ( S, T )  <= O"3"         after 10ns;
                       ( S, T )  <= B"11"        after 10ns;

                       ( C1,C2 ) <= ( 'a', 'b' ) after 10ns;
                       ( C1,C2 ) <= "ab"         after 10ns;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
