
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.22.fu.al.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that each expression in the target aggregate must be a locally
--                static name which denotes a signal.
--
--   Author(s) :  KES          
--
--   Remarks   :  
--
-- ---------------------------------------------------------------------------

-- Define this package for the types to be used in our tests.
package TEST2_PACK is

   -- Type declarations.
   subtype     BV2  is BIT_VECTOR( 0 to 1 );
   subtype     CH2  is STRING( 1 to 2 );
end TEST2_PACK;

package body TEST2_PACK is
end TEST2_PACK;



------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is
    
    component TEST
        generic ( GEN : in INTEGER );
    end component;

begin                   

    C1: TEST generic map ( 1 );

end TEST_BEHAVIOR;

-------------------------------------------------------------------------
    
entity TEST_MOD is

    generic ( GEN : in INTEGER );

end TEST_MOD;

-------------------------------------------------------------------------
    
use work.TEST2_PACK.all;
architecture TEST_BEHAVIOR of TEST_MOD is
    -- Local signals.
    signal S       : BV2;
    signal T       : BV2;

begin

    TEST_PROCESS:  process

                       -- local variables
                       variable BITV     : BV2 := B"11";      
                       variable STRV     : CH2 := "bb";
                       variable I        : INTEGER := 1;
                       variable C1, C2   : CHARACTER;

                   begin
                       -- Assignment to a globally static aggregate.  ERROR:
                       ( S( GEN ), T( GEN ) ) <= BITV after 20ns;

                       -- Assignment to a non-static aggregate.  ERROR:
                       ( S( I ), T( I ) ) <= BITV after 20ns;

                       -- Assign to a non-signal.  ERROR:
                       ( C1,C2 ) <= STRV after 20ns;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
