
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.21.if.me.1.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the target of a signal assignment statement must be 
--                of the same type as the value component of each transaction in the
--                expected output waveform.  Each signal assignment statement
--                should result in a compilation error.
--
--   Author(s) :  KES          
--
--   Remarks   :                            
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is
    -- Local signals.
    signal S       : BIT;

begin

    TEST_PROCESS:  process
                       -- local types.
                       type ACCESST is ACCESS BIT;
                       type RECORDT is
                           RECORD
                               Field1   : BIT;
                               Field2   : BIT;
                           END RECORD;

                       type DISTANCE is range 0 to 1E9
                           units
                               -- Base units.
                               A;                    -- angstrom
 
                               -- Metric lengths.
                               nm       = 10 A;      -- nanometer
                               um       = 1000 nm;   -- micrometer (or micron)
                               mm       = 1000 um;   -- millimeter
                               cm       = 10 mm;     -- centimeter
 
                               -- English lengths.
                               mil      = 254000 A;  -- mil
                               inch     = 1000 mil;  -- inch
                           end units;

                       -- local variables
                       variable ACCESSV   : ACCESST;
                       variable RECORDV   : RECORDT;
                       variable DISTV     : DISTANCE := 1A;

                   begin
                       -- Illegal assignments.
                       S <= transport 'X';
                       S <= transport NOTE;
                       S <= transport TRUE;
                       S <= transport 10fs;
                       S <= transport DISTV;
                       S <= transport (14);
                       S <= transport 14.0;
                       S <= transport B"11";
                       S <= transport X"1";
                       S <= transport ( '1', '0' );
                       S <= transport ACCESSV;
                       S <= transport RECORDV;

                       -- Make sure that ALL waveform elements are checked.
                       S <= '1' after 10ns,
                            '0' after 20ns,
                            'X' after 30ns;         -- ERROR
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
