
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.03.th.re.4.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Test wait statements.
--                - Test illegal semantics in the timeout_clause.  These
--                  are:
--                  1) Non-time expression.
--                  2) Undefined signal or variable in the expression.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

    port ( signal I         : in BIT;   --  input ports
           signal O         :out BIT ); -- output ports

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- user defined physical types.
                       type DISTANCE is range 0 to 1E9
                           units
                               -- Base units.
                               A;                    -- angstrom
 
                               -- Metric lengths.
                               nm       = 10 A;      -- nanometer
                               um       = 1000 nm;   -- micrometer (or micron)
                               mm       = 1000 um;   -- millimeter
                               cm       = 10 mm;     -- centimeter
--                             m        = 100 cm;    -- meter
 
                               -- English lengths.
                               mil      = 254000 A;  -- mil
                               inch     = 1000 mil;  -- inch
--                             ft       = 12 inch;   -- foot
--                             yd       = 3 ft;      -- yard
                           end units;
 
                       type WORD is ARRAY( 0 to 31 ) of BIT;

                       -- Local declarations.
                       variable j      : integer;
                       variable d      : DISTANCE;
                       variable t      : TIME;
                       variable R      : REAL;
                       variable ARR    : WORD;
                       variable S      : SEVERITY_LEVEL;

                   begin
                       -- 1. Non-time expressions.
                       wait for (j + j);  -- ERROR:
                       wait for (i);      -- ERROR:
                       wait for (d);      -- ERROR:
                       wait for (1A);     -- ERROR:
                       wait for (r);      -- ERROR:
                       wait for (s);      -- ERROR:
                       wait for (arr);    -- ERROR:

                       -- 2. Undefined identifier in condition.
                       wait for (t + t1); -- ERROR:

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
