
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.03.th.re.3.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Test wait statements.
--                - Test illegal semantics in the condition_clause.  These
--                  are:
--                  1) Non-boolean expression.
--                  2) Undefined signal or variable in the condition.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

    port ( signal I         : in BIT;   --  input ports
           signal O         :out BIT ); -- output ports

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- user defined physical types.
                       type DISTANCE is range 0 to 1E9
                           units
                               -- Base units.
                               A;                    -- angstrom
 
                               -- Metric lengths.
                               nm       = 10 A;      -- nanometer
                               um       = 1000 nm;   -- micrometer (or micron)
                               mm       = 1000 um;   -- millimeter
                               cm       = 10 mm;     -- centimeter
--                             m        = 100 cm;    -- meter
 
                               -- English lengths.
                               mil      = 254000 A;  -- mil
                               inch     = 1000 mil;  -- inch
--                             ft       = 12 inch;   -- foot
--                             yd       = 3 ft;      -- yard
                           end units;

                       type WORD is array( 0 to 31 ) of BIT;

                       -- Local declarations.
                       variable j      : integer;
                       variable d      : DISTANCE;
                       variable t      : TIME;
                       variable R      : REAL;
                       variable ARR    : WORD;
                       variable S      : SEVERITY_LEVEL;

                   begin
                       -- 1. Non-boolean expressions.
                       wait until (j + j);  -- ERROR:
                       wait until (i);      -- ERROR:
                       wait until (d);      -- ERROR:
                       wait until (1A);     -- ERROR:
                       wait until (t);      -- ERROR:
                       wait until (60ns);   -- ERROR:
                       wait until (r);      -- ERROR:
                       wait until (s);      -- ERROR:
                       wait until (ARR);    -- ERROR:

                       -- 2. Undefined identifier in condition.
                       wait until (d = d1); -- ERROR:

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
