
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e8.03.th.re.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Test wait statements.
--                - If any of the [sensitivity_clause], [condition_clause],
--                  or [timeout_clause] is out of order, an error should be
--                  detected by the VHDL compiler.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

    port ( signal I         : in BIT;   --  input ports
           signal O         :out BIT ); -- output ports

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- Local declarations.
                       variable j      : integer;

                   begin
                       -- Condition before sensitivity.  ERROR:
                       wait until (j = 1) on i;

                       -- Timeout before sensitivity.  ERROR:
                       wait for 60ns on i;

                       -- Timeout before condition.   ERROR:
                       wait for 60ns until (j = 1);

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
