
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e7.36.in.pe.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that certain incompatible operands may not be multiplied
--                or divided, according to the table defined in the LRM.
--                All expressions in this file should result in an error
--                message by the VHDL compiler.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- user defined physical types.
                       type DISTANCE is range 0 to 1E9
                           units
                               -- Base units.
                               A;                    -- angstrom
 
                               -- Metric lengths.
                               nm       = 10 A;      -- nanometer
                               um       = 1000 nm;   -- micrometer (or micron)
                               mm       = 1000 um;   -- millimeter
                               cm       = 10 mm;     -- centimeter
--                             m        = 100 cm;    -- meter
 
                               -- English lengths.
                               mil      = 254000 A;  -- mil
                               inch     = 1000 mil;  -- inch
--                             ft       = 12 inch;   -- foot
--                             yd       = 3 ft;      -- yard
                           end units;

                       -- Local declarations.
                       variable INTV    : INTEGER;
                       variable REALV   : REAL;
                       variable DISTV   : DISTANCE;
                       variable TIMEV   : TIME;

                   begin
                       -- Test dividing an integer by a physical type.  
                       INTV := INTV / DISTV;   -- ERROR:
                       INTV := INTV / TIMEV;   -- ERROR:

                       -- Test dividing a real by a physical type.  
                       REALV := REALV / DISTV; -- ERROR:
                       REALV := REALV / TIMEV; -- ERROR:

                       -- Test multiplying two different physical types.
                       INTV  := DISTV * TIMEV; -- ERROR:

                       -- Try dividing them.
                       INTV := DISTV / TIMEV;  -- ERROR:

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
