 
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e7.32.th.ng.2.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the operators "*" and "/" are not predefined for 
--                mixing floating point types with integer types.  Each such 
--                expression within this file should result in an error.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- All different type declarations.
                       -- integer types.
                       type POSITIVE        is range 0 to INTEGER'HIGH;

                       -- floating point types.
                       type POSITIVE_R    is range 0.0 to REAL'HIGH;

                       -- Local declarations.
                       variable INTV    : INTEGER      := 0;
                       variable POSV    : POSITIVE     := 0;
                       variable REALV   : REAL         := 0.0;
                       variable POSRV   : POSITIVE_R   := 0.0;


                   begin
                       -- All these expressions should result in an error.
                       assert ((INTV * REALV) = REALV);      -- ERROR:
                       assert ((INTV / REALV) = REALV);      -- ERROR:
                       assert ((INTV * POSRV) = POSRV);      -- ERROR:
                       assert ((INTV / POSRV) = POSRV);      -- ERROR:
                       assert ((POSV * REALV) = REALV);      -- ERROR:
                       assert ((POSV / REALV) = REALV);      -- ERROR:
                       assert ((POSV * POSRV) = POSRV);      -- ERROR:
                       assert ((POSV / POSRV) = POSRV);      -- ERROR:
                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
