
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e7.32.fo.pe.1.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the operators mod and rem are not predefined ONLY
--                for the type INTEGER.  All other types should result in an 
--                error reported by the compiler.       
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- All different non-numeric type declarations.
                       -- enumerated types.
                       type    SWITCH_LEVEL is ('0', '1', 'X');
                       subtype LOGIC_SWITCH is SWITCH_LEVEL range '0' to '1';

                       -- Floating point types.
                       type POSITIVE_R    is range 0.0 to REAL'HIGH;

                       -- user defined physical types.
                       type DISTANCE is range 0 to 1E9
                           units
                               -- Base units.
                               A;                    -- angstrom
 
                               -- Metric lengths.
                               nm       = 10 A;      -- nanometer
                               um       = 1000 nm;   -- micrometer (or micron)
                               mm       = 1000 um;   -- millimeter
                               cm       = 10 mm;     -- centimeter
 
                               -- English lengths.
                               mil      = 254000 A;  -- mil
                               inch     = 1000 mil;  -- inch
                           end units;

                       -- array types.
                       type MEMORY is array(INTEGER range <>) of BIT;
                       type WORD   is array(0 to 31) of BIT;
                       type BYTE   is array(7 downto 0) of BIT;

                       -- record types.
                       type DATE is
                           record
                              DAY           : INTEGER range 1 to 31;
                              MONTH         : INTEGER range 1 to 12;
                              YEAR          : INTEGER range -10000 to 1988;
                           end record;

                       -- access types.
                       type ADDRESS  is access MEMORY;
                       type WORDPTR  is access WORD;

                       -- file types.
                       type FileType is file of BIT;

                       -- Local declarations.
                       variable SWITCHV : SWITCH_LEVEL := '0';
                       variable LOGICV  : LOGIC_SWITCH := '0';
                       variable CHARV   : CHARACTER    := '0';
                       variable BITV    : BIT          := '0';
                       variable BOOLV   : BOOLEAN      := FALSE;
                       variable SEVERV  : SEVERITY_LEVEL := NOTE;
                       variable REALV   : REAL;
                       variable POSRV   : POSITIVE_R;
                       variable DISTV   : DISTANCE;
                       variable TIMEV   : TIME;
                       variable MEMORYV : MEMORY( 0 to 31 );
                       variable WORDV, WORD2V   : WORD;
                       variable BYTEV   : BYTE;
                       variable STRINGV : STRING( 0 to 31 );
                       variable BITSTRV : BIT_VECTOR( 0 to 31 );
                       variable RECV    : DATE;
                       variable ADDRESSV: ADDRESS;
                       variable WORDPTRV,
                                WORDPTR2V: WORDPTR;
                       file     FILEV   : FileType is "input_file";
                       variable Temp    : BOOLEAN;

                   begin
                       -- Verify that enumerated types may not be added or subtracted.
                       assert ((SWITCHV mod '1') = '0');
                       assert ((LOGICV mod SWITCHV) = '0');
                       assert ((LOGICV mod '0') = '1');
                       assert ((SWITCHV rem '1') = '0');
                       assert ((LOGICV rem SWITCHV) = '0');
                       assert ((LOGICV rem '0') = '1');

                       -- Same for character types.
                       assert ((NUL mod CHARV) = CHARV);
                       assert (('0' mod '2') = '2');
                       assert ((NUL rem CHARV) = CHARV);
                       assert (('0' rem '2') = '2');

                       -- Same for bit-types.
                       assert ((BITV mod BITV) = '1');
                       assert ((BITV mod '1') = '1');
                       assert ((BITV rem '0') = BITV);
                       assert ((BITV rem '1') = '0');

                       -- Same for boolean types.
                       assert ((BOOLV mod BOOLV) = TRUE);
                       assert ((BOOLV mod TRUE) = TRUE);
                       assert ((BOOLV rem FALSE) = BOOLV);
                       assert ((BOOLV rem TRUE) = FALSE);

                       -- Same for SEVERITY_LEVEL types.
                       assert ((SEVERV mod SEVERV) = WARNING);
                       assert ((SEVERV mod WARNING) = WARNING);
                       assert ((SEVERV rem NOTE) = SEVERV);
                       assert ((SEVERV rem WARNING) = NOTE);

                       -- Test floating point types now.
                       assert ((REALV mod 3.0) = POSRV);
                       assert ((POSRV mod REALV) = REALV);

                       -- Test user-defined physical types now.
                       assert ((DISTV mod 1A) = 1A);
                       assert ((4nm mod 1A) = DISTV);

                       -- Test the predefined physical type TIME.
                       assert ((TIMEV mod 1ns) = 1ns);
                       assert ((4sec mod 1ns) = TIMEV);

                       -- Test array types now.
                       assert ((MEMORYV mod MEMORYV) = MEMORYV);
                       assert ((WORDV rem WORDV) = WORDV);
                       assert ((BYTEV rem BYTEV) = BYTEV);

                       -- Test string types.
                       assert ((STRINGV mod "hello, world") = "bust");
                       assert (("goodbye, world" mod "hello, world") = "bust");
                       assert ((STRINGV rem "hello, world") = "bust");
                       assert (("goodbye, world" rem "hello, world") = "bust");

                       -- Bit vector types.
                       assert ((BITSTRV mod X"7777") = O"1313");
                       assert ((B"1010101010" mod X"FFFF") = O"7777");
                       assert ((BITSTRV rem X"7777") = O"1313");
                       assert ((B"1010101010" rem X"FFFF") = O"7777");

                       -- Record types.
                       assert ((RECV mod ( DAY => 14, MONTH => 2, YEAR => 1988 )) = RECV);
                       assert ((RECV rem ( DAY => 14, MONTH => 2, YEAR => 1988 )) = RECV);

                       -- Access types.
                       assert ((ADDRESSV mod NULL) = ADDRESSV);
                       assert ((WORDPTRV mod WORDPTR2V) = NULL);
                       assert ((ADDRESSV rem NULL) = ADDRESSV);
                       assert ((WORDPTRV rem WORDPTR2V) = NULL);

                       -- File types.
                       assert ((FILEV mod FILEV) = FILEV);
                       assert ((FILEV rem FILEV) = FILEV);

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
