
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e7.24.th.ng.3.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Verify that the operators "+" and "-" cannot legally operate      
--                on numeric values of different types.  We will iterate
--                through all different possible combinations of types and
--                each expression should result in an error detected by the
--                compiler.
--
--   Author(s) :  KES          
--
--   Remarks   :
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- All different type declarations.
                       -- integer types.
                       type POSITIVE        is range 0 to INTEGER'HIGH;

                       -- user defined physical types.
                       type DISTANCE is range 0 to 1E9
                           units
                               -- Base units.
                               A;                    -- angstrom
 
                               -- Metric lengths.
                               nm       = 10 A;      -- nanometer
                               um       = 1000 nm;   -- micrometer (or micron)
                               mm       = 1000 um;   -- millimeter
                               cm       = 10 mm;     -- centimeter
--                             m        = 100 cm;    -- meter
 
                               -- English lengths.
                               mil      = 254000 A;  -- mil
                               inch     = 1000 mil;  -- inch
--                             ft       = 12 inch;   -- foot
--                             yd       = 3 ft;      -- yard
                           end units;

                       -- floating point types.
                       type POSITIVE_R    is range 0.0 to REAL'HIGH;

                       -- Local declarations.
                       variable INTV    : INTEGER      := 0;
                       variable POSV    : POSITIVE     := 0;
                       variable DISTV   : DISTANCE     := 1 A;
                       variable TIMEV   : TIME         := 1 ns;
                       variable REALV   : REAL         := 0.0;
                       variable POSRV   : POSITIVE_R   := 0.0;


                   begin
                      -- INTEGER AND ALL DIFFERENT NUMERIC TYPES.
                      INTV := INTV + DISTV;                             -- BEGIN ERRORS.
                      INTV := INTV + TIMEV;
                      INTV := INTV + REALV;
                      INTV := INTV + POSRV;

                      -- CONSTRAINED INTEGER AND ALL DIFFERENT NUMERIC TYPES.
                      POSV := POSV + DISTV;
                      POSV := POSV + TIMEV;
                      POSV := POSV + REALV;
                      POSV := POSV + POSRV;

                      -- USER-DEFINED PHYSICAL TYPE AND ALL DIFFERENT NUMERIC TYPES.
                      DISTV := DISTV + TIMEV;
                      DISTV := DISTV + REALV;
                      DISTV := DISTV + POSRV;

                      -- PREDEFINED PHYSICAL TYPE TIME AND ALL DIFFERENT NUMERIC TYPES.
                      TIMEV := TIMEV + REALV;
                      TIMEV := TIMEV + POSRV;                           -- END ERRORS.

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
