
-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name :  e7.13.th.pe.0.vhdl
--   Title     :  TEST FOR VHDL 1076B LRM.
--
--   Purpose   :
--       --       Test cases in which the relational operators are used to
--                compare values whose types are different.  Each such comparison
--                should result in a semantic error.
--
--   Author(s) :  KES          
--
--   Remarks   :  
--       --       The last sentence of this paragraph has already been tested
--                implicitly in the "precedence" tests.
--                
--
--   Outstanding Issues:
--       --       
--
-- ---------------------------------------------------------------------------

------------------------------------------------------------------------

entity TEST is

end TEST;

-------------------------------------------------------------------------
    
architecture TEST_BEHAVIOR of TEST is

begin

    TEST_PROCESS:  process
                       -- All different type declarations.
                       -- enumerated types.
                       type    SWITCH_LEVEL is ('0', '1', 'X');
                       subtype LOGIC_SWITCH is SWITCH_LEVEL range '0' to '1';

                       -- integer types.
                       subtype POSITIVE is INTEGER range 0 to INTEGER'HIGH;

                       -- user defined physical types.
                       type DISTANCE is range 0 to 1E9
                           units
                               -- Base units.
                               A;                    -- angstrom
 
                               -- Metric lengths.
                               nm       = 10 A;      -- nanometer
                               um       = 1000 nm;   -- micrometer (or micron)
                               mm       = 1000 um;   -- millimeter
                               cm       = 10 mm;     -- centimeter
--                             m        = 100 cm;    -- meter
 
                               -- English lengths.
                               mil      = 254000 A;  -- mil
                               inch     = 1000 mil;  -- inch
--                             ft       = 12 inch;   -- foot
--                             yd       = 3 ft;      -- yard
                           end units;

                       -- floating point types.
                       subtype POSITIVE_R is REAL range 0.0 to REAL'HIGH;

                       -- array types.
                       type MEMORY is array(INTEGER range <>) of BIT;
                       type WORD   is array(0 to 31) of BIT;
                       type BYTE   is array(7 downto 0) of BIT;

                       -- record types.
                       type DATE is
                           record
                              DAY           : INTEGER range 1 to 31;
                              MONTH         : INTEGER range 1 to 12;
                              YEAR          : INTEGER range -10000 to 1988;
                           end record;

                       -- access types.
                       type ADDRESS  is access MEMORY;
                       type WORDPTR  is access WORD;

                       -- file types.
                       type FTY is file of BIT;

                       -- Local declarations.
                       variable SWITCHV : SWITCH_LEVEL := '0';
                       variable LOGICV  : LOGIC_SWITCH := '0';
                       variable CHARV   : CHARACTER    := '0';
                       variable BITV    : BIT          := '0';
                       variable BOOLV   : BOOLEAN      := FALSE;
                       variable SEVERV  : SEVERITY_LEVEL := NOTE;
                       variable INTV    : INTEGER      := 0;
                       variable POSV    : POSITIVE     := 0;
                       variable DISTV   : DISTANCE     := 1 A;
                       variable TIMEV   : TIME         := 1 ns;
                       variable REALV   : REAL         := 0.0;
                       variable POSRV   : POSITIVE_R   := 0.0;
                       variable MEMORYV : MEMORY( 0 to 10 );
                       variable WORDV   : WORD;
                       variable BYTEV   : BYTE;
                       variable STRINGV : STRING( 1 to 11 );
                       variable BITSTRV : BIT_VECTOR( 0 to 10 );
                       variable RECV    : DATE;
                       variable ADDRESSV: ADDRESS;
                       variable WORDPTRV: WORDPTR;
                       file     FILEV   : FTY is "input_file";
                       variable Temp    : BOOLEAN;

                   begin

                       -- Test comparing incompatible types.  Errors on each.
                       Temp := (SWITCHV = CHARV);       -- BEGIN ERRORS:
                       Temp := (SWITCHV = BITV);
                       Temp := (SWITCHV = BOOLV);
                       Temp := (SWITCHV = SEVERV);
                       Temp := (SWITCHV = INTV);
                       Temp := (SWITCHV = POSV);
                       Temp := (SWITCHV = DISTV);
                       Temp := (SWITCHV = TIMEV);
                       Temp := (SWITCHV = REALV);
                       Temp := (SWITCHV = POSRV);
                       Temp := (SWITCHV = MEMORYV);
                       Temp := (SWITCHV = WORDV);
                       Temp := (SWITCHV = BYTEV);
                       Temp := (SWITCHV = STRINGV);
                       Temp := (SWITCHV = BITSTRV);
                       Temp := (SWITCHV = RECV);
                       Temp := (SWITCHV = ADDRESSV);
                       Temp := (SWITCHV = WORDPTRV);
                       Temp := (SWITCHV = FILEV);
                       
                       Temp := (LOGICV = CHARV);
                       Temp := (LOGICV = BITV);
                       Temp := (LOGICV = BOOLV);
                       Temp := (LOGICV = SEVERV);
                       Temp := (LOGICV = INTV);
                       Temp := (LOGICV = POSV);
                       Temp := (LOGICV = DISTV);
                       Temp := (LOGICV = TIMEV);
                       Temp := (LOGICV = REALV);
                       Temp := (LOGICV = POSRV);
                       Temp := (LOGICV = MEMORYV);
                       Temp := (LOGICV = WORDV);
                       Temp := (LOGICV = BYTEV);
                       Temp := (LOGICV = STRINGV);
                       Temp := (LOGICV = BITSTRV);
                       Temp := (LOGICV = RECV);
                       Temp := (LOGICV = ADDRESSV);
                       Temp := (LOGICV = WORDPTRV);
                       Temp := (LOGICV = FILEV);
                       
                       Temp := (CHARV = BITV);
                       Temp := (CHARV = BOOLV);
                       Temp := (CHARV = SEVERV);
                       Temp := (CHARV = INTV);
                       Temp := (CHARV = POSV);
                       Temp := (CHARV = DISTV);
                       Temp := (CHARV = TIMEV);
                       Temp := (CHARV = REALV);
                       Temp := (CHARV = POSRV);
                       Temp := (CHARV = MEMORYV);
                       Temp := (CHARV = WORDV);
                       Temp := (CHARV = BYTEV);
                       Temp := (CHARV = STRINGV);
                       Temp := (CHARV = BITSTRV);
                       Temp := (CHARV = RECV);
                       Temp := (CHARV = ADDRESSV);
                       Temp := (CHARV = WORDPTRV);
                       Temp := (CHARV = FILEV);
                       
                       Temp := (BITV = BOOLV);
                       Temp := (BITV = SEVERV);
                       Temp := (BITV = INTV);
                       Temp := (BITV = POSV);
                       Temp := (BITV = DISTV);
                       Temp := (BITV = TIMEV);
                       Temp := (BITV = REALV);
                       Temp := (BITV = POSRV);
                       Temp := (BITV = MEMORYV);
                       Temp := (BITV = WORDV);
                       Temp := (BITV = BYTEV);
                       Temp := (BITV = STRINGV);
                       Temp := (BITV = BITSTRV);
                       Temp := (BITV = RECV);
                       Temp := (BITV = ADDRESSV);
                       Temp := (BITV = WORDPTRV);
                       Temp := (BITV = FILEV);
                       
                       Temp := (BOOLV = SEVERV);
                       Temp := (BOOLV = INTV);
                       Temp := (BOOLV = POSV);
                       Temp := (BOOLV = DISTV);
                       Temp := (BOOLV = TIMEV);
                       Temp := (BOOLV = REALV);
                       Temp := (BOOLV = POSRV);
                       Temp := (BOOLV = MEMORYV);
                       Temp := (BOOLV = WORDV);
                       Temp := (BOOLV = BYTEV);
                       Temp := (BOOLV = STRINGV);
                       Temp := (BOOLV = BITSTRV);
                       Temp := (BOOLV = RECV);
                       Temp := (BOOLV = ADDRESSV);
                       Temp := (BOOLV = WORDPTRV);
                       Temp := (BOOLV = FILEV);
                       
                       Temp := (SEVERV = INTV);
                       Temp := (SEVERV = POSV);
                       Temp := (SEVERV = DISTV);
                       Temp := (SEVERV = TIMEV);
                       Temp := (SEVERV = REALV);
                       Temp := (SEVERV = POSRV);
                       Temp := (SEVERV = MEMORYV);
                       Temp := (SEVERV = WORDV);
                       Temp := (SEVERV = BYTEV);
                       Temp := (SEVERV = STRINGV);
                       Temp := (SEVERV = BITSTRV);
                       Temp := (SEVERV = RECV);
                       Temp := (SEVERV = ADDRESSV);
                       Temp := (SEVERV = WORDPTRV);
                       Temp := (SEVERV = FILEV);
                       
                       Temp := (INTV = DISTV);
                       Temp := (INTV = TIMEV);
                       Temp := (INTV = REALV);
                       Temp := (INTV = POSRV);
                       Temp := (INTV = MEMORYV);
                       Temp := (INTV = WORDV);
                       Temp := (INTV = BYTEV);
                       Temp := (INTV = STRINGV);
                       Temp := (INTV = BITSTRV);
                       Temp := (INTV = RECV);
                       Temp := (INTV = ADDRESSV);
                       Temp := (INTV = WORDPTRV);
                       Temp := (INTV = FILEV);
                       
                       Temp := (POSV = DISTV);
                       Temp := (POSV = TIMEV);
                       Temp := (POSV = REALV);
                       Temp := (POSV = POSRV);
                       Temp := (POSV = MEMORYV);
                       Temp := (POSV = WORDV);
                       Temp := (POSV = BYTEV);
                       Temp := (POSV = STRINGV);
                       Temp := (POSV = BITSTRV);
                       Temp := (POSV = RECV);
                       Temp := (POSV = ADDRESSV);
                       Temp := (POSV = WORDPTRV);
                       Temp := (POSV = FILEV);
                       
                       Temp := (DISTV = TIMEV);
                       Temp := (DISTV = REALV);
                       Temp := (DISTV = POSRV);
                       Temp := (DISTV = MEMORYV);
                       Temp := (DISTV = WORDV);
                       Temp := (DISTV = BYTEV);
                       Temp := (DISTV = STRINGV);
                       Temp := (DISTV = BITSTRV);
                       Temp := (DISTV = RECV);
                       Temp := (DISTV = ADDRESSV);
                       Temp := (DISTV = WORDPTRV);
                       Temp := (DISTV = FILEV);
                       
                       Temp := (TIMEV = REALV);
                       Temp := (TIMEV = POSRV);
                       Temp := (TIMEV = MEMORYV);
                       Temp := (TIMEV = WORDV);
                       Temp := (TIMEV = BYTEV);
                       Temp := (TIMEV = STRINGV);
                       Temp := (TIMEV = BITSTRV);
                       Temp := (TIMEV = RECV);
                       Temp := (TIMEV = ADDRESSV);
                       Temp := (TIMEV = WORDPTRV);
                       Temp := (TIMEV = FILEV);
                       
                       Temp := (REALV = MEMORYV);
                       Temp := (REALV = WORDV);
                       Temp := (REALV = BYTEV);
                       Temp := (REALV = STRINGV);
                       Temp := (REALV = BITSTRV);
                       Temp := (REALV = RECV);
                       Temp := (REALV = ADDRESSV);
                       Temp := (REALV = WORDPTRV);
                       Temp := (REALV = FILEV);
                       
                       Temp := (POSRV = MEMORYV);
                       Temp := (POSRV = WORDV);
                       Temp := (POSRV = BYTEV);
                       Temp := (POSRV = STRINGV);
                       Temp := (POSRV = BITSTRV);
                       Temp := (POSRV = RECV);
                       Temp := (POSRV = ADDRESSV);
                       Temp := (POSRV = WORDPTRV);
                       Temp := (POSRV = FILEV);
                       
                       Temp := (MEMORYV = WORDV);
                       Temp := (MEMORYV = BYTEV);
                       Temp := (MEMORYV = STRINGV);
                       Temp := (MEMORYV = BITSTRV);
                       Temp := (MEMORYV = RECV);
                       Temp := (MEMORYV = ADDRESSV);
                       Temp := (MEMORYV = WORDPTRV);
                       Temp := (MEMORYV = FILEV);
                       
                       Temp := (WORDV = BYTEV);
                       Temp := (WORDV = STRINGV);
                       Temp := (WORDV = BITSTRV);
                       Temp := (WORDV = RECV);
                       Temp := (WORDV = ADDRESSV);
                       Temp := (WORDV = WORDPTRV);
                       Temp := (WORDV = FILEV);
                       
                       Temp := (BYTEV = STRINGV);
                       Temp := (BYTEV = BITSTRV);
                       Temp := (BYTEV = RECV);
                       Temp := (BYTEV = ADDRESSV);
                       Temp := (BYTEV = WORDPTRV);
                       Temp := (BYTEV = FILEV);
                       
                       Temp := (STRINGV = BITSTRV);
                       Temp := (STRINGV = RECV);
                       Temp := (STRINGV = ADDRESSV);
                       Temp := (STRINGV = WORDPTRV);
                       Temp := (STRINGV = FILEV);
                       
                       Temp := (BITSTRV = RECV);
                       Temp := (BITSTRV = ADDRESSV);
                       Temp := (BITSTRV = WORDPTRV);
                       Temp := (BITSTRV = FILEV);
                       
                       Temp := (RECV = ADDRESSV);
                       Temp := (RECV = WORDPTRV);
                       Temp := (RECV = FILEV);
                       
                       Temp := (ADDRESSV = WORDPTRV);
                       Temp := (ADDRESSV = FILEV);
                       
                       Temp := (WORDPTRV = FILEV);         -- END ERRORS:
                       
                       -- The following types SHOULD be compatible.
                       -- A. Enumerated type with a subrange.
                       Temp := (SWITCHV = LOGICV);
                       Temp := (SWITCHV /= LOGICV);
                       Temp := (SWITCHV < LOGICV);
                       Temp := (SWITCHV <= LOGICV);
                       Temp := (SWITCHV > LOGICV);
                       Temp := (SWITCHV >= LOGICV);

                       -- B. Integer with a subrange.
                       Temp := (INTV = POSV);
                       Temp := (INTV /= POSV);
                       Temp := (INTV < POSV);
                       Temp := (INTV <= POSV);
                       Temp := (INTV > POSV);
                       Temp := (INTV >= POSV);

                       -- C. Real with a subrange.
                       Temp := (REALV = POSRV);
                       Temp := (REALV /= POSRV);
                       Temp := (REALV < POSRV);
                       Temp := (REALV <= POSRV);
                       Temp := (REALV > POSRV);
                       Temp := (REALV >= POSRV);

                       wait;
                   end process TEST_PROCESS;

end TEST_BEHAVIOR;
             
