-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name : rgrce.02.021.it.am.001.vhdl
--   Title     : IEEE Std 1076-1987 Language Reference Manual test 
--
--   Purpose   : Check that reading 'stable, 'quiet, and 'delayed for an
--               INOUT signal in a subprogram generates an error
--
--   Author(s) : Mike Heck
--
--   Notes     : "It is an error if signal-valued attributes STABLE, QUIET, and
--                DELAYED of formal signal parameters of any mode are read
--                within a subprogram."
--
--               This test does not apply to functions because a function cannot
--               have an INOUT parameter (only IN parameters).
------------------------------------------------------------------------
entity E1 is
  procedure proc1 (signal S1: inout bit) is
    variable V1 : bit;
    variable V2, V3 : boolean;
  begin
-- ERROR: attribute DELAYED may not be read within a procedure
    V1 := S1'delayed;
-- ERROR: attribute STABLE may not be read within a procedure
    V2 := S1'stable;
-- ERROR: attribute QUIET may not be read within a procedure
    V3 := S1'quiet;
  end proc1;
end E1;

