-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name : rgrce.02.011.th.le.001.vhdl
--   Title     : IEEE Std 1076-1987 Language Reference Manual test 
--
--   Purpose   : Test syntax for formal parameters.
--
--   Author(s) : Mike Heck
--
--   Notes     : "The actual designator associated with a formal of class
--                variable must be a variable."
------------------------------------------------------------------------
entity E1 is
  function func1 (variable A:integer) return integer is
  begin
    if a > 0 then
      return 5;
    else
      return 0;
    end if;
  end func1;

  function func2 (signal S1 : integer) return integer is
    constant C1 : integer := 0;
    variable V1 : integer;
    variable V2 : integer;
  begin
    V1 := func1( V1 );
--ERROR: Actual corresponding to a formal of class variable must be a variable
    V1 := func1( S1 );
--ERROR: Actual corresponding to a formal of class variable must be a variable
    V1 := func1( C1 );
  end func2;
end E1;



















                                                                      

