-- ----------------------------------------------------------------------------
--                                     copyright 1988
--                                     Vantage Analysis Systems,Inc.
--                                       all rights reserved
--
--   File name : rgrce.02.011.in.al.001.vhdl
--   Title     : IEEE Std 1076-1987 Language Reference Manual test 
--
--   Purpose   : Test that a SIGNAL formal in a subprogram may not be associated
--               with a VARIABLE actual.
--
--   Author(s) : Mike Heck
--
--   Notes     : "In a subprogram call, the actual designator associated with a
--                formal parameter of class signal must be a signal."
------------------------------------------------------------------------
entity E1 is
  function func1 (signal A:integer) return integer is
  begin
    if a > 0 then
      return 5;
    else
      return 0;
    end if;
  end func1;

  function func2 (signal S1 : integer) return integer is
    variable V1 : integer := 0;
    variable V2 : integer := 0;
  begin
    V2 := func1( S1 );
    --ERROR: Actual corresponding to a formal of class signal must be a signal
    V2 := func1( V1 );
  end func2;
end E1;
