-------------------------------------------------------------------------------
 --
 --    Copyright (c) 1989 by Intermetrics, Inc.
 --                All rights reserved.
 --
-------------------------------------------------------------------------------
--
-- TEST NAME:
--
--    CT00612
--
-- AUTHOR:
--
--    G. Tominovich
--
-- TEST OBJECTIVES:
--
--    9.3 (3)
--
-- DESIGN UNIT ORDERING:
--
--    ENT00612(ARCH00612)
--    ENT00612_Test_Bench(ARCH00612_Test_Bench)
--
-- REVISION HISTORY:
--
--    24-AUG-1987   - initial revision
--
-- NOTES:
--
--    self-checking
--    automatically generated
--
use WORK.STANDARD_TYPES.all ;
entity ENT00612 is
   port (
        s_boolean : inout boolean
      ; s_bit : inout bit
      ; s_severity_level : inout severity_level
      ; s_character : inout character
      ; s_st_enum1 : inout st_enum1
      ; s_integer : inout integer
      ; s_st_int1 : inout st_int1
      ; s_time : inout time
      ; s_st_phys1 : inout st_phys1
      ; s_real : inout real
      ; s_st_real1 : inout st_real1
      ; s_st_rec1 : inout st_rec1
      ; s_st_rec2 : inout st_rec2
      ; s_st_rec3 : inout st_rec3
      ; s_st_arr1 : inout st_arr1
      ; s_st_arr2 : inout st_arr2
      ; s_st_arr3 : inout st_arr3
        ) ;
   subtype chk_sig_type is integer range -1 to 100 ;
   signal chk_boolean : chk_sig_type := -1 ;
   signal chk_bit : chk_sig_type := -1 ;
   signal chk_severity_level : chk_sig_type := -1 ;
   signal chk_character : chk_sig_type := -1 ;
   signal chk_st_enum1 : chk_sig_type := -1 ;
   signal chk_integer : chk_sig_type := -1 ;
   signal chk_st_int1 : chk_sig_type := -1 ;
   signal chk_time : chk_sig_type := -1 ;
   signal chk_st_phys1 : chk_sig_type := -1 ;
   signal chk_real : chk_sig_type := -1 ;
   signal chk_st_real1 : chk_sig_type := -1 ;
   signal chk_st_rec1 : chk_sig_type := -1 ;
   signal chk_st_rec2 : chk_sig_type := -1 ;
   signal chk_st_rec3 : chk_sig_type := -1 ;
   signal chk_st_arr1 : chk_sig_type := -1 ;
   signal chk_st_arr2 : chk_sig_type := -1 ;
   signal chk_st_arr3 : chk_sig_type := -1 ;
--
end ENT00612 ;
--
--
architecture ARCH00612 of ENT00612 is
   subtype chk_time_type is Time ;
   signal s_boolean_savt : chk_time_type := 0 ns ;
   signal s_bit_savt : chk_time_type := 0 ns ;
   signal s_severity_level_savt : chk_time_type := 0 ns ;
   signal s_character_savt : chk_time_type := 0 ns ;
   signal s_st_enum1_savt : chk_time_type := 0 ns ;
   signal s_integer_savt : chk_time_type := 0 ns ;
   signal s_st_int1_savt : chk_time_type := 0 ns ;
   signal s_time_savt : chk_time_type := 0 ns ;
   signal s_st_phys1_savt : chk_time_type := 0 ns ;
   signal s_real_savt : chk_time_type := 0 ns ;
   signal s_st_real1_savt : chk_time_type := 0 ns ;
   signal s_st_rec1_savt : chk_time_type := 0 ns ;
   signal s_st_rec2_savt : chk_time_type := 0 ns ;
   signal s_st_rec3_savt : chk_time_type := 0 ns ;
   signal s_st_arr1_savt : chk_time_type := 0 ns ;
   signal s_st_arr2_savt : chk_time_type := 0 ns ;
   signal s_st_arr3_savt : chk_time_type := 0 ns ;
--
   subtype chk_cnt_type is Integer ;
   signal s_boolean_cnt : chk_cnt_type := 0 ;
   signal s_bit_cnt : chk_cnt_type := 0 ;
   signal s_severity_level_cnt : chk_cnt_type := 0 ;
   signal s_character_cnt : chk_cnt_type := 0 ;
   signal s_st_enum1_cnt : chk_cnt_type := 0 ;
   signal s_integer_cnt : chk_cnt_type := 0 ;
   signal s_st_int1_cnt : chk_cnt_type := 0 ;
   signal s_time_cnt : chk_cnt_type := 0 ;
   signal s_st_phys1_cnt : chk_cnt_type := 0 ;
   signal s_real_cnt : chk_cnt_type := 0 ;
   signal s_st_real1_cnt : chk_cnt_type := 0 ;
   signal s_st_rec1_cnt : chk_cnt_type := 0 ;
   signal s_st_rec2_cnt : chk_cnt_type := 0 ;
   signal s_st_rec3_cnt : chk_cnt_type := 0 ;
   signal s_st_arr1_cnt : chk_cnt_type := 0 ;
   signal s_st_arr2_cnt : chk_cnt_type := 0 ;
   signal s_st_arr3_cnt : chk_cnt_type := 0 ;
--
   type select_type is range 1 to 3 ;
   signal boolean_select : select_type := 1 ;
   signal bit_select : select_type := 1 ;
   signal severity_level_select : select_type := 1 ;
   signal character_select : select_type := 1 ;
   signal st_enum1_select : select_type := 1 ;
   signal integer_select : select_type := 1 ;
   signal st_int1_select : select_type := 1 ;
   signal time_select : select_type := 1 ;
   signal st_phys1_select : select_type := 1 ;
   signal real_select : select_type := 1 ;
   signal st_real1_select : select_type := 1 ;
   signal st_rec1_select : select_type := 1 ;
   signal st_rec2_select : select_type := 1 ;
   signal st_rec3_select : select_type := 1 ;
   signal st_arr1_select : select_type := 1 ;
   signal st_arr2_select : select_type := 1 ;
   signal st_arr3_select : select_type := 1 ;
--
   procedure P1
      (signal s_boolean : in boolean ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_boolean_cnt is
         when 0
         => null ;
              -- s_boolean <= transport
              --   c_boolean_2 after 10 ns,
              --   c_boolean_1 after 20 ns ;
--
         when 1
         => correct :=
               s_boolean =
                 c_boolean_2 and
               (s_boolean_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_boolean =
                 c_boolean_1 and
               (s_boolean_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P1" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_boolean <= transport
              --   c_boolean_2 after 10 ns ,
              --   c_boolean_1 after 20 ns ,
              --   c_boolean_2 after 30 ns ,
              --   c_boolean_1 after 40 ns ;
--
         when 3
         => correct :=
               s_boolean =
                 c_boolean_2 and
               (s_boolean_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_boolean <= transport
              --   c_boolean_1 after 5 ns ;
--
         when 4
         => correct :=
               s_boolean =
                 c_boolean_1 and
               (s_boolean_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_boolean_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_boolean_cnt + 1 ;
--
   end ;
--
   procedure P2
      (signal s_bit : in bit ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_bit_cnt is
         when 0
         => null ;
              -- s_bit <= transport
              --   c_bit_2 after 10 ns,
              --   c_bit_1 after 20 ns ;
--
         when 1
         => correct :=
               s_bit =
                 c_bit_2 and
               (s_bit_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_bit =
                 c_bit_1 and
               (s_bit_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P2" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_bit <= transport
              --   c_bit_2 after 10 ns ,
              --   c_bit_1 after 20 ns ,
              --   c_bit_2 after 30 ns ,
              --   c_bit_1 after 40 ns ;
--
         when 3
         => correct :=
               s_bit =
                 c_bit_2 and
               (s_bit_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_bit <= transport
              --   c_bit_1 after 5 ns ;
--
         when 4
         => correct :=
               s_bit =
                 c_bit_1 and
               (s_bit_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_bit_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_bit_cnt + 1 ;
--
   end ;
--
   procedure P3
      (signal s_severity_level : in severity_level ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_severity_level_cnt is
         when 0
         => null ;
              -- s_severity_level <= transport
              --   c_severity_level_2 after 10 ns,
              --   c_severity_level_1 after 20 ns ;
--
         when 1
         => correct :=
               s_severity_level =
                 c_severity_level_2 and
               (s_severity_level_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_severity_level =
                 c_severity_level_1 and
               (s_severity_level_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P3" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_severity_level <= transport
              --   c_severity_level_2 after 10 ns ,
              --   c_severity_level_1 after 20 ns ,
              --   c_severity_level_2 after 30 ns ,
              --   c_severity_level_1 after 40 ns ;
--
         when 3
         => correct :=
               s_severity_level =
                 c_severity_level_2 and
               (s_severity_level_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_severity_level <= transport
              --   c_severity_level_1 after 5 ns ;
--
         when 4
         => correct :=
               s_severity_level =
                 c_severity_level_1 and
               (s_severity_level_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_severity_level_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_severity_level_cnt + 1 ;
--
   end ;
--
   procedure P4
      (signal s_character : in character ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_character_cnt is
         when 0
         => null ;
              -- s_character <= transport
              --   c_character_2 after 10 ns,
              --   c_character_1 after 20 ns ;
--
         when 1
         => correct :=
               s_character =
                 c_character_2 and
               (s_character_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_character =
                 c_character_1 and
               (s_character_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P4" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_character <= transport
              --   c_character_2 after 10 ns ,
              --   c_character_1 after 20 ns ,
              --   c_character_2 after 30 ns ,
              --   c_character_1 after 40 ns ;
--
         when 3
         => correct :=
               s_character =
                 c_character_2 and
               (s_character_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_character <= transport
              --   c_character_1 after 5 ns ;
--
         when 4
         => correct :=
               s_character =
                 c_character_1 and
               (s_character_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_character_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_character_cnt + 1 ;
--
   end ;
--
   procedure P5
      (signal s_st_enum1 : in st_enum1 ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_st_enum1_cnt is
         when 0
         => null ;
              -- s_st_enum1 <= transport
              --   c_st_enum1_2 after 10 ns,
              --   c_st_enum1_1 after 20 ns ;
--
         when 1
         => correct :=
               s_st_enum1 =
                 c_st_enum1_2 and
               (s_st_enum1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_st_enum1 =
                 c_st_enum1_1 and
               (s_st_enum1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P5" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_st_enum1 <= transport
              --   c_st_enum1_2 after 10 ns ,
              --   c_st_enum1_1 after 20 ns ,
              --   c_st_enum1_2 after 30 ns ,
              --   c_st_enum1_1 after 40 ns ;
--
         when 3
         => correct :=
               s_st_enum1 =
                 c_st_enum1_2 and
               (s_st_enum1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_st_enum1 <= transport
              --   c_st_enum1_1 after 5 ns ;
--
         when 4
         => correct :=
               s_st_enum1 =
                 c_st_enum1_1 and
               (s_st_enum1_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_st_enum1_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_st_enum1_cnt + 1 ;
--
   end ;
--
   procedure P6
      (signal s_integer : in integer ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_integer_cnt is
         when 0
         => null ;
              -- s_integer <= transport
              --   c_integer_2 after 10 ns,
              --   c_integer_1 after 20 ns ;
--
         when 1
         => correct :=
               s_integer =
                 c_integer_2 and
               (s_integer_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_integer =
                 c_integer_1 and
               (s_integer_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P6" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_integer <= transport
              --   c_integer_2 after 10 ns ,
              --   c_integer_1 after 20 ns ,
              --   c_integer_2 after 30 ns ,
              --   c_integer_1 after 40 ns ;
--
         when 3
         => correct :=
               s_integer =
                 c_integer_2 and
               (s_integer_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_integer <= transport
              --   c_integer_1 after 5 ns ;
--
         when 4
         => correct :=
               s_integer =
                 c_integer_1 and
               (s_integer_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_integer_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_integer_cnt + 1 ;
--
   end ;
--
   procedure P7
      (signal s_st_int1 : in st_int1 ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_st_int1_cnt is
         when 0
         => null ;
              -- s_st_int1 <= transport
              --   c_st_int1_2 after 10 ns,
              --   c_st_int1_1 after 20 ns ;
--
         when 1
         => correct :=
               s_st_int1 =
                 c_st_int1_2 and
               (s_st_int1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_st_int1 =
                 c_st_int1_1 and
               (s_st_int1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P7" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_st_int1 <= transport
              --   c_st_int1_2 after 10 ns ,
              --   c_st_int1_1 after 20 ns ,
              --   c_st_int1_2 after 30 ns ,
              --   c_st_int1_1 after 40 ns ;
--
         when 3
         => correct :=
               s_st_int1 =
                 c_st_int1_2 and
               (s_st_int1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_st_int1 <= transport
              --   c_st_int1_1 after 5 ns ;
--
         when 4
         => correct :=
               s_st_int1 =
                 c_st_int1_1 and
               (s_st_int1_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_st_int1_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_st_int1_cnt + 1 ;
--
   end ;
--
   procedure P8
      (signal s_time : in time ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_time_cnt is
         when 0
         => null ;
              -- s_time <= transport
              --   c_time_2 after 10 ns,
              --   c_time_1 after 20 ns ;
--
         when 1
         => correct :=
               s_time =
                 c_time_2 and
               (s_time_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_time =
                 c_time_1 and
               (s_time_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P8" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_time <= transport
              --   c_time_2 after 10 ns ,
              --   c_time_1 after 20 ns ,
              --   c_time_2 after 30 ns ,
              --   c_time_1 after 40 ns ;
--
         when 3
         => correct :=
               s_time =
                 c_time_2 and
               (s_time_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_time <= transport
              --   c_time_1 after 5 ns ;
--
         when 4
         => correct :=
               s_time =
                 c_time_1 and
               (s_time_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_time_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_time_cnt + 1 ;
--
   end ;
--
   procedure P9
      (signal s_st_phys1 : in st_phys1 ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_st_phys1_cnt is
         when 0
         => null ;
              -- s_st_phys1 <= transport
              --   c_st_phys1_2 after 10 ns,
              --   c_st_phys1_1 after 20 ns ;
--
         when 1
         => correct :=
               s_st_phys1 =
                 c_st_phys1_2 and
               (s_st_phys1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_st_phys1 =
                 c_st_phys1_1 and
               (s_st_phys1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P9" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_st_phys1 <= transport
              --   c_st_phys1_2 after 10 ns ,
              --   c_st_phys1_1 after 20 ns ,
              --   c_st_phys1_2 after 30 ns ,
              --   c_st_phys1_1 after 40 ns ;
--
         when 3
         => correct :=
               s_st_phys1 =
                 c_st_phys1_2 and
               (s_st_phys1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_st_phys1 <= transport
              --   c_st_phys1_1 after 5 ns ;
--
         when 4
         => correct :=
               s_st_phys1 =
                 c_st_phys1_1 and
               (s_st_phys1_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_st_phys1_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_st_phys1_cnt + 1 ;
--
   end ;
--
   procedure P10
      (signal s_real : in real ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_real_cnt is
         when 0
         => null ;
              -- s_real <= transport
              --   c_real_2 after 10 ns,
              --   c_real_1 after 20 ns ;
--
         when 1
         => correct :=
               s_real =
                 c_real_2 and
               (s_real_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_real =
                 c_real_1 and
               (s_real_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P10" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_real <= transport
              --   c_real_2 after 10 ns ,
              --   c_real_1 after 20 ns ,
              --   c_real_2 after 30 ns ,
              --   c_real_1 after 40 ns ;
--
         when 3
         => correct :=
               s_real =
                 c_real_2 and
               (s_real_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_real <= transport
              --   c_real_1 after 5 ns ;
--
         when 4
         => correct :=
               s_real =
                 c_real_1 and
               (s_real_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_real_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_real_cnt + 1 ;
--
   end ;
--
   procedure P11
      (signal s_st_real1 : in st_real1 ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_st_real1_cnt is
         when 0
         => null ;
              -- s_st_real1 <= transport
              --   c_st_real1_2 after 10 ns,
              --   c_st_real1_1 after 20 ns ;
--
         when 1
         => correct :=
               s_st_real1 =
                 c_st_real1_2 and
               (s_st_real1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_st_real1 =
                 c_st_real1_1 and
               (s_st_real1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P11" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_st_real1 <= transport
              --   c_st_real1_2 after 10 ns ,
              --   c_st_real1_1 after 20 ns ,
              --   c_st_real1_2 after 30 ns ,
              --   c_st_real1_1 after 40 ns ;
--
         when 3
         => correct :=
               s_st_real1 =
                 c_st_real1_2 and
               (s_st_real1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_st_real1 <= transport
              --   c_st_real1_1 after 5 ns ;
--
         when 4
         => correct :=
               s_st_real1 =
                 c_st_real1_1 and
               (s_st_real1_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_st_real1_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_st_real1_cnt + 1 ;
--
   end ;
--
   procedure P12
      (signal s_st_rec1 : in st_rec1 ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_st_rec1_cnt is
         when 0
         => null ;
              -- s_st_rec1 <= transport
              --   c_st_rec1_2 after 10 ns,
              --   c_st_rec1_1 after 20 ns ;
--
         when 1
         => correct :=
               s_st_rec1 =
                 c_st_rec1_2 and
               (s_st_rec1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_st_rec1 =
                 c_st_rec1_1 and
               (s_st_rec1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P12" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_st_rec1 <= transport
              --   c_st_rec1_2 after 10 ns ,
              --   c_st_rec1_1 after 20 ns ,
              --   c_st_rec1_2 after 30 ns ,
              --   c_st_rec1_1 after 40 ns ;
--
         when 3
         => correct :=
               s_st_rec1 =
                 c_st_rec1_2 and
               (s_st_rec1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_st_rec1 <= transport
              --   c_st_rec1_1 after 5 ns ;
--
         when 4
         => correct :=
               s_st_rec1 =
                 c_st_rec1_1 and
               (s_st_rec1_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_st_rec1_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_st_rec1_cnt + 1 ;
--
   end ;
--
   procedure P13
      (signal s_st_rec2 : in st_rec2 ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_st_rec2_cnt is
         when 0
         => null ;
              -- s_st_rec2 <= transport
              --   c_st_rec2_2 after 10 ns,
              --   c_st_rec2_1 after 20 ns ;
--
         when 1
         => correct :=
               s_st_rec2 =
                 c_st_rec2_2 and
               (s_st_rec2_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_st_rec2 =
                 c_st_rec2_1 and
               (s_st_rec2_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P13" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_st_rec2 <= transport
              --   c_st_rec2_2 after 10 ns ,
              --   c_st_rec2_1 after 20 ns ,
              --   c_st_rec2_2 after 30 ns ,
              --   c_st_rec2_1 after 40 ns ;
--
         when 3
         => correct :=
               s_st_rec2 =
                 c_st_rec2_2 and
               (s_st_rec2_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_st_rec2 <= transport
              --   c_st_rec2_1 after 5 ns ;
--
         when 4
         => correct :=
               s_st_rec2 =
                 c_st_rec2_1 and
               (s_st_rec2_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_st_rec2_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_st_rec2_cnt + 1 ;
--
   end ;
--
   procedure P14
      (signal s_st_rec3 : in st_rec3 ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_st_rec3_cnt is
         when 0
         => null ;
              -- s_st_rec3 <= transport
              --   c_st_rec3_2 after 10 ns,
              --   c_st_rec3_1 after 20 ns ;
--
         when 1
         => correct :=
               s_st_rec3 =
                 c_st_rec3_2 and
               (s_st_rec3_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_st_rec3 =
                 c_st_rec3_1 and
               (s_st_rec3_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P14" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_st_rec3 <= transport
              --   c_st_rec3_2 after 10 ns ,
              --   c_st_rec3_1 after 20 ns ,
              --   c_st_rec3_2 after 30 ns ,
              --   c_st_rec3_1 after 40 ns ;
--
         when 3
         => correct :=
               s_st_rec3 =
                 c_st_rec3_2 and
               (s_st_rec3_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_st_rec3 <= transport
              --   c_st_rec3_1 after 5 ns ;
--
         when 4
         => correct :=
               s_st_rec3 =
                 c_st_rec3_1 and
               (s_st_rec3_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_st_rec3_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_st_rec3_cnt + 1 ;
--
   end ;
--
   procedure P15
      (signal s_st_arr1 : in st_arr1 ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_st_arr1_cnt is
         when 0
         => null ;
              -- s_st_arr1 <= transport
              --   c_st_arr1_2 after 10 ns,
              --   c_st_arr1_1 after 20 ns ;
--
         when 1
         => correct :=
               s_st_arr1 =
                 c_st_arr1_2 and
               (s_st_arr1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_st_arr1 =
                 c_st_arr1_1 and
               (s_st_arr1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P15" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_st_arr1 <= transport
              --   c_st_arr1_2 after 10 ns ,
              --   c_st_arr1_1 after 20 ns ,
              --   c_st_arr1_2 after 30 ns ,
              --   c_st_arr1_1 after 40 ns ;
--
         when 3
         => correct :=
               s_st_arr1 =
                 c_st_arr1_2 and
               (s_st_arr1_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_st_arr1 <= transport
              --   c_st_arr1_1 after 5 ns ;
--
         when 4
         => correct :=
               s_st_arr1 =
                 c_st_arr1_1 and
               (s_st_arr1_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_st_arr1_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_st_arr1_cnt + 1 ;
--
   end ;
--
   procedure P16
      (signal s_st_arr2 : in st_arr2 ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_st_arr2_cnt is
         when 0
         => null ;
              -- s_st_arr2 <= transport
              --   c_st_arr2_2 after 10 ns,
              --   c_st_arr2_1 after 20 ns ;
--
         when 1
         => correct :=
               s_st_arr2 =
                 c_st_arr2_2 and
               (s_st_arr2_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_st_arr2 =
                 c_st_arr2_1 and
               (s_st_arr2_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P16" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_st_arr2 <= transport
              --   c_st_arr2_2 after 10 ns ,
              --   c_st_arr2_1 after 20 ns ,
              --   c_st_arr2_2 after 30 ns ,
              --   c_st_arr2_1 after 40 ns ;
--
         when 3
         => correct :=
               s_st_arr2 =
                 c_st_arr2_2 and
               (s_st_arr2_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_st_arr2 <= transport
              --   c_st_arr2_1 after 5 ns ;
--
         when 4
         => correct :=
               s_st_arr2 =
                 c_st_arr2_1 and
               (s_st_arr2_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_st_arr2_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_st_arr2_cnt + 1 ;
--
   end ;
--
   procedure P17
      (signal s_st_arr3 : in st_arr3 ;
       signal select_sig : out Select_Type ;
       signal savtime : out Chk_Time_Type ;
       signal chk_sig : out Chk_Sig_Type ;
       signal count : out Integer)
   is
      variable correct : boolean ;
   begin
      case s_st_arr3_cnt is
         when 0
         => null ;
              -- s_st_arr3 <= transport
              --   c_st_arr3_2 after 10 ns,
              --   c_st_arr3_1 after 20 ns ;
--
         when 1
         => correct :=
               s_st_arr3 =
                 c_st_arr3_2 and
               (s_st_arr3_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 1",
              correct ) ;
--
         when 2
         => correct :=
               s_st_arr3 =
                 c_st_arr3_1 and
               (s_st_arr3_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612.P17" ,
              "Multi transport transactions occurred on " &
              "concurrent signal asg",
              correct ) ;
--
            select_sig <= transport 2 ;
              -- s_st_arr3 <= transport
              --   c_st_arr3_2 after 10 ns ,
              --   c_st_arr3_1 after 20 ns ,
              --   c_st_arr3_2 after 30 ns ,
              --   c_st_arr3_1 after 40 ns ;
--
         when 3
         => correct :=
               s_st_arr3 =
                 c_st_arr3_2 and
               (s_st_arr3_savt + 10 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "Concurrent proc call 2",
              correct ) ;
            select_sig <= transport 3 ;
              -- s_st_arr3 <= transport
              --   c_st_arr3_1 after 5 ns ;
--
         when 4
         => correct :=
               s_st_arr3 =
                 c_st_arr3_1 and
               (s_st_arr3_savt + 5 ns) = Std.Standard.Now ;
            test_report ( "ARCH00612" ,
              "One transport transaction occurred on a " &
              "concurrent signal asg",
              correct ) ;
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              correct ) ;
--
         when others
         => -- No more transactions should have occurred
            test_report ( "ARCH00612" ,
              "Old transactions were removed on a " &
              "concurrent signal asg",
              false ) ;
--
      end case ;
--
      savtime <= transport Std.Standard.Now ;
      chk_sig <= transport s_st_arr3_cnt
          after (1 us - Std.Standard.Now) ;
      count <= transport s_st_arr3_cnt + 1 ;
--
   end ;
--
begin
   CHG1 :
   P1(
       s_boolean ,
       boolean_select ,
       s_boolean_savt ,
       chk_boolean ,
       s_boolean_cnt ) ;
--
   PGEN_CHKP_1 :
   process ( chk_boolean )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P1" ,
           "Transport transactions completed entirely",
           chk_boolean = 4 ) ;
      end if ;
   end process PGEN_CHKP_1 ;
--
--
   with boolean_select select
      s_boolean <= transport
        c_boolean_2 after 10 ns,
        c_boolean_1 after 20 ns
        when 1,
--
        c_boolean_2 after 10 ns ,
        c_boolean_1 after 20 ns ,
        c_boolean_2 after 30 ns ,
        c_boolean_1 after 40 ns
        when 2,
--
        c_boolean_1 after 5 ns  when 3 ;
--
   CHG2 :
   P2(
       s_bit ,
       bit_select ,
       s_bit_savt ,
       chk_bit ,
       s_bit_cnt ) ;
--
   PGEN_CHKP_2 :
   process ( chk_bit )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P2" ,
           "Transport transactions completed entirely",
           chk_bit = 4 ) ;
      end if ;
   end process PGEN_CHKP_2 ;
--
--
   with bit_select select
      s_bit <= transport
        c_bit_2 after 10 ns,
        c_bit_1 after 20 ns
        when 1,
--
        c_bit_2 after 10 ns ,
        c_bit_1 after 20 ns ,
        c_bit_2 after 30 ns ,
        c_bit_1 after 40 ns
        when 2,
--
        c_bit_1 after 5 ns  when 3 ;
--
   CHG3 :
   P3(
       s_severity_level ,
       severity_level_select ,
       s_severity_level_savt ,
       chk_severity_level ,
       s_severity_level_cnt ) ;
--
   PGEN_CHKP_3 :
   process ( chk_severity_level )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P3" ,
           "Transport transactions completed entirely",
           chk_severity_level = 4 ) ;
      end if ;
   end process PGEN_CHKP_3 ;
--
--
   with severity_level_select select
      s_severity_level <= transport
        c_severity_level_2 after 10 ns,
        c_severity_level_1 after 20 ns
        when 1,
--
        c_severity_level_2 after 10 ns ,
        c_severity_level_1 after 20 ns ,
        c_severity_level_2 after 30 ns ,
        c_severity_level_1 after 40 ns
        when 2,
--
        c_severity_level_1 after 5 ns  when 3 ;
--
   CHG4 :
   P4(
       s_character ,
       character_select ,
       s_character_savt ,
       chk_character ,
       s_character_cnt ) ;
--
   PGEN_CHKP_4 :
   process ( chk_character )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P4" ,
           "Transport transactions completed entirely",
           chk_character = 4 ) ;
      end if ;
   end process PGEN_CHKP_4 ;
--
--
   with character_select select
      s_character <= transport
        c_character_2 after 10 ns,
        c_character_1 after 20 ns
        when 1,
--
        c_character_2 after 10 ns ,
        c_character_1 after 20 ns ,
        c_character_2 after 30 ns ,
        c_character_1 after 40 ns
        when 2,
--
        c_character_1 after 5 ns  when 3 ;
--
   CHG5 :
   P5(
       s_st_enum1 ,
       st_enum1_select ,
       s_st_enum1_savt ,
       chk_st_enum1 ,
       s_st_enum1_cnt ) ;
--
   PGEN_CHKP_5 :
   process ( chk_st_enum1 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P5" ,
           "Transport transactions completed entirely",
           chk_st_enum1 = 4 ) ;
      end if ;
   end process PGEN_CHKP_5 ;
--
--
   with st_enum1_select select
      s_st_enum1 <= transport
        c_st_enum1_2 after 10 ns,
        c_st_enum1_1 after 20 ns
        when 1,
--
        c_st_enum1_2 after 10 ns ,
        c_st_enum1_1 after 20 ns ,
        c_st_enum1_2 after 30 ns ,
        c_st_enum1_1 after 40 ns
        when 2,
--
        c_st_enum1_1 after 5 ns  when 3 ;
--
   CHG6 :
   P6(
       s_integer ,
       integer_select ,
       s_integer_savt ,
       chk_integer ,
       s_integer_cnt ) ;
--
   PGEN_CHKP_6 :
   process ( chk_integer )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P6" ,
           "Transport transactions completed entirely",
           chk_integer = 4 ) ;
      end if ;
   end process PGEN_CHKP_6 ;
--
--
   with integer_select select
      s_integer <= transport
        c_integer_2 after 10 ns,
        c_integer_1 after 20 ns
        when 1,
--
        c_integer_2 after 10 ns ,
        c_integer_1 after 20 ns ,
        c_integer_2 after 30 ns ,
        c_integer_1 after 40 ns
        when 2,
--
        c_integer_1 after 5 ns  when 3 ;
--
   CHG7 :
   P7(
       s_st_int1 ,
       st_int1_select ,
       s_st_int1_savt ,
       chk_st_int1 ,
       s_st_int1_cnt ) ;
--
   PGEN_CHKP_7 :
   process ( chk_st_int1 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P7" ,
           "Transport transactions completed entirely",
           chk_st_int1 = 4 ) ;
      end if ;
   end process PGEN_CHKP_7 ;
--
--
   with st_int1_select select
      s_st_int1 <= transport
        c_st_int1_2 after 10 ns,
        c_st_int1_1 after 20 ns
        when 1,
--
        c_st_int1_2 after 10 ns ,
        c_st_int1_1 after 20 ns ,
        c_st_int1_2 after 30 ns ,
        c_st_int1_1 after 40 ns
        when 2,
--
        c_st_int1_1 after 5 ns  when 3 ;
--
   CHG8 :
   P8(
       s_time ,
       time_select ,
       s_time_savt ,
       chk_time ,
       s_time_cnt ) ;
--
   PGEN_CHKP_8 :
   process ( chk_time )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P8" ,
           "Transport transactions completed entirely",
           chk_time = 4 ) ;
      end if ;
   end process PGEN_CHKP_8 ;
--
--
   with time_select select
      s_time <= transport
        c_time_2 after 10 ns,
        c_time_1 after 20 ns
        when 1,
--
        c_time_2 after 10 ns ,
        c_time_1 after 20 ns ,
        c_time_2 after 30 ns ,
        c_time_1 after 40 ns
        when 2,
--
        c_time_1 after 5 ns  when 3 ;
--
   CHG9 :
   P9(
       s_st_phys1 ,
       st_phys1_select ,
       s_st_phys1_savt ,
       chk_st_phys1 ,
       s_st_phys1_cnt ) ;
--
   PGEN_CHKP_9 :
   process ( chk_st_phys1 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P9" ,
           "Transport transactions completed entirely",
           chk_st_phys1 = 4 ) ;
      end if ;
   end process PGEN_CHKP_9 ;
--
--
   with st_phys1_select select
      s_st_phys1 <= transport
        c_st_phys1_2 after 10 ns,
        c_st_phys1_1 after 20 ns
        when 1,
--
        c_st_phys1_2 after 10 ns ,
        c_st_phys1_1 after 20 ns ,
        c_st_phys1_2 after 30 ns ,
        c_st_phys1_1 after 40 ns
        when 2,
--
        c_st_phys1_1 after 5 ns  when 3 ;
--
   CHG10 :
   P10(
       s_real ,
       real_select ,
       s_real_savt ,
       chk_real ,
       s_real_cnt ) ;
--
   PGEN_CHKP_10 :
   process ( chk_real )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P10" ,
           "Transport transactions completed entirely",
           chk_real = 4 ) ;
      end if ;
   end process PGEN_CHKP_10 ;
--
--
   with real_select select
      s_real <= transport
        c_real_2 after 10 ns,
        c_real_1 after 20 ns
        when 1,
--
        c_real_2 after 10 ns ,
        c_real_1 after 20 ns ,
        c_real_2 after 30 ns ,
        c_real_1 after 40 ns
        when 2,
--
        c_real_1 after 5 ns  when 3 ;
--
   CHG11 :
   P11(
       s_st_real1 ,
       st_real1_select ,
       s_st_real1_savt ,
       chk_st_real1 ,
       s_st_real1_cnt ) ;
--
   PGEN_CHKP_11 :
   process ( chk_st_real1 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P11" ,
           "Transport transactions completed entirely",
           chk_st_real1 = 4 ) ;
      end if ;
   end process PGEN_CHKP_11 ;
--
--
   with st_real1_select select
      s_st_real1 <= transport
        c_st_real1_2 after 10 ns,
        c_st_real1_1 after 20 ns
        when 1,
--
        c_st_real1_2 after 10 ns ,
        c_st_real1_1 after 20 ns ,
        c_st_real1_2 after 30 ns ,
        c_st_real1_1 after 40 ns
        when 2,
--
        c_st_real1_1 after 5 ns  when 3 ;
--
   CHG12 :
   P12(
       s_st_rec1 ,
       st_rec1_select ,
       s_st_rec1_savt ,
       chk_st_rec1 ,
       s_st_rec1_cnt ) ;
--
   PGEN_CHKP_12 :
   process ( chk_st_rec1 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P12" ,
           "Transport transactions completed entirely",
           chk_st_rec1 = 4 ) ;
      end if ;
   end process PGEN_CHKP_12 ;
--
--
   with st_rec1_select select
      s_st_rec1 <= transport
        c_st_rec1_2 after 10 ns,
        c_st_rec1_1 after 20 ns
        when 1,
--
        c_st_rec1_2 after 10 ns ,
        c_st_rec1_1 after 20 ns ,
        c_st_rec1_2 after 30 ns ,
        c_st_rec1_1 after 40 ns
        when 2,
--
        c_st_rec1_1 after 5 ns  when 3 ;
--
   CHG13 :
   P13(
       s_st_rec2 ,
       st_rec2_select ,
       s_st_rec2_savt ,
       chk_st_rec2 ,
       s_st_rec2_cnt ) ;
--
   PGEN_CHKP_13 :
   process ( chk_st_rec2 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P13" ,
           "Transport transactions completed entirely",
           chk_st_rec2 = 4 ) ;
      end if ;
   end process PGEN_CHKP_13 ;
--
--
   with st_rec2_select select
      s_st_rec2 <= transport
        c_st_rec2_2 after 10 ns,
        c_st_rec2_1 after 20 ns
        when 1,
--
        c_st_rec2_2 after 10 ns ,
        c_st_rec2_1 after 20 ns ,
        c_st_rec2_2 after 30 ns ,
        c_st_rec2_1 after 40 ns
        when 2,
--
        c_st_rec2_1 after 5 ns  when 3 ;
--
   CHG14 :
   P14(
       s_st_rec3 ,
       st_rec3_select ,
       s_st_rec3_savt ,
       chk_st_rec3 ,
       s_st_rec3_cnt ) ;
--
   PGEN_CHKP_14 :
   process ( chk_st_rec3 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P14" ,
           "Transport transactions completed entirely",
           chk_st_rec3 = 4 ) ;
      end if ;
   end process PGEN_CHKP_14 ;
--
--
   with st_rec3_select select
      s_st_rec3 <= transport
        c_st_rec3_2 after 10 ns,
        c_st_rec3_1 after 20 ns
        when 1,
--
        c_st_rec3_2 after 10 ns ,
        c_st_rec3_1 after 20 ns ,
        c_st_rec3_2 after 30 ns ,
        c_st_rec3_1 after 40 ns
        when 2,
--
        c_st_rec3_1 after 5 ns  when 3 ;
--
   CHG15 :
   P15(
       s_st_arr1 ,
       st_arr1_select ,
       s_st_arr1_savt ,
       chk_st_arr1 ,
       s_st_arr1_cnt ) ;
--
   PGEN_CHKP_15 :
   process ( chk_st_arr1 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P15" ,
           "Transport transactions completed entirely",
           chk_st_arr1 = 4 ) ;
      end if ;
   end process PGEN_CHKP_15 ;
--
--
   with st_arr1_select select
      s_st_arr1 <= transport
        c_st_arr1_2 after 10 ns,
        c_st_arr1_1 after 20 ns
        when 1,
--
        c_st_arr1_2 after 10 ns ,
        c_st_arr1_1 after 20 ns ,
        c_st_arr1_2 after 30 ns ,
        c_st_arr1_1 after 40 ns
        when 2,
--
        c_st_arr1_1 after 5 ns  when 3 ;
--
   CHG16 :
   P16(
       s_st_arr2 ,
       st_arr2_select ,
       s_st_arr2_savt ,
       chk_st_arr2 ,
       s_st_arr2_cnt ) ;
--
   PGEN_CHKP_16 :
   process ( chk_st_arr2 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P16" ,
           "Transport transactions completed entirely",
           chk_st_arr2 = 4 ) ;
      end if ;
   end process PGEN_CHKP_16 ;
--
--
   with st_arr2_select select
      s_st_arr2 <= transport
        c_st_arr2_2 after 10 ns,
        c_st_arr2_1 after 20 ns
        when 1,
--
        c_st_arr2_2 after 10 ns ,
        c_st_arr2_1 after 20 ns ,
        c_st_arr2_2 after 30 ns ,
        c_st_arr2_1 after 40 ns
        when 2,
--
        c_st_arr2_1 after 5 ns  when 3 ;
--
   CHG17 :
   P17(
       s_st_arr3 ,
       st_arr3_select ,
       s_st_arr3_savt ,
       chk_st_arr3 ,
       s_st_arr3_cnt ) ;
--
   PGEN_CHKP_17 :
   process ( chk_st_arr3 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P17" ,
           "Transport transactions completed entirely",
           chk_st_arr3 = 4 ) ;
      end if ;
   end process PGEN_CHKP_17 ;
--
--
   with st_arr3_select select
      s_st_arr3 <= transport
        c_st_arr3_2 after 10 ns,
        c_st_arr3_1 after 20 ns
        when 1,
--
        c_st_arr3_2 after 10 ns ,
        c_st_arr3_1 after 20 ns ,
        c_st_arr3_2 after 30 ns ,
        c_st_arr3_1 after 40 ns
        when 2,
--
        c_st_arr3_1 after 5 ns  when 3 ;
--
end ARCH00612 ;
--
--
use WORK.STANDARD_TYPES.all ;
entity ENT00612_Test_Bench is
   signal s_boolean : boolean
     := c_boolean_1 ;
   signal s_bit : bit
     := c_bit_1 ;
   signal s_severity_level : severity_level
     := c_severity_level_1 ;
   signal s_character : character
     := c_character_1 ;
   signal s_st_enum1 : st_enum1
     := c_st_enum1_1 ;
   signal s_integer : integer
     := c_integer_1 ;
   signal s_st_int1 : st_int1
     := c_st_int1_1 ;
   signal s_time : time
     := c_time_1 ;
   signal s_st_phys1 : st_phys1
     := c_st_phys1_1 ;
   signal s_real : real
     := c_real_1 ;
   signal s_st_real1 : st_real1
     := c_st_real1_1 ;
   signal s_st_rec1 : st_rec1
     := c_st_rec1_1 ;
   signal s_st_rec2 : st_rec2
     := c_st_rec2_1 ;
   signal s_st_rec3 : st_rec3
     := c_st_rec3_1 ;
   signal s_st_arr1 : st_arr1
     := c_st_arr1_1 ;
   signal s_st_arr2 : st_arr2
     := c_st_arr2_1 ;
   signal s_st_arr3 : st_arr3
     := c_st_arr3_1 ;
--
end ENT00612_Test_Bench ;
--
--
architecture ARCH00612_Test_Bench of ENT00612_Test_Bench is
begin
   L1:
   block
      component UUT
         port (
              s_boolean : inout boolean
            ; s_bit : inout bit
            ; s_severity_level : inout severity_level
            ; s_character : inout character
            ; s_st_enum1 : inout st_enum1
            ; s_integer : inout integer
            ; s_st_int1 : inout st_int1
            ; s_time : inout time
            ; s_st_phys1 : inout st_phys1
            ; s_real : inout real
            ; s_st_real1 : inout st_real1
            ; s_st_rec1 : inout st_rec1
            ; s_st_rec2 : inout st_rec2
            ; s_st_rec3 : inout st_rec3
            ; s_st_arr1 : inout st_arr1
            ; s_st_arr2 : inout st_arr2
            ; s_st_arr3 : inout st_arr3
              ) ;
      end component ;
--
      for CIS1 : UUT use entity WORK.ENT00612 ( ARCH00612 ) ;
   begin
      CIS1 : UUT
         port map (
              s_boolean
            , s_bit
            , s_severity_level
            , s_character
            , s_st_enum1
            , s_integer
            , s_st_int1
            , s_time
            , s_st_phys1
            , s_real
            , s_st_real1
            , s_st_rec1
            , s_st_rec2
            , s_st_rec3
            , s_st_arr1
            , s_st_arr2
            , s_st_arr3
                  )
         ;
   end block L1 ;
end ARCH00612_Test_Bench ;
