-------------------------------------------------------------------------------
 --
 --    Copyright (c) 1989 by Intermetrics, Inc.
 --                All rights reserved.
 --
-------------------------------------------------------------------------------
--
-- TEST NAME:
--
--    CT00135
--
-- AUTHOR:
--
--    G. Tominovich
--
-- TEST OBJECTIVES:
--
--    8.3 (1)
--    8.3 (2)
--    8.3 (4)
--    8.3 (5)
--    8.3.1 (4)
--
-- DESIGN UNIT ORDERING:
--
--    ENT00135(ARCH00135)
--    ENT00135_Test_Bench(ARCH00135_Test_Bench)
--
-- REVISION HISTORY:
--
--    08-JUL-1987   - initial revision
--
-- NOTES:
--
--    self-checking
--    automatically generated
--
use WORK.STANDARD_TYPES.all ;
entity ENT00135 is
   port (
        s_boolean : inout boolean
      ; s_bit : inout bit
      ; s_severity_level : inout severity_level
      ; s_character : inout character
      ; s_st_enum1 : inout st_enum1
      ; s_integer : inout integer
      ; s_st_int1 : inout st_int1
      ; s_time : inout time
      ; s_st_phys1 : inout st_phys1
      ; s_real : inout real
      ; s_st_real1 : inout st_real1
      ; s_st_rec1 : inout st_rec1
      ; s_st_rec2 : inout st_rec2
      ; s_st_rec3 : inout st_rec3
      ; s_st_arr1 : inout st_arr1
      ; s_st_arr2 : inout st_arr2
      ; s_st_arr3 : inout st_arr3
        ) ;
   subtype chk_sig_type is integer range -1 to 100 ;
   signal chk_boolean : chk_sig_type := -1 ;
   signal chk_bit : chk_sig_type := -1 ;
   signal chk_severity_level : chk_sig_type := -1 ;
   signal chk_character : chk_sig_type := -1 ;
   signal chk_st_enum1 : chk_sig_type := -1 ;
   signal chk_integer : chk_sig_type := -1 ;
   signal chk_st_int1 : chk_sig_type := -1 ;
   signal chk_time : chk_sig_type := -1 ;
   signal chk_st_phys1 : chk_sig_type := -1 ;
   signal chk_real : chk_sig_type := -1 ;
   signal chk_st_real1 : chk_sig_type := -1 ;
   signal chk_st_rec1 : chk_sig_type := -1 ;
   signal chk_st_rec2 : chk_sig_type := -1 ;
   signal chk_st_rec3 : chk_sig_type := -1 ;
   signal chk_st_arr1 : chk_sig_type := -1 ;
   signal chk_st_arr2 : chk_sig_type := -1 ;
   signal chk_st_arr3 : chk_sig_type := -1 ;
--
end ENT00135 ;
--
architecture ARCH00135 of ENT00135 is
begin
   P1 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_boolean <=
                  c_boolean_2 after 10 ns,
                  c_boolean_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_boolean = c_boolean_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_boolean = c_boolean_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P1" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_boolean <=
                  c_boolean_2 after 10 ns ,
                  c_boolean_1 after 20 ns ,
                  c_boolean_2 after 30 ns ,
                  c_boolean_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_boolean = c_boolean_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_boolean <= c_boolean_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_boolean = c_boolean_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_boolean <= transport
                  c_boolean_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_boolean = c_boolean_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_boolean <=
                  c_boolean_2 after 10 ns ,
                  c_boolean_1 after 20 ns ,
                  c_boolean_2 after 30 ns ,
                  c_boolean_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_boolean = c_boolean_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_boolean <=    -- Last transaction above is marked
                  c_boolean_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_boolean = c_boolean_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_boolean = c_boolean_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_boolean <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_boolean'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P1 ;
--
   PGEN_CHKP_1 :
   process ( chk_boolean )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P1" ,
           "Inertial transactions entirely completed",
           chk_boolean = 8 ) ;
      end if ;
   end process PGEN_CHKP_1 ;
--
   P2 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_bit <=
                  c_bit_2 after 10 ns,
                  c_bit_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_bit = c_bit_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_bit = c_bit_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P2" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_bit <=
                  c_bit_2 after 10 ns ,
                  c_bit_1 after 20 ns ,
                  c_bit_2 after 30 ns ,
                  c_bit_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_bit = c_bit_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_bit <= c_bit_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_bit = c_bit_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_bit <= transport
                  c_bit_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_bit = c_bit_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_bit <=
                  c_bit_2 after 10 ns ,
                  c_bit_1 after 20 ns ,
                  c_bit_2 after 30 ns ,
                  c_bit_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_bit = c_bit_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_bit <=    -- Last transaction above is marked
                  c_bit_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_bit = c_bit_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_bit = c_bit_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_bit <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_bit'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P2 ;
--
   PGEN_CHKP_2 :
   process ( chk_bit )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P2" ,
           "Inertial transactions entirely completed",
           chk_bit = 8 ) ;
      end if ;
   end process PGEN_CHKP_2 ;
--
   P3 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_severity_level <=
                  c_severity_level_2 after 10 ns,
                  c_severity_level_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_severity_level = c_severity_level_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_severity_level = c_severity_level_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P3" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_severity_level <=
                  c_severity_level_2 after 10 ns ,
                  c_severity_level_1 after 20 ns ,
                  c_severity_level_2 after 30 ns ,
                  c_severity_level_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_severity_level = c_severity_level_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_severity_level <= c_severity_level_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_severity_level = c_severity_level_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_severity_level <= transport
                  c_severity_level_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_severity_level = c_severity_level_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_severity_level <=
                  c_severity_level_2 after 10 ns ,
                  c_severity_level_1 after 20 ns ,
                  c_severity_level_2 after 30 ns ,
                  c_severity_level_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_severity_level = c_severity_level_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_severity_level <=    -- Last transaction above is marked
                  c_severity_level_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_severity_level = c_severity_level_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_severity_level = c_severity_level_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_severity_level <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_severity_level'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P3 ;
--
   PGEN_CHKP_3 :
   process ( chk_severity_level )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P3" ,
           "Inertial transactions entirely completed",
           chk_severity_level = 8 ) ;
      end if ;
   end process PGEN_CHKP_3 ;
--
   P4 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_character <=
                  c_character_2 after 10 ns,
                  c_character_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_character = c_character_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_character = c_character_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P4" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_character <=
                  c_character_2 after 10 ns ,
                  c_character_1 after 20 ns ,
                  c_character_2 after 30 ns ,
                  c_character_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_character = c_character_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_character <= c_character_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_character = c_character_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_character <= transport
                  c_character_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_character = c_character_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_character <=
                  c_character_2 after 10 ns ,
                  c_character_1 after 20 ns ,
                  c_character_2 after 30 ns ,
                  c_character_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_character = c_character_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_character <=    -- Last transaction above is marked
                  c_character_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_character = c_character_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_character = c_character_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_character <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_character'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P4 ;
--
   PGEN_CHKP_4 :
   process ( chk_character )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P4" ,
           "Inertial transactions entirely completed",
           chk_character = 8 ) ;
      end if ;
   end process PGEN_CHKP_4 ;
--
   P5 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_st_enum1 <=
                  c_st_enum1_2 after 10 ns,
                  c_st_enum1_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_st_enum1 = c_st_enum1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_st_enum1 = c_st_enum1_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P5" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_enum1 <=
                  c_st_enum1_2 after 10 ns ,
                  c_st_enum1_1 after 20 ns ,
                  c_st_enum1_2 after 30 ns ,
                  c_st_enum1_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_st_enum1 = c_st_enum1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_st_enum1 <= c_st_enum1_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_st_enum1 = c_st_enum1_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_enum1 <= transport
                  c_st_enum1_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_st_enum1 = c_st_enum1_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_enum1 <=
                  c_st_enum1_2 after 10 ns ,
                  c_st_enum1_1 after 20 ns ,
                  c_st_enum1_2 after 30 ns ,
                  c_st_enum1_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_st_enum1 = c_st_enum1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_enum1 <=    -- Last transaction above is marked
                  c_st_enum1_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_st_enum1 = c_st_enum1_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_st_enum1 = c_st_enum1_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_st_enum1 <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_st_enum1'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P5 ;
--
   PGEN_CHKP_5 :
   process ( chk_st_enum1 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P5" ,
           "Inertial transactions entirely completed",
           chk_st_enum1 = 8 ) ;
      end if ;
   end process PGEN_CHKP_5 ;
--
   P6 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_integer <=
                  c_integer_2 after 10 ns,
                  c_integer_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_integer = c_integer_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_integer = c_integer_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P6" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_integer <=
                  c_integer_2 after 10 ns ,
                  c_integer_1 after 20 ns ,
                  c_integer_2 after 30 ns ,
                  c_integer_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_integer = c_integer_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_integer <= c_integer_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_integer = c_integer_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_integer <= transport
                  c_integer_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_integer = c_integer_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_integer <=
                  c_integer_2 after 10 ns ,
                  c_integer_1 after 20 ns ,
                  c_integer_2 after 30 ns ,
                  c_integer_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_integer = c_integer_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_integer <=    -- Last transaction above is marked
                  c_integer_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_integer = c_integer_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_integer = c_integer_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_integer <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_integer'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P6 ;
--
   PGEN_CHKP_6 :
   process ( chk_integer )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P6" ,
           "Inertial transactions entirely completed",
           chk_integer = 8 ) ;
      end if ;
   end process PGEN_CHKP_6 ;
--
   P7 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_st_int1 <=
                  c_st_int1_2 after 10 ns,
                  c_st_int1_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_st_int1 = c_st_int1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_st_int1 = c_st_int1_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P7" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_int1 <=
                  c_st_int1_2 after 10 ns ,
                  c_st_int1_1 after 20 ns ,
                  c_st_int1_2 after 30 ns ,
                  c_st_int1_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_st_int1 = c_st_int1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_st_int1 <= c_st_int1_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_st_int1 = c_st_int1_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_int1 <= transport
                  c_st_int1_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_st_int1 = c_st_int1_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_int1 <=
                  c_st_int1_2 after 10 ns ,
                  c_st_int1_1 after 20 ns ,
                  c_st_int1_2 after 30 ns ,
                  c_st_int1_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_st_int1 = c_st_int1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_int1 <=    -- Last transaction above is marked
                  c_st_int1_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_st_int1 = c_st_int1_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_st_int1 = c_st_int1_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_st_int1 <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_st_int1'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P7 ;
--
   PGEN_CHKP_7 :
   process ( chk_st_int1 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P7" ,
           "Inertial transactions entirely completed",
           chk_st_int1 = 8 ) ;
      end if ;
   end process PGEN_CHKP_7 ;
--
   P8 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_time <=
                  c_time_2 after 10 ns,
                  c_time_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_time = c_time_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_time = c_time_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P8" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_time <=
                  c_time_2 after 10 ns ,
                  c_time_1 after 20 ns ,
                  c_time_2 after 30 ns ,
                  c_time_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_time = c_time_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_time <= c_time_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_time = c_time_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_time <= transport
                  c_time_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_time = c_time_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_time <=
                  c_time_2 after 10 ns ,
                  c_time_1 after 20 ns ,
                  c_time_2 after 30 ns ,
                  c_time_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_time = c_time_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_time <=    -- Last transaction above is marked
                  c_time_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_time = c_time_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_time = c_time_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_time <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_time'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P8 ;
--
   PGEN_CHKP_8 :
   process ( chk_time )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P8" ,
           "Inertial transactions entirely completed",
           chk_time = 8 ) ;
      end if ;
   end process PGEN_CHKP_8 ;
--
   P9 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_st_phys1 <=
                  c_st_phys1_2 after 10 ns,
                  c_st_phys1_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_st_phys1 = c_st_phys1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_st_phys1 = c_st_phys1_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P9" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_phys1 <=
                  c_st_phys1_2 after 10 ns ,
                  c_st_phys1_1 after 20 ns ,
                  c_st_phys1_2 after 30 ns ,
                  c_st_phys1_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_st_phys1 = c_st_phys1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_st_phys1 <= c_st_phys1_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_st_phys1 = c_st_phys1_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_phys1 <= transport
                  c_st_phys1_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_st_phys1 = c_st_phys1_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_phys1 <=
                  c_st_phys1_2 after 10 ns ,
                  c_st_phys1_1 after 20 ns ,
                  c_st_phys1_2 after 30 ns ,
                  c_st_phys1_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_st_phys1 = c_st_phys1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_phys1 <=    -- Last transaction above is marked
                  c_st_phys1_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_st_phys1 = c_st_phys1_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_st_phys1 = c_st_phys1_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_st_phys1 <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_st_phys1'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P9 ;
--
   PGEN_CHKP_9 :
   process ( chk_st_phys1 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P9" ,
           "Inertial transactions entirely completed",
           chk_st_phys1 = 8 ) ;
      end if ;
   end process PGEN_CHKP_9 ;
--
   P10 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_real <=
                  c_real_2 after 10 ns,
                  c_real_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_real = c_real_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_real = c_real_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P10" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_real <=
                  c_real_2 after 10 ns ,
                  c_real_1 after 20 ns ,
                  c_real_2 after 30 ns ,
                  c_real_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_real = c_real_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_real <= c_real_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_real = c_real_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_real <= transport
                  c_real_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_real = c_real_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_real <=
                  c_real_2 after 10 ns ,
                  c_real_1 after 20 ns ,
                  c_real_2 after 30 ns ,
                  c_real_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_real = c_real_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_real <=    -- Last transaction above is marked
                  c_real_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_real = c_real_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_real = c_real_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_real <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_real'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P10 ;
--
   PGEN_CHKP_10 :
   process ( chk_real )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P10" ,
           "Inertial transactions entirely completed",
           chk_real = 8 ) ;
      end if ;
   end process PGEN_CHKP_10 ;
--
   P11 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_st_real1 <=
                  c_st_real1_2 after 10 ns,
                  c_st_real1_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_st_real1 = c_st_real1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_st_real1 = c_st_real1_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P11" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_real1 <=
                  c_st_real1_2 after 10 ns ,
                  c_st_real1_1 after 20 ns ,
                  c_st_real1_2 after 30 ns ,
                  c_st_real1_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_st_real1 = c_st_real1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_st_real1 <= c_st_real1_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_st_real1 = c_st_real1_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_real1 <= transport
                  c_st_real1_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_st_real1 = c_st_real1_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_real1 <=
                  c_st_real1_2 after 10 ns ,
                  c_st_real1_1 after 20 ns ,
                  c_st_real1_2 after 30 ns ,
                  c_st_real1_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_st_real1 = c_st_real1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_real1 <=    -- Last transaction above is marked
                  c_st_real1_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_st_real1 = c_st_real1_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_st_real1 = c_st_real1_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_st_real1 <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_st_real1'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P11 ;
--
   PGEN_CHKP_11 :
   process ( chk_st_real1 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P11" ,
           "Inertial transactions entirely completed",
           chk_st_real1 = 8 ) ;
      end if ;
   end process PGEN_CHKP_11 ;
--
   P12 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_st_rec1 <=
                  c_st_rec1_2 after 10 ns,
                  c_st_rec1_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_st_rec1 = c_st_rec1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_st_rec1 = c_st_rec1_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P12" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_rec1 <=
                  c_st_rec1_2 after 10 ns ,
                  c_st_rec1_1 after 20 ns ,
                  c_st_rec1_2 after 30 ns ,
                  c_st_rec1_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_st_rec1 = c_st_rec1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_st_rec1 <= c_st_rec1_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_st_rec1 = c_st_rec1_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_rec1 <= transport
                  c_st_rec1_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_st_rec1 = c_st_rec1_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_rec1 <=
                  c_st_rec1_2 after 10 ns ,
                  c_st_rec1_1 after 20 ns ,
                  c_st_rec1_2 after 30 ns ,
                  c_st_rec1_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_st_rec1 = c_st_rec1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_rec1 <=    -- Last transaction above is marked
                  c_st_rec1_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_st_rec1 = c_st_rec1_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_st_rec1 = c_st_rec1_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_st_rec1 <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_st_rec1'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P12 ;
--
   PGEN_CHKP_12 :
   process ( chk_st_rec1 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P12" ,
           "Inertial transactions entirely completed",
           chk_st_rec1 = 8 ) ;
      end if ;
   end process PGEN_CHKP_12 ;
--
   P13 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_st_rec2 <=
                  c_st_rec2_2 after 10 ns,
                  c_st_rec2_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_st_rec2 = c_st_rec2_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_st_rec2 = c_st_rec2_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P13" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_rec2 <=
                  c_st_rec2_2 after 10 ns ,
                  c_st_rec2_1 after 20 ns ,
                  c_st_rec2_2 after 30 ns ,
                  c_st_rec2_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_st_rec2 = c_st_rec2_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_st_rec2 <= c_st_rec2_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_st_rec2 = c_st_rec2_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_rec2 <= transport
                  c_st_rec2_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_st_rec2 = c_st_rec2_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_rec2 <=
                  c_st_rec2_2 after 10 ns ,
                  c_st_rec2_1 after 20 ns ,
                  c_st_rec2_2 after 30 ns ,
                  c_st_rec2_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_st_rec2 = c_st_rec2_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_rec2 <=    -- Last transaction above is marked
                  c_st_rec2_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_st_rec2 = c_st_rec2_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_st_rec2 = c_st_rec2_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_st_rec2 <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_st_rec2'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P13 ;
--
   PGEN_CHKP_13 :
   process ( chk_st_rec2 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P13" ,
           "Inertial transactions entirely completed",
           chk_st_rec2 = 8 ) ;
      end if ;
   end process PGEN_CHKP_13 ;
--
   P14 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_st_rec3 <=
                  c_st_rec3_2 after 10 ns,
                  c_st_rec3_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_st_rec3 = c_st_rec3_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_st_rec3 = c_st_rec3_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P14" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_rec3 <=
                  c_st_rec3_2 after 10 ns ,
                  c_st_rec3_1 after 20 ns ,
                  c_st_rec3_2 after 30 ns ,
                  c_st_rec3_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_st_rec3 = c_st_rec3_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_st_rec3 <= c_st_rec3_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_st_rec3 = c_st_rec3_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_rec3 <= transport
                  c_st_rec3_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_st_rec3 = c_st_rec3_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_rec3 <=
                  c_st_rec3_2 after 10 ns ,
                  c_st_rec3_1 after 20 ns ,
                  c_st_rec3_2 after 30 ns ,
                  c_st_rec3_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_st_rec3 = c_st_rec3_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_rec3 <=    -- Last transaction above is marked
                  c_st_rec3_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_st_rec3 = c_st_rec3_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_st_rec3 = c_st_rec3_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_st_rec3 <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_st_rec3'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P14 ;
--
   PGEN_CHKP_14 :
   process ( chk_st_rec3 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P14" ,
           "Inertial transactions entirely completed",
           chk_st_rec3 = 8 ) ;
      end if ;
   end process PGEN_CHKP_14 ;
--
   P15 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_st_arr1 <=
                  c_st_arr1_2 after 10 ns,
                  c_st_arr1_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_st_arr1 = c_st_arr1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_st_arr1 = c_st_arr1_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P15" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_arr1 <=
                  c_st_arr1_2 after 10 ns ,
                  c_st_arr1_1 after 20 ns ,
                  c_st_arr1_2 after 30 ns ,
                  c_st_arr1_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_st_arr1 = c_st_arr1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_st_arr1 <= c_st_arr1_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_st_arr1 = c_st_arr1_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_arr1 <= transport
                  c_st_arr1_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_st_arr1 = c_st_arr1_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_arr1 <=
                  c_st_arr1_2 after 10 ns ,
                  c_st_arr1_1 after 20 ns ,
                  c_st_arr1_2 after 30 ns ,
                  c_st_arr1_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_st_arr1 = c_st_arr1_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_arr1 <=    -- Last transaction above is marked
                  c_st_arr1_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_st_arr1 = c_st_arr1_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_st_arr1 = c_st_arr1_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_st_arr1 <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_st_arr1'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P15 ;
--
   PGEN_CHKP_15 :
   process ( chk_st_arr1 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P15" ,
           "Inertial transactions entirely completed",
           chk_st_arr1 = 8 ) ;
      end if ;
   end process PGEN_CHKP_15 ;
--
   P16 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_st_arr2 <=
                  c_st_arr2_2 after 10 ns,
                  c_st_arr2_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_st_arr2 = c_st_arr2_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_st_arr2 = c_st_arr2_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P16" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_arr2 <=
                  c_st_arr2_2 after 10 ns ,
                  c_st_arr2_1 after 20 ns ,
                  c_st_arr2_2 after 30 ns ,
                  c_st_arr2_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_st_arr2 = c_st_arr2_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_st_arr2 <= c_st_arr2_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_st_arr2 = c_st_arr2_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_arr2 <= transport
                  c_st_arr2_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_st_arr2 = c_st_arr2_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_arr2 <=
                  c_st_arr2_2 after 10 ns ,
                  c_st_arr2_1 after 20 ns ,
                  c_st_arr2_2 after 30 ns ,
                  c_st_arr2_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_st_arr2 = c_st_arr2_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_arr2 <=    -- Last transaction above is marked
                  c_st_arr2_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_st_arr2 = c_st_arr2_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_st_arr2 = c_st_arr2_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_st_arr2 <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_st_arr2'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P16 ;
--
   PGEN_CHKP_16 :
   process ( chk_st_arr2 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P16" ,
           "Inertial transactions entirely completed",
           chk_st_arr2 = 8 ) ;
      end if ;
   end process PGEN_CHKP_16 ;
--
   P17 :
   process
      variable correct : boolean ;
      variable counter : integer := 0 ;
      variable savtime : time ;
--
      procedure Proc1 is
      begin
         case counter is
            when 0
            => s_st_arr3 <=
                  c_st_arr3_2 after 10 ns,
                  c_st_arr3_1 after 20 ns ;
--
            when 1
            => correct :=
                  s_st_arr3 = c_st_arr3_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
--
            when 2
            => correct :=
                  correct and
                  s_st_arr3 = c_st_arr3_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135.P17" ,
                 "Multi inertial transactions occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_arr3 <=
                  c_st_arr3_2 after 10 ns ,
                  c_st_arr3_1 after 20 ns ,
                  c_st_arr3_2 after 30 ns ,
                  c_st_arr3_1 after 40 ns ;
--
            when 3
            => correct :=
                  s_st_arr3 = c_st_arr3_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               s_st_arr3 <= c_st_arr3_1 after 5 ns ;
--
            when 4
            => correct :=
                  correct and
                  s_st_arr3 = c_st_arr3_1 and
                  (savtime + 5 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_arr3 <= transport
                  c_st_arr3_1 after 100 ns ;
--
            when 5
            => correct :=
                  s_st_arr3 = c_st_arr3_1 and
                  (savtime + 100 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Old transactions were removed on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_arr3 <=
                  c_st_arr3_2 after 10 ns ,
                  c_st_arr3_1 after 20 ns ,
                  c_st_arr3_2 after 30 ns ,
                  c_st_arr3_1 after 40 ns ;
--
            when 6
            => correct :=
                  s_st_arr3 = c_st_arr3_2 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "One inertial transaction occurred on signal " &
                 "asg with simple name on LHS",
                 correct ) ;
               s_st_arr3 <=    -- Last transaction above is marked
                  c_st_arr3_1 after 40 ns ;
--
            when 7
            => correct :=
                  s_st_arr3 = c_st_arr3_1 and
                  (savtime + 30 ns) = Std.Standard.Now ;
--
--
            when 8
            => correct := correct and
                  s_st_arr3 = c_st_arr3_1 and
                  (savtime + 10 ns) = Std.Standard.Now ;
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 correct ) ;
--
            when others
            =>
               test_report ( "ARCH00135" ,
                 "Inertial semantics check on a signal " &
                 "asg with simple name on LHS",
                 false ) ;
--
         end case ;
--
         savtime := Std.Standard.Now ;
         chk_st_arr3 <= transport counter after (1 us - savtime) ;
         counter := counter + 1;
--
      end Proc1 ;
--
   begin
      Proc1 ;
      wait until (not s_st_arr3'Quiet) and
                 (savtime /= Std.Standard.Now) ;
--
   end process P17 ;
--
   PGEN_CHKP_17 :
   process ( chk_st_arr3 )
   begin
      if Std.Standard.Now > 0 ns then
         test_report ( "P17" ,
           "Inertial transactions entirely completed",
           chk_st_arr3 = 8 ) ;
      end if ;
   end process PGEN_CHKP_17 ;
--
--
end ARCH00135 ;
--
use WORK.STANDARD_TYPES.all ;
entity ENT00135_Test_Bench is
   signal s_boolean : boolean
     := c_boolean_1 ;
   signal s_bit : bit
     := c_bit_1 ;
   signal s_severity_level : severity_level
     := c_severity_level_1 ;
   signal s_character : character
     := c_character_1 ;
   signal s_st_enum1 : st_enum1
     := c_st_enum1_1 ;
   signal s_integer : integer
     := c_integer_1 ;
   signal s_st_int1 : st_int1
     := c_st_int1_1 ;
   signal s_time : time
     := c_time_1 ;
   signal s_st_phys1 : st_phys1
     := c_st_phys1_1 ;
   signal s_real : real
     := c_real_1 ;
   signal s_st_real1 : st_real1
     := c_st_real1_1 ;
   signal s_st_rec1 : st_rec1
     := c_st_rec1_1 ;
   signal s_st_rec2 : st_rec2
     := c_st_rec2_1 ;
   signal s_st_rec3 : st_rec3
     := c_st_rec3_1 ;
   signal s_st_arr1 : st_arr1
     := c_st_arr1_1 ;
   signal s_st_arr2 : st_arr2
     := c_st_arr2_1 ;
   signal s_st_arr3 : st_arr3
     := c_st_arr3_1 ;
--
end ENT00135_Test_Bench ;
--
architecture ARCH00135_Test_Bench of ENT00135_Test_Bench is
begin
   L1:
   block
      component UUT
         port (
              s_boolean : inout boolean
            ; s_bit : inout bit
            ; s_severity_level : inout severity_level
            ; s_character : inout character
            ; s_st_enum1 : inout st_enum1
            ; s_integer : inout integer
            ; s_st_int1 : inout st_int1
            ; s_time : inout time
            ; s_st_phys1 : inout st_phys1
            ; s_real : inout real
            ; s_st_real1 : inout st_real1
            ; s_st_rec1 : inout st_rec1
            ; s_st_rec2 : inout st_rec2
            ; s_st_rec3 : inout st_rec3
            ; s_st_arr1 : inout st_arr1
            ; s_st_arr2 : inout st_arr2
            ; s_st_arr3 : inout st_arr3
              ) ;
      end component ;
--
      for CIS1 : UUT use entity WORK.ENT00135 ( ARCH00135 ) ;
   begin
      CIS1 : UUT
         port map (
              s_boolean
            , s_bit
            , s_severity_level
            , s_character
            , s_st_enum1
            , s_integer
            , s_st_int1
            , s_time
            , s_st_phys1
            , s_real
            , s_st_real1
            , s_st_rec1
            , s_st_rec2
            , s_st_rec3
            , s_st_arr1
            , s_st_arr2
            , s_st_arr3
                  ) ;
   end block L1 ;
end ARCH00135_Test_Bench ;
