-------------------------------------------------------------------------------
	--
	--	   Copyright (c) 1989 by Intermetrics, Inc.
	--                All rights reserved.
	--
-------------------------------------------------------------------------------
--
-- TEST NAME:
--
--    CT00018
--
-- AUTHOR:
--
--    G. Tominovich
--
-- TEST OBJECTIVES:
--
--    8.1 (8)
--
-- DESIGN UNIT ORDERING:
--
--    ENT00018(ARCH00018)
--    ENT00018_Test_Bench(ARCH00018_Test_Bench)
--
-- REVISION HISTORY:
--
--    26-JUN-1987   - initial revision
--
-- NOTES:
--
--    self-checking
--
use WORK.STANDARD_TYPES.all ;
entity ENT00018 is
   generic ( G1 : Time := 10 ns ) ;
   port ( P1 : in Time := 10 ns ) ;
end ENT00018 ;

architecture ARCH00018 of ENT00018 is
   signal Num_Cycles : Integer := 0 ;

   signal Dummy_Cond : Boolean := false ;

   signal P1_1_Did_Resume, P1_2_Did_Resume : Boolean := false ;
   signal P2_1_Did_Resume, P2_2_Did_Resume : Boolean := false ;
   signal P3_1_Did_Resume, P3_2_Did_Resume : Boolean := false ;
   signal R1_1_Did_Resume, R1_2_Did_Resume : Boolean := false ;
   signal PROC1_1_Did_Resume, PROC1_2_Did_Resume : Boolean := false ;
   signal PROC2_1_Did_Resume, PROC2_2_Did_Resume : Boolean := false ;
   signal PROC3_1_Did_Resume, PROC3_2_Did_Resume : Boolean := false ;
   signal PROC4_1_Did_Resume, PROC4_2_Did_Resume : Boolean := false ;


   constant Time_To_Wait : Time := 10 ns ;

   procedure PROC1_1 ( Signal Resume_Chk : inout boolean ) is
   begin
      wait on Num_Cycles until Dummy_Cond for Time_To_Wait ; -- Locally Static
      Resume_Chk <= transport True ;
   end PROC1_1 ;

   procedure PROC1_2 ( Signal Resume_Chk : inout boolean ) is
   begin
      wait until (Num_Cycles = 1000) for Time_To_Wait ;  -- Locally Static
      Resume_Chk <= transport True ;
   end PROC1_2 ;

   procedure PROC2_1 ( Signal Resume_Chk : inout boolean ) is
   begin
      wait on Num_Cycles until Dummy_Cond for G1 ; -- Globally Static
      Resume_Chk <= transport True ;
   end PROC2_1 ;

   procedure PROC2_2 ( Signal Resume_Chk : inout boolean ) is
   begin
      wait until (Num_Cycles = 1000) for G1 ;  -- Globally Static
      Resume_Chk <= transport True ;
   end PROC2_2 ;

   procedure PROC3_1 ( Signal Resume_Chk : inout boolean ) is
   begin
      wait on Num_Cycles until Dummy_Cond for P1 ; -- Dynamic
      Resume_Chk <= transport True ;
   end PROC3_1 ;

   procedure PROC3_2 ( Signal Resume_Chk : inout boolean ) is
   begin
      wait until (Num_Cycles = 1000) for P1 ;  -- Dynamic
      Resume_Chk <= transport True ;
   end PROC3_2 ;

   procedure PROC4_1 (Time_To_Wait : Time;
                      Signal Resume_Chk : inout boolean) is
   begin
      wait on Num_Cycles until Dummy_Cond for Time_To_Wait ;
      Resume_Chk <= transport True ;
   end PROC4_1 ;

   procedure PROC4_2 (Time_To_Wait : Time;
                      Signal Resume_Chk : inout boolean) is
   begin
      wait until (Num_Cycles = 1000) for Time_To_Wait ;
      Resume_Chk <= transport True ;
   end PROC4_2 ;

begin
   Test_Control :
   process ( Num_Cycles )
   begin
      if Num_Cycles < 9 then
	 Num_Cycles <= transport Num_Cycles + 1 after 1 ns ;

      elsif Num_Cycles = 9 then
         -- Verify that in fact, none of the wait statements resumed
         test_report ( "ARCH00018" ,
		       "Wait in P1_1 did resume" ,
		       Not P1_1_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in P1_2 did resume" ,
		       Not P1_2_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in P2_1 did resume" ,
		       Not P2_1_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in P2_2 did resume" ,
		       Not P2_2_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in P3_1 did resume" ,
		       Not P3_1_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in P3_2 did resume" ,
		       Not P3_2_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in R1_1 did resume" ,
		       Not R1_1_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in R1_2 did resume" ,
		       Not R1_2_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in PROC1_1 did resume" ,
		       Not PROC1_1_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in PROC1_2 did resume" ,
		       Not PROC1_2_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in PROC2_1 did resume" ,
		       Not PROC2_1_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in PROC2_2 did resume" ,
		       Not PROC2_2_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in PROC3_1 did resume" ,
		       Not PROC3_1_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in PROC3_2 did resume" ,
		       Not PROC3_2_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in PROC4_1 did resume" ,
		       Not PROC4_1_Did_Resume ) ;
         test_report ( "ARCH00018" ,
		       "Wait in PROC4_2 did resume" ,
		       Not PROC4_2_Did_Resume ) ;

      end if ;
   end process Test_Control ;

   P1_1 :
   process
   begin
      wait on Num_Cycles until Dummy_Cond for Time_To_Wait ; -- Locally Static
      P1_1_Did_Resume <= transport True ;
      wait;
   end process P1_1 ;

   P1_2 :
   process
   begin
      wait until (Num_Cycles = 1000) for Time_To_Wait ;  -- Locally Static
      P1_2_Did_Resume <= transport True ;
      wait;
   end process P1_2 ;

   P2_1 :
   process
   begin
      wait on Num_Cycles until Dummy_Cond for G1 ; -- Globally Static
      P2_1_Did_Resume <= transport True ;
      wait;
   end process P2_1 ;

   P2_2 :
   process
   begin
      wait until (Num_Cycles = 1000) for G1 ;  -- Globally Static
      P2_2_Did_Resume <= transport True ;
      wait;
   end process P2_2 ;

   P3_1 :
   process
   begin
      wait on Num_Cycles until Dummy_Cond for P1 ; -- Dynamic
      P3_1_Did_Resume <= transport True ;
      wait;
   end process P3_1 ;

   P3_2 :
   process
   begin
      wait until (Num_Cycles = 1000) for P1 ;  -- Dynamic
      P3_2_Did_Resume <= transport True ;
      wait;
   end process P3_2 ;

   Q1_1 :
   process
   begin
      PROC1_1 (PROC1_1_Did_Resume) ;
      wait;
   end process Q1_1 ;

   Q1_2 :
   process
   begin
      PROC1_2 (PROC1_2_Did_Resume) ;
      wait;
   end process Q1_2 ;

   Q2_1 :
   process
   begin
      PROC2_1 (PROC2_1_Did_Resume) ;
      wait;
   end process Q2_1 ;

   Q2_2 :
   process
   begin
      PROC2_2 (PROC2_2_Did_Resume) ;
      wait;
   end process Q2_2 ;

   Q3_1 :
   process
   begin
      PROC3_1 (PROC3_1_Did_Resume) ;
      wait;
   end process Q3_1 ;

   Q3_2 :
   process
   begin
      PROC3_2 (PROC3_2_Did_Resume) ;
      wait;
   end process Q3_2 ;

   Q4_1 :
   process
   begin
      PROC4_1 (Time_To_Wait, PROC4_1_Did_Resume) ;
      wait;
   end process Q4_1 ;

   Q4_2 :
   process
   begin
      PROC4_2 (P1, PROC4_2_Did_Resume) ;
      wait;
   end process Q4_2 ;

   R1_1 :
   process
   begin
      wait on Num_Cycles until Dummy_Cond ; -- No Time
      R1_1_Did_Resume <= transport True ;
      wait;
   end process R1_1 ;

   R1_2 :
   process
   begin
      wait until (Num_Cycles = 1000) ;  -- No Time
      R1_2_Did_Resume <= transport True ;
      wait;
   end process R1_2 ;


end ARCH00018 ;

entity ENT00018_Test_Bench is
end ENT00018_Test_Bench ;

architecture ARCH00018_Test_Bench of ENT00018_Test_Bench is
begin
   L1:
   block
      component UUT
      end component ;

      for CIS1 : UUT use entity WORK.ENT00018 ( ARCH00018 ) ;
   begin
      CIS1 : UUT ;
   end block L1 ;
end ARCH00018_Test_Bench ;
