/*
 * FLEX VHDL scanner for MVP
 *
 * BY 	: P.S.Elliott
 * DATE : 29/10/93
 *
 */

%{
#include "mvpdef.h"
%}

tab		\t
space		" "
eol		\n
comment		"--".*

decim_strg_nlz	0|([1-9]([0-9_]*[0-9])?)
based_strg_nlz	0|([1-9a-f]([0-9a-f_]*[0-9a-f])?)	

decim_strg_lz	[0-9]([0-9_]*[0-9])?
based_strg_lz	[0-9a-f]([0-9a-f_]*[0-9a-f])?	

decim_intg	([-]?{decim_strg_nlz})|0
based_intg	([-]?{based_strg_nlz})|0

decim_float	{decim_intg}"."{decim_strg_lz}
based_float	{based_intg}"."{based_strg_lz}

exponent	[e][+-]{decim_strg_nlz}

real_number	{decim_float}{exponent}

based_number	{decim_intg}"#"({based_strg_lz}|{based_float})"#"{exponent}?

number		({decim_intg}|{decim_float}|{real_number}|{based_number})

quoted_char	\'.\'
identifier	[a-z][a-z0-9_]*
bit_string	[xob]\"[10]([10_]*[10])?\"
string		\"[^\"\n]*\"

illegal		[^a-z0-9\t\b\n\"\&\'\*\(\)\[\]\_\:\.\,\;\<\>\=]

%%

%{ 
  /* Key Words */ 
%}
abs  			|
access 			|
active			|
after 			|
alias			|
all 			|
and 			|
architecture 		|
array 			|
assert 			|
attribute 		|

begin 			|
block 			|
body 			|
buffer 			|
bus 			|

case 			|
component 		|
configuration		|
constant 		|

disconnect 		|
downto 			|

else 			|
elsif 			|
end 			|
entity 			|
exit 			|

file 			|
for 			|
function 		|

generate 		|
generic 		|
guarded 		|

if 			|
in 			|
inout 			|
is 			|

label 			|
library			|
linkage 		|
loop			|

map 			|
mod			|

nand 			|
new 			|
next 			|
nor 			|
not 			|
null 			|

of 			|
on 			|
open 			|
or 			|
others 			|
out 			|

package 		|
port 			|
procedure 		|
process  		|

range 			|
record 			|
register 		|
rem 			|
report 			|
return 			|

select 			|
severity 		|
signal 			|
subtype 		|

then 			|
to			|
transport 		|
type 			|

units 			|
until 			|
use 			|

variable 		|

wait 			|
when 			|
while 			|
with 			|
xor			return( KEYWORD );

%{ 
  /* Tick Attributes */ 
%}
'active			|
'base			|
'behaviour		|
'delayed		|
'event			|
'high			|
'last_active		|
'last_event		|
'last_value		|
'left			|
'leftof			|
'length			|
'low			| 
'pos			|
'pred			|
'quiet			|
'range			|
'reverse_range		|
'right			|
'rightof		|
'stable			|
'structure		|
'succ			|
'translation		|
'val			return( ATTRIBUTE );

%{ 
  /* Standard Packages etc.. */ 
%}
work            	|	%{ /* Libraries */ 		%}
std			|
ieee			|
synopsys		|
valid			|

standard		|	%{ /* Packages */ 		%}
textio			|
std_logic_1164		|

severity_level		|	%{ /* Misc */ 			%}
std_input		|
std_output		|
true			|
false			|
note			|
warning			|
error			|
failure			|

boolean			|	%{ /* Types */ 			%}
bit			|
bit_vector		|
integer			|
natural			|
positive		|
real			|
time			|
character		|
string			|
line			|
text			|
std_ulogic		|
std_ulogic_vector	|
std_logic		|
std_logic_vector	|

read            	|	%{ /* Procedures/Functions */ 	%}
readline      		|
write         		|
writeline       	|
now			|
endfile			|
rising_edge		|
falling_edge		return( RESERVED );

"+"			|	%{ /* Delimiters */ 		%}
"-"			|
"*"			|
"/"			|
"="			|
"<"			|
"+"			|
">"			|
"("			|
")"			|
"."			|
","			|
";"			|
":"			|
"'"			|
"|"			|
"&"			return( DELIMITER );

":="			|	%{ /* Compound Delimiters */ 	%}
"<="			|
">="			|
"<>"			|
"/="			|
"=>"			|
"**"			return( COMPOUND_DELIM );



{comment}		return( COMMENT );

{quoted_char}		return( QUOTED_CHAR );

{identifier}		return( IDENTIFIER );

{string}		|
{bit_string}		return( STRING );

{number}		return( NUMBER );

{tab}			return( TAB );
{space}			return( SPACE );

{eol}			return( ENDLINE );

{illegal}		return( ILLEGAL );

<<EOF>>        		return( EOF );

.			return( ILLEGAL );

%}



%%


