/*
 * File main.c for MVP
 *
 * BY 	: P.S.Elliott
 * DATE : 29/10/93
 *
 * ext. Nov.94 M. Gumm
 */

#include <stdio.h>
#include <ctype.h>
#include <string.h>
#include "mvpdef.h"
#include "utils.h"
#include "post.h"

char *use[] = { 
"+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
"             PRINT TOOL FOR VHDL SOURCE CODE (PVSC)",
"                     By M. Gumm / Nov. 1994",
"                        Distribute freely",
"",
"            Original Tool (MVP) by P.S. Elliot / 1993",
"",
"                  \" mp \" - Printout Style:", 
"                Original version by Steve Holden",
"-------------------------------------------------------------------",
"Usage: ",
"",
"pvsc -[ulKIF<int>DB<int>E<int>] -[S <subject>] [infile] [> outfile]",
"",
"Otions in [] mean:",
"",
"   ASCII processing:",
"	u	Upper case key words (default)",
"	l	Lower case key words",
"",
"   PostScript processing (default: no PostScript output):",
"	K	Bold key words",
"	I	Bold identifiers",
"	F<int>	Font size (possible: 6, 8, 10 (default), 12, 14)",
"	D	HP Lj4 duplex output",
"	S	Bottom text for all pages (default: <infilename>)",
"	B<int>	Begin output with page no. (default: 1)",
"	E<int>	End output with page no. (default: 1000)",
"	Z	Output with line numbering",
"   Files:",
"	infile	Name of input file; if omitted stdin is read",
"	outfile Dircet output from stdout to outfile",
"++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++",
NULL
};

/**************************************************************************************************/

#ifdef DEBUG

#define PR_TOK(F,T,S)  fprintf(F, "%s : ( %s )\n", T, S)

void pr_tok( out, str,  tok )
	FILE	*out;
	char	*str;
	int	tok;
{
	switch( tok ) {

		case KEYWORD :
			PR_TOK( out, "KEYWORD       ", str );
			break;

		case ATTRIBUTE :
			PR_TOK( out, "ATTRIBUTE     ", str );
			break;

		case RESERVED :
			PR_TOK( out, "RESERVED      ", str );
			break;

		case DELIMITER :
			PR_TOK( out, "DELIMITER     ", str );
			break;

		case COMPOUND_DELIM :
			PR_TOK( out, "COMPOUND_DELIM", str );
			break;

		case COMMENT :
			PR_TOK( out, "COMMENT       ", str );
			break;

		case IDENTIFIER :
			PR_TOK( out, "IDENTIFIER    ", str );
			break;

		case NUMBER :
			PR_TOK( out, "NUMBER        ", str );
			break;

		case SPACE :
			PR_TOK( out, "SPACE         ", str );
			break;

		case TAB :
			PR_TOK( out, "TAB           ", str );
			break;

		case ENDLINE :
			PR_TOK( out, "ENDLINE       ", "<nl>" );
			break;

		case QUOTED_CHAR :
			PR_TOK( out, "QUOTED_CHAR   ", str );
			break;

		case STRING :
			PR_TOK( out, "STRING        ", str );
			break;

		case ILLEGAL :
			PR_TOK( out, "ILLEGAL       ", str );
			break;

		default :
			PR_TOK( out, "OTHER         ", str );
			break;

	}
}

#endif

/**************************************************************************************************/

void get_arguments();

int main(argc, argv)
	int             argc;
	char           *argv[];
{
	FILE		*out, *nulldev, *tmpfileptr;

	case_t   	key_case = upper;	/* flag for keyword-case conversion, def.: upper */
	emphasis_t     	emphasis = none;	/* flag for PS-output: def.: no PS output*/

	int		fsize;			/* caracter size (PS) , default: 10 */
	int             tok = NULL;		/* actual token*/
	int             lineno = 1;		/* overall line counter */
	int		pageno = 1;		/* page counter (PS) */
	int 		lineonpage =1;		/* line number on actual output page (PS) */
	int		linesperpage;		/* number of lines per page, default 55 */
	int		firsttok = 1;		/* flag for first token in output line (PS) */
	int		fileflag = 0;		/* flag: 1 = filename is given */
	int		subjectflag = 0;	/* flag: 1 = subject given */
	int		duplex = 0;		/* flag: 1 = HP lj4 duplex mode */
	int		psfirstpage;		/* first page to put out (PS) */
	int		pslastpage;		/* last page to put out (PS)*/
	int		lnumflag;		/* flag: 1 = show line numbers (PS)*/ 
	char		tmp_str[256];		/* temporary storage for strings */
	char		time_str[32];		/* actual time (PS) */
	char		subject_str[128];	/* subject string for bottom line (PS) */
	char		file_str[256];		/* input file, def.: stdin */
	char		*nulldev_str = "/dev/null"; /* unix path name for null device */

	yyin = stdin;
	out = stdout;
	nulldev = fopen(nulldev_str, "w");
	
	subject_str[0] = '\0';
	maxcharperline = 80;			/* glob. variable: number of chars per line */
	linesperpage =54;			/* set defaults */
	fsize =10;
	psfirstpage = 1;
	pslastpage = 10000;
	lnumflag = 0;	

	switch (argc) 
	{
	case 1:					/* no arguments => man page output */
		txt_out( stderr, use );
		exit(8);

	default:				/* get arguments and set variables */
		get_arguments(argc, argv, file_str, subject_str, &fsize, &key_case, &emphasis,
			      &linesperpage, &maxcharperline, &duplex, &subjectflag, &fileflag,
			      &psfirstpage, &pslastpage, &lnumflag);
		break;
	}

	if (fileflag == 1)			/* infile name given => open infile */
		yyin = fopen(file_str,"r");

	if (lnumflag ==1)			/* line numbers => reserve space in line */
		maxcharperline -= 6;

	if (emphasis != none)			/* PS => header data output */
	{
		txt_out( out, ps_header_1 );
		if (duplex ==1) txt_out( out, ps_duplex );
		fprintf(out, "/FSize %d def\n", fsize);
		txt_out( out, ps_header_2 );
	}

	tmpfileptr = out;			
	if (pageno < psfirstpage)		/* do not print this page ? => trash output */
		out = nulldev;

	while ( ( tok = yylex() ) != EOF )	/* main while loop : get token from input */
	{
		
		if ((lineonpage == 1) && (firsttok == 1) && (emphasis != none))
		{	/* output of PS page header */
			fprintf(out, "\%\%\%\%Page: ? %d\n",pageno);
			fprintf(out, "(%d%) newpage\n",pageno);
			txt_out(out, ps_page_header);
			fprintf(out, "/Subject (%s) def\n",subject_str);
			get_timestring(time_str);
			fprintf(out, "/TimeNow (%s) def\n",time_str);
		}			

		if ((firsttok ==1) && (emphasis != none) && (lnumflag == 1))
		{	/* ouput of line number */
			ps_lineno_out(out, lineno);

		}

		if ( tok == ENDLINE )
		{	/* EOL => increase counters */
			lineno++;
			lineonpage++;
		}

		strcpy(tmp_str, yytext);

		if ( tok == ILLEGAL )
		{	/* illegal token in input file */
			fprintf( stderr, 
			"\nERROR : illegal character ('%s') at line %d.\n\n",tmp_str, lineno );
			exit(8);
		}
		else if ( tok == KEYWORD || tok == RESERVED || tok == ATTRIBUTE ) 
		{	/* change letter case of key words */	
			if ( key_case == upper )
				to_uppercase( tmp_str );
			else
				to_lowercase( tmp_str );
		}
		else if ( tok == IDENTIFIER ) 
		{	/* change letter case of identifiers */
			if ( key_case == lower )
				to_uppercase( tmp_str );
			else
				to_lowercase( tmp_str );
		};

#ifdef DEBUG
		pr_tok( out, tmp_str, tok );
#else
		if ( emphasis != none )			
		{	/* PS output of token */
			lineonpage += ps_out( out, emphasis, tok, tmp_str );
			
			if (tok != ENDLINE)	
				firsttok = 0;
			else
				firsttok = 1;
			
			if ( lineonpage >= linesperpage)
			{	/* page finished ? */
				if ( tok != ENDLINE)
				{
					lineonpage += ps_out( out, emphasis, ENDLINE, tmp_str);	
					firsttok = 1;
				}
				fprintf(out, "(%d) 1 endcol\n", pageno);
				fprintf(out, "(%d) endpage\n", pageno); 
				pageno++;
				lineonpage = 1;
				
				/* redirect output to trash for next page ? */
				if ((pageno >= psfirstpage) && (pageno <= pslastpage))
					out = tmpfileptr;
				else
					out = nulldev;
			}

		}
		else
		{	/* ASCII output of token */
			fprintf( out, "%s",tmp_str );
		}	
#endif	
	}	/* end of while loop*/
		
	if (fileflag == 1)		/* close input file */
		fclose(yyin);

	if (emphasis != none)
	{	/* PS output : trailer */
		if ( (pageno == 1) || (lineonpage != 1) ) 
		{	
			fprintf(out, "(%d) 1 endcol\n", pageno);
			fprintf(out, "(%d) endpage\n", pageno); 
		}
		printf("\%\%\%\%Trailer\n");
		printf("\%\%\%\%Pages: %d\n",pageno);
	}
	
	fclose(nulldev);		/* close trash can */
	return (0);			/*  ... and finish */
}	/* main */


/**********************************************************************************/
/* get_arguments() : read in arguments from command line                          */
/**********************************************************************************/

void get_arguments(argc, argv, file_str, subject_str, fsize, key_case, emphasis,
		   linesperpage, maxcharperline, duplex, subjectflag, fileflag,
		   psfirstpage, pslastpage, lnumflag)
	int             argc;
	char           	*argv[];
	char		*file_str, *subject_str;
	case_t   	*key_case;	
	emphasis_t     	*emphasis;	
	int		*fsize, *linesperpage, *maxcharperline, *duplex, *subjectflag; 
	int		*fileflag, *psfirstpage, *pslastpage, *lnumflag;
{
	int             i, j;			/* no. of argument / number of char. in argument */
	char            ch,*pc;

	i = 0;
	while (++i < argc)
	{
		if (argv[i][0] == '-') 
		{	/* get optional flags */
			j = 0;
			while ((ch = argv[i][j++]) != NULL) 
			{
				switch (ch)
				{
					case 'u':
						*key_case = upper;
						break;
					case 'l':
 						*key_case = lower;
						break;
					case 'K':
						*emphasis = key;
						break;
					case 'I':
						*emphasis = ident;
						break;
					case 'F':
						*fsize = 0;
						while (isdigit((ch = argv[i][j++])))
						{
							*fsize *= 10;
							*fsize += ch - '0';
						}
						j--;
						switch (*fsize)
						{
						case 6 : *linesperpage = 92;
							 *maxcharperline = 136;
							 break;
						case 8 : *linesperpage = 65;
							 *maxcharperline = 102;
							 break;
						case 12: *linesperpage = 47;
							 *maxcharperline = 62;
							 break;
						case 14: *linesperpage = 39;
							 *maxcharperline = 58;
							 break;
						default: *linesperpage = 54;
							 *maxcharperline = 84;
							 *fsize =10;
							 break;
						}
						break;
					case 'D':
						*duplex = 1;
						break;
					case 'S':
						pc = &argv[i][j];
						strcpy(subject_str,pc);
						j += strlen(subject_str);
						*subjectflag = 1;
						break;
					case 'B':
						*psfirstpage = 0;
						while (isdigit((ch = argv[i][j++])))
						{
							*psfirstpage *= 10;
							*psfirstpage += ch - '0';
						}
						j--;
						break;
					case 'E':
						*pslastpage = 0;
						while (isdigit((ch = argv[i][j++])))
						{
							*pslastpage *= 10;
							*pslastpage += ch - '0';
						}
						j--;
						break;
					case 'Z':
						*lnumflag =1;
						break;
					default:
						/*printf("%c\n", ch);*/
						if (ch != '-') 
						{
							txt_out( stderr, use );
							exit(8);
						}
						break;
				}	/* switch */
			}	/* while */
		}	/* if*/
		else
		{	/* get input file name */
			j = 0;
			pc = &argv[i][j];
			strcpy(file_str,pc);
			*fileflag = 1;
			if (*subjectflag != 1)
				strcpy(subject_str,file_str);
		}	/* else */
	}	/* while */ 
}	/* function*/
