--
-- Copyright 1990 
--
-- WAVES Standard Packages Version 3.3.2
-- 25 October 1990
--
-- This code is distributed for the purposes of evaluating the 
-- Waveform And Vector Exchange Specification (WAVES) proposal 
-- presented to the IEEE by the WAVES Analysis and Standardization 
-- Group.  This code may not be used for commercial purposes and 
-- may not be redistributed or published without permission of the 
-- Chairman of the WAVES Analysis and Standardization Group, 
-- Mr Robert Hillman.
--
-- Address comments or questions to:
--    Robert Hillman
--    RADC/RBRP     
--    Griffis AFB, NY
--    (315) 330-2241 
--                   
--    hillman@tisss.radc.af.mil
--
--
-- This package defines system dependent information and private
-- types used by the WAVES packages. 
-- 
package WAVES_SYSTEM is 
  

  type OPERATOR_TYPE is (
    GREATER_THAN,
    GREATER_THAN_OR_EQUAL,
    LESS_THAN,
    LESS_THAN_OR_EQUAL,
    EQUAL,
    NOT_EQUAL,
    LOGICAL_AND,
    LOGICAL_OR,
    LOGICAL_XOR,
    LOGICAL_NOT,
    UNSPECIFIED,
    CONCATENATION
  ) ;

  type OPERATOR_KIND is (
    EVENT_VALUE_KIND,
    STATE_KIND,
    STRENGTH_KIND,
    DIRECTION_KIND,
    RELEVANCE_KIND
  );

  type STATE_TYPE is (LOW, MIDBAND, HIGH);

  type STATE_VALUE is record
    VALUE       : STATE_TYPE;
    FLAG        : BOOLEAN;
    MODIFIER    : REAL;
  end record;
    
  type STRENGTH_TYPE is (DISCONNECTED, CAPACITIVE, RESISTIVE, DRIVE, SUPPLY);

  type STRENGTH_VALUE is record
    VALUE       : STRENGTH_TYPE;
    FLAG        : BOOLEAN;
    MODIFIER    : REAL;
  end record;
    
  type DIRECTION_TYPE is (STIMULUS, RESPONSE);

  type RELEVANCE_TYPE is (OBSERVED, PREDICTED, REQUIRED);

  constant UNKNOWN_VALUE : INTEGER := -1;
  constant UNUSED_VALUE  : INTEGER := -1;

  type EVENT_VALUE_ELEMENT is record
    OPERATOR    : OPERATOR_TYPE;
    KIND        : OPERATOR_KIND;
    VALUE       : INTEGER;	-- Positional value
    FLAG        : BOOLEAN;	-- Modifier flag
    MODIFIER    : REAL;
  end record;

  type SYSTEM_EVENT_VALUE is array (NATURAL range <>) of EVENT_VALUE_ELEMENT;

  type UNKNOWN_KEYWORD is (KEYWORD, NOT_KEYWORD);

  type STATE_KEYWORD is (KEYWORD, NOT_KEYWORD);

  type STRENGTH_KEYWORD is (KEYWORD, NOT_KEYWORD);

  type DIRECTION_KEYWORD is (KEYWORD, NOT_KEYWORD);

  type RELEVANCE_KEYWORD is (KEYWORD, NOT_KEYWORD);

  type SYSTEM_EVENT_TIME is record
    NOMINAL		  : TIME;
    TOLERANCES_SPECIFIED  : BOOLEAN;
    EARLIEST              : TIME;
    LATEST                : TIME;
    BASE_EVENT            : NATURAL;	-- Event Index
    BASE_PIN              : NATURAL;	-- Test Pin
  end record;

  type SYSTEM_EVENT is record
     VALUE               : NATURAL;	-- Logic Value
     TIME                : SYSTEM_EVENT_TIME;
  end record;

  type SYSTEM_EVENT_TIME_BASIS is record
    TOLERANCES_SPECIFIED  : BOOLEAN;
    EARLIEST              : TIME;
    LATEST                : TIME;
    BASE_EVENT            : NATURAL;	-- Event Index
    BASE_PIN              : NATURAL;	-- Test Pin
  end record;

  type SYSTEM_TAGGED_KIND is (UNUSED, T_PIN, T_CODE, T_LOGIC, T_FRAME);

  -- Main storage element for Frames, Frame Sets, and Frame Set Arrays.
  type SYSTEM_TAGGED_EVENT is record
    KIND                 : SYSTEM_TAGGED_KIND;
    NEXT_INDEX           : INTEGER;
    TAGGED               : SYSTEM_EVENT;
  end record;

  type SYSTEM_FRAME is array 
      (POSITIVE range <>) of SYSTEM_TAGGED_EVENT;
  
  type SYSTEM_FRAME_SET is array 
      (POSITIVE range <>) of SYSTEM_TAGGED_EVENT;
  
  type SYSTEM_LOGIC_MAP is array
      (POSITIVE range <>) of SYSTEM_TAGGED_EVENT;

  type SYSTEM_FRAME_SET_ARRAY is array 
      (POSITIVE range <>) of SYSTEM_TAGGED_EVENT;

  type SYSTEM_MATCH_CONTROL is (HOLD, SAMPLE);

  type SYSTEM_WAVES_PORT is record
    L_VALUE         : NATURAL;		-- Logic Value
    TAG_VALUE       : CHARACTER;	-- Tag Value
    M_CONTROL       : SYSTEM_MATCH_CONTROL;
    DELAY_LOGIC     : INTEGER;		-- Logic Value
  end record;

  type SYSTEM_WAVES_MATCH is record
    M_VALUE         : BOOLEAN;		-- Match Flag
    D_VALUE         : BOOLEAN;		-- Delay Flag
  end record;

  type SYSTEM_WAVES_PORT_LIST is array (POSITIVE range <>) of SYSTEM_WAVES_PORT;

  type SYSTEM_WAVES_MATCH_LIST is array (POSITIVE range <>) of SYSTEM_WAVES_MATCH;

  type SYSTEM_DELAY_TIME_TYPE is (TIMED_DELAY, HANDSHAKE_DELAY);

  type SYSTEM_DELAY_TIME_BASIS is record
    TOLERANCES_SPECIFIED  : BOOLEAN;
    EARLIEST              : TIME;
    LATEST                : TIME;
    DELAY_TYPE            : SYSTEM_DELAY_TIME_TYPE;
    BASE_EVENT            : NATURAL;	-- Event Index
    BASE_LOGIC            : NATURAL;    -- Logic value
    BASE_PIN              : NATURAL;	-- Test Pin
  end record;

  type SYSTEM_DIRECTION_SUMMARY is (
      DIR_UNSPECIFIED, DIR_UNKNOWN, DIR_STIMULUS, DIR_RESPONSE, DIR_COMPOUND); 

end WAVES_SYSTEM;
