--
-- Copyright 1990 
--
-- WAVES Standard Packages Version 3.3.2
-- 25 October 1990
--
-- This code is distributed for the purposes of evaluating the 
-- Waveform And Vector Exchange Specification (WAVES) proposal 
-- presented to the IEEE by the WAVES Analysis and Standardization 
-- Group.  This code may not be used for commercial purposes and 
-- may not be redistributed or published without permission of the 
-- Chairman of the WAVES Analysis and Standardization Group, 
-- Mr Robert Hillman.
--
-- Address comments or questions to:
--    Robert Hillman          
--    RADC/RBRP               
--    Griffis AFB, NY         
--    (315) 330-2241          
--                            
--    hillman@tisss.radc.af.mil      
--
library WAVES_STANDARD;
use     WAVES_STANDARD.WAVES_SYSTEM;
package WAVES_STANDARD is 
  
  -- -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  -- 
  -- The following are the type definition and functions used to 
  -- describe Event Value objects.  The EVENT_VALUE type is system 
  -- dependent.
  -- 
  subtype EVENT_VALUE is WAVES_SYSTEM.SYSTEM_EVENT_VALUE;
  
  -- 
  function UNSPECIFIED return EVENT_VALUE;
  function UNKNOWN     return WAVES_SYSTEM.UNKNOWN_KEYWORD;

  function STATE             return WAVES_SYSTEM.STATE_KEYWORD;
  function LOW		     return WAVES_SYSTEM.STATE_VALUE;
  function LOW(X : REAL)     return WAVES_SYSTEM.STATE_VALUE;
  function MIDBAND	     return WAVES_SYSTEM.STATE_VALUE;
  function MIDBAND(X : REAL) return WAVES_SYSTEM.STATE_VALUE;
  function HIGH		     return WAVES_SYSTEM.STATE_VALUE;
  function HIGH(X : REAL)    return WAVES_SYSTEM.STATE_VALUE;

  function ">" (X : WAVES_SYSTEM.STATE_KEYWORD; Y : WAVES_SYSTEM.STATE_VALUE)
    return EVENT_VALUE;
  function "<" (X : WAVES_SYSTEM.STATE_KEYWORD; Y : WAVES_SYSTEM.STATE_VALUE)
    return EVENT_VALUE;
  function "=" (X : WAVES_SYSTEM.STATE_KEYWORD; Y : WAVES_SYSTEM.STATE_VALUE)
    return EVENT_VALUE;
  function "=" (X : WAVES_SYSTEM.STATE_KEYWORD;
                Y : WAVES_SYSTEM.UNKNOWN_KEYWORD) return EVENT_VALUE;
  function "/="(X : WAVES_SYSTEM.STATE_KEYWORD; Y : WAVES_SYSTEM.STATE_VALUE)
    return EVENT_VALUE;
  function ">="(X : WAVES_SYSTEM.STATE_KEYWORD; Y : WAVES_SYSTEM.STATE_VALUE)
    return EVENT_VALUE;
  function "<="(X : WAVES_SYSTEM.STATE_KEYWORD; Y : WAVES_SYSTEM.STATE_VALUE)
    return EVENT_VALUE;

  function STRENGTH    	          return WAVES_SYSTEM.STRENGTH_KEYWORD;
  function DISCONNECTED		  return WAVES_SYSTEM.STRENGTH_VALUE;
  function DISCONNECTED(X : REAL) return WAVES_SYSTEM.STRENGTH_VALUE;
  function CAPACITIVE		  return WAVES_SYSTEM.STRENGTH_VALUE;
  function CAPACITIVE(X : REAL)   return WAVES_SYSTEM.STRENGTH_VALUE;
  function RESISTIVE		  return WAVES_SYSTEM.STRENGTH_VALUE;
  function RESISTIVE(X : REAL)    return WAVES_SYSTEM.STRENGTH_VALUE;
  function DRIVE		  return WAVES_SYSTEM.STRENGTH_VALUE;
  function DRIVE(X : REAL)        return WAVES_SYSTEM.STRENGTH_VALUE;
  function SUPPLY		  return WAVES_SYSTEM.STRENGTH_VALUE;
  function SUPPLY(X : REAL)       return WAVES_SYSTEM.STRENGTH_VALUE;

  function ">" (X : WAVES_SYSTEM.STRENGTH_KEYWORD; 
		Y : WAVES_SYSTEM.STRENGTH_VALUE)
    return EVENT_VALUE;
  function "<" (X : WAVES_SYSTEM.STRENGTH_KEYWORD; 
		Y : WAVES_SYSTEM.STRENGTH_VALUE)
    return EVENT_VALUE;
  function "=" (X : WAVES_SYSTEM.STRENGTH_KEYWORD; 
		Y : WAVES_SYSTEM.STRENGTH_VALUE)
    return EVENT_VALUE;
  function "=" (X : WAVES_SYSTEM.STRENGTH_KEYWORD;
                Y : WAVES_SYSTEM.UNKNOWN_KEYWORD) return EVENT_VALUE;
  function "/="(X : WAVES_SYSTEM.STRENGTH_KEYWORD; 
		Y : WAVES_SYSTEM.STRENGTH_VALUE)
    return EVENT_VALUE;
  function ">="(X : WAVES_SYSTEM.STRENGTH_KEYWORD; 
		Y : WAVES_SYSTEM.STRENGTH_VALUE)
    return EVENT_VALUE;
  function "<="(X : WAVES_SYSTEM.STRENGTH_KEYWORD; 
		Y : WAVES_SYSTEM.STRENGTH_VALUE)
    return EVENT_VALUE;

  function DIRECTION   return WAVES_SYSTEM.DIRECTION_KEYWORD;
  function STIMULUS    return WAVES_SYSTEM.DIRECTION_TYPE;
  function RESPONSE    return WAVES_SYSTEM.DIRECTION_TYPE;

  function "=" (X : WAVES_SYSTEM.DIRECTION_KEYWORD; 
		Y : WAVES_SYSTEM.DIRECTION_TYPE)
    return EVENT_VALUE;
  function "=" (X : WAVES_SYSTEM.DIRECTION_KEYWORD;
                Y : WAVES_SYSTEM.UNKNOWN_KEYWORD) return EVENT_VALUE;

  function RELEVANCE  return WAVES_SYSTEM.RELEVANCE_KEYWORD;
  function REQUIRED   return WAVES_SYSTEM.RELEVANCE_TYPE;
  function PREDICTED return WAVES_SYSTEM.RELEVANCE_TYPE;
  function OBSERVED   return WAVES_SYSTEM.RELEVANCE_TYPE;

  function "=" (X : WAVES_SYSTEM.RELEVANCE_KEYWORD; 
		Y : WAVES_SYSTEM.RELEVANCE_TYPE)
    return EVENT_VALUE;
  function "=" (X : WAVES_SYSTEM.RELEVANCE_KEYWORD;
                Y : WAVES_SYSTEM.UNKNOWN_KEYWORD) return EVENT_VALUE;

  function "not"(X    : EVENT_VALUE) return EVENT_VALUE;
  function "and"(X, Y : EVENT_VALUE) return EVENT_VALUE;
  function "or" (X, Y : EVENT_VALUE) return EVENT_VALUE;
  function "xor"(X, Y : EVENT_VALUE) return EVENT_VALUE;
  function "+"  (X, Y : EVENT_VALUE) return EVENT_VALUE;

  -- -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  -- 
  -- The following type declaration permits a summary of the expected
  -- pin direction for a waveform.
  --
  subtype DIRECTION_SUMMARY is WAVES_SYSTEM.SYSTEM_DIRECTION_SUMMARY;

  function UNSPECIFIED return DIRECTION_SUMMARY;
  function UNKNOWN     return DIRECTION_SUMMARY;
  function STIMULUS    return DIRECTION_SUMMARY;
  function RESPONSE    return DIRECTION_SUMMARY;
  function COMPOUND    return DIRECTION_SUMMARY;

  type DIRECTION_LIST is array (POSITIVE range <>) of DIRECTION_SUMMARY;
  
end WAVES_STANDARD;
--
-- Copyright 1990 
--
-- WAVES Standard Packages Version 3.3.2
-- 25 October 1990
--
-- This code is distributed for the purposes of evaluating the 
-- Waveform And Vector Exchange Specification (WAVES) proposal 
-- presented to the IEEE by the WAVES Analysis and Standardization 
-- Group.  This code may not be used for commercial purposes and 
-- may not be redistributed or published without permission of the 
-- Chairman of the WAVES Analysis and Standardization Group, 
-- Mr Robert Hillman.
--
-- Address comments or questions to:
--    Robert Hillman           
--    RADC/RBRP                
--    Griffis AFB, NY          
--    (315) 330-2241           
--                             
--    hillman@tisss.radc.af.mil
--
package body WAVES_STANDARD is 
  
  -- -=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-=-
  -- 
  -- These definitions provide the parameter types needed for the
  -- EVALUE function.  Each type defines the meta values UNSPECIFIED
  -- and UNKNOWN in addition to the legal values for the corresponding
  -- component. The order of the declarations is significant, since
  -- variables of these types will initialized to UNSPECIFIED. 
  -- 
  function UNSPECIFIED return EVENT_VALUE
  is
    variable X : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Unspecified, 
	WAVES_SYSTEM.Event_Value_Kind, 
	WAVES_SYSTEM.Unused_Value, FALSE, 0.0));
  begin
    return X;
  end;

  function UNKNOWN return WAVES_SYSTEM.Unknown_Keyword
  is
  begin
    return WAVES_SYSTEM.Keyword;
  end;

  function State return WAVES_SYSTEM.State_Keyword
  is
  begin
    return WAVES_SYSTEM.Keyword;
  end State;

  function LOW return WAVES_SYSTEM.State_Value
  is
  begin
    return (WAVES_SYSTEM.LOW, FALSE, 0.0);
  end LOW;

  function LOW (X : REAL) return WAVES_SYSTEM.State_Value
  is
  begin
    return (WAVES_SYSTEM.LOW, TRUE, X);
  end LOW;

  function MIDBAND return WAVES_SYSTEM.State_Value
  is
  begin
    return (WAVES_SYSTEM.MIDBAND, FALSE, 0.0);
  end MIDBAND;
  
  function MIDBAND (X : REAL) return WAVES_SYSTEM.State_Value
  is
  begin
    return (WAVES_SYSTEM.MIDBAND, TRUE, X);
  end MIDBAND;
  
  function HIGH return WAVES_SYSTEM.State_Value
  is
  begin
    return (WAVES_SYSTEM.HIGH, FALSE, 0.0);
  end HIGH;

  function HIGH (X : REAL) return WAVES_SYSTEM.State_Value
  is
  begin
    return (WAVES_SYSTEM.HIGH, TRUE, X);
  end HIGH;
  
  function ">" (X : WAVES_SYSTEM.State_Keyword; 
		Y : WAVES_SYSTEM.State_Value)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (WAVES_SYSTEM.Greater_than,
	WAVES_SYSTEM.State_Kind, 
	WAVES_SYSTEM.State_Type'POS(Y.Value), 
	Y.Flag, Y.Modifier));
  begin
    return Z;
  end;

  function "<" (X : WAVES_SYSTEM.State_Keyword; 
		Y : WAVES_SYSTEM.State_Value)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (WAVES_SYSTEM.Less_than,
	WAVES_SYSTEM.State_Kind, 
	WAVES_SYSTEM.State_Type'POS(Y.Value), 
	Y.Flag, Y.Modifier));
  begin
    return Z;
  end;

  function "=" (X : WAVES_SYSTEM.State_Keyword; 
		Y : WAVES_SYSTEM.State_Value)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (WAVES_SYSTEM.Equal,
	WAVES_SYSTEM.State_Kind, 
	WAVES_SYSTEM.State_Type'POS(Y.Value), 
	Y.Flag, Y.Modifier));
  begin
    return Z;
  end;
  function "=" (X : WAVES_SYSTEM.State_Keyword;
                Y : WAVES_SYSTEM.Unknown_keyword) return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (WAVES_SYSTEM.Equal,
	WAVES_SYSTEM.State_Kind, 
	WAVES_SYSTEM.Unknown_Value, FALSE, 0.0)); 
  begin
    return Z;
  end;
  function "/=" (X : WAVES_SYSTEM.State_Keyword; 
		 Y : WAVES_SYSTEM.State_Value)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (WAVES_SYSTEM.Not_Equal,
	WAVES_SYSTEM.State_Kind, 
	WAVES_SYSTEM.State_Type'POS(Y.Value), 
	Y.Flag, Y.Modifier));
  begin
    return Z;

  end;

  function ">="(X : WAVES_SYSTEM.State_Keyword; 
		Y : WAVES_SYSTEM.State_Value)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Greater_Than_Or_Equal,
	WAVES_SYSTEM.State_Kind, 
	WAVES_SYSTEM.State_Type'POS(Y.Value), 
	Y.Flag, Y.Modifier));
  begin
    return Z;
  end;
  function "<="(X : WAVES_SYSTEM.State_Keyword; 
		Y : WAVES_SYSTEM.State_Value)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Less_than_Or_Equal,
	WAVES_SYSTEM.State_Kind, 
	WAVES_SYSTEM.State_Type'POS(Y.Value), 
	Y.Flag, Y.Modifier));
  begin
    return Z;
  end;

  function Strength return WAVES_SYSTEM.Strength_Keyword
  is
  begin
    return WAVES_SYSTEM.Keyword;
  end;
  
  function DISCONNECTED return WAVES_SYSTEM.Strength_Value
  is
  begin
    return (WAVES_SYSTEM.DISCONNECTED, FALSE, 0.0);
  end DISCONNECTED;

  function DISCONNECTED (X : REAL) return WAVES_SYSTEM.Strength_Value
  is
  begin
    return (WAVES_SYSTEM.DISCONNECTED, TRUE, X);
  end DISCONNECTED;

  function CAPACITIVE return WAVES_SYSTEM.Strength_Value
  is
  begin
    return (WAVES_SYSTEM.CAPACITIVE, FALSE, 0.0);
  end CAPACITIVE;

  function CAPACITIVE (X : REAL) return WAVES_SYSTEM.Strength_Value
  is
  begin
    return (WAVES_SYSTEM.CAPACITIVE, TRUE, X);
  end CAPACITIVE;

  function RESISTIVE return WAVES_SYSTEM.Strength_Value
  is
  begin
    return (WAVES_SYSTEM.RESISTIVE, FALSE, 0.0);
  end RESISTIVE;

  function RESISTIVE (X : REAL) return WAVES_SYSTEM.Strength_Value
  is
  begin
    return (WAVES_SYSTEM.RESISTIVE, TRUE, X);
  end RESISTIVE;

  function DRIVE return WAVES_SYSTEM.Strength_Value
  is
  begin
    return (WAVES_SYSTEM.DRIVE, FALSE, 0.0);
  end DRIVE;

  function DRIVE (X : REAL) return WAVES_SYSTEM.Strength_Value
  is
  begin
    return (WAVES_SYSTEM.DRIVE, TRUE, X);
  end DRIVE;

  function SUPPLY return WAVES_SYSTEM.Strength_Value
  is
  begin
    return (WAVES_SYSTEM.SUPPLY, FALSE, 0.0);
  end SUPPLY;

  function SUPPLY (X : REAL) return WAVES_SYSTEM.Strength_Value
  is
  begin
    return (WAVES_SYSTEM.SUPPLY, TRUE, X);
  end SUPPLY;

  function ">" (X : WAVES_SYSTEM.Strength_Keyword; 
		Y : WAVES_SYSTEM.Strength_Value)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Greater_than,
	WAVES_SYSTEM.Strength_Kind, 
	WAVES_SYSTEM.Strength_Type'POS(Y.Value), 
	Y.Flag, Y.Modifier));
  begin
    return Z;
  end;

  function "<" (X : WAVES_SYSTEM.Strength_Keyword; 
		Y : WAVES_SYSTEM.Strength_Value)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Less_than,
	WAVES_SYSTEM.Strength_Kind, 
	WAVES_SYSTEM.Strength_Type'POS(Y.Value), 
	Y.Flag, Y.Modifier));
  begin
    return Z;
  end;
  
  function "=" (X : WAVES_SYSTEM.Strength_Keyword; 
		Y : WAVES_SYSTEM.Strength_Value)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Equal,
	WAVES_SYSTEM.Strength_Kind, 
	WAVES_SYSTEM.Strength_Type'POS(Y.Value), 
	Y.Flag, Y.Modifier));
  begin
    return Z;
  end;

  function "=" (X : WAVES_SYSTEM.Strength_Keyword;
                Y : WAVES_SYSTEM.Unknown_keyword) return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Equal,
	WAVES_SYSTEM.Strength_Kind, 
	WAVES_SYSTEM.Unknown_Value, FALSE, 0.0)); 
  begin
    return Z;
  end;
  function "/=" (X : WAVES_SYSTEM.Strength_Keyword; 
		 Y : WAVES_SYSTEM.Strength_Value)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Not_Equal,
	WAVES_SYSTEM.Strength_Kind, 
	WAVES_SYSTEM.Strength_Type'POS(Y.Value), 
	Y.Flag, Y.Modifier));
  begin
    return Z;
  end;
  function ">="(X : WAVES_SYSTEM.Strength_Keyword; 
		Y : WAVES_SYSTEM.Strength_Value)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Greater_than_or_Equal,
	WAVES_SYSTEM.Strength_Kind, 
	WAVES_SYSTEM.Strength_Type'POS(Y.Value), 
	Y.Flag, Y.Modifier));
  begin
    return Z;
  end;
  function "<="(X : WAVES_SYSTEM.Strength_Keyword; 
		Y : WAVES_SYSTEM.Strength_Value)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Less_than_or_Equal,
	WAVES_SYSTEM.Strength_Kind, 
	WAVES_SYSTEM.Strength_Type'POS(Y.Value), 
	Y.Flag, Y.Modifier));
  begin
    return Z;
  end;

  function Direction return WAVES_SYSTEM.Direction_Keyword
  is
  begin
    return WAVES_SYSTEM.Keyword;
  end Direction;
  
  function STIMULUS return WAVES_SYSTEM.Direction_Type
  is
  begin
    return WAVES_SYSTEM.STIMULUS;
  end STIMULUS;

  function RESPONSE return WAVES_SYSTEM.Direction_Type
  is
  begin
    return WAVES_SYSTEM.RESPONSE;
  end RESPONSE;

  function "=" (X : WAVES_SYSTEM.Direction_Keyword; 
		Y : WAVES_SYSTEM.Direction_Type)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Equal,
	WAVES_SYSTEM.Direction_Kind, 
	WAVES_SYSTEM.Direction_Type'POS(Y), 
	FALSE, 0.0));
  begin
    return Z;
  end;
  function "=" (X : WAVES_SYSTEM.Direction_Keyword;
                Y : WAVES_SYSTEM.Unknown_keyword) return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Equal,
	WAVES_SYSTEM.Direction_Kind, 
	WAVES_SYSTEM.Unknown_Value, 
	FALSE, 0.0));
  begin
    return Z;
  end;

  function Relevance return WAVES_SYSTEM.Relevance_Keyword
  is
  begin
    return WAVES_SYSTEM.Keyword;
  end;
  
  function REQUIRED return WAVES_SYSTEM.Relevance_Type
  is
  begin
    return WAVES_SYSTEM.REQUIRED;
  end;
  
  function PREDICTED return WAVES_SYSTEM.Relevance_Type
  is
  begin
    return WAVES_SYSTEM.PREDICTED;
  end;
  
  function OBSERVED return WAVES_SYSTEM.Relevance_Type
  is
  begin
    return WAVES_SYSTEM.OBSERVED;
  end;
  
  function "=" (X : WAVES_SYSTEM.Relevance_Keyword; 
		Y : WAVES_SYSTEM.Relevance_Type)
    return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Equal,
	WAVES_SYSTEM.Relevance_Kind, 
	WAVES_SYSTEM.Relevance_Type'POS(Y), 
	FALSE, 0.0));
  begin
    return Z;
  end;
  function "=" (X : WAVES_SYSTEM.Relevance_Keyword;
                Y : WAVES_SYSTEM.Unknown_keyword) return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to 1) := (1 => (
	WAVES_SYSTEM.Equal,
	WAVES_SYSTEM.Relevance_Kind, 
	WAVES_SYSTEM.Unknown_Value, 
	FALSE, 0.0));
  begin
    return Z;
  end;

  function "not"(X : EVENT_VALUE) return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to X'LENGTH + 1);
  begin
    Z(1) := (
	WAVES_SYSTEM.Logical_Not,
	WAVES_SYSTEM.Event_Value_Kind,
	WAVES_SYSTEM.Unused_Value, FALSE, 0.0);
    for I in X'RANGE loop
      Z(I + 1) := X(I);
    end loop;
    return Z;
  end;

  function "and"(X, Y : EVENT_VALUE) return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to X'LENGTH + Y'LENGTH + 1);
  begin
    Z(1) := (
	WAVES_SYSTEM.Logical_And,
	WAVES_SYSTEM.Event_Value_Kind,
	WAVES_SYSTEM.Unused_Value, FALSE, 0.0);
    for I in X'RANGE loop
      Z(I + 1) := X(I);
    end loop;
    for I in Y'RANGE loop
      Z(X'LENGTH + I + 1) := Y(I);
    end loop;
    return Z;
  end;

  function "or"(X, Y : EVENT_VALUE) return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to X'LENGTH + Y'LENGTH + 1);
  begin
    Z(1) := (
	WAVES_SYSTEM.Logical_Or,
	WAVES_SYSTEM.Event_Value_Kind,
	WAVES_SYSTEM.Unused_Value, FALSE, 0.0);
    for I in X'RANGE loop
      Z(I + 1) := X(I);
    end loop;
    for I in Y'RANGE loop
      Z(X'LENGTH + I + 1) := Y(I);
    end loop;
    return Z;
  end;

  function "xor"(X, Y : EVENT_VALUE) return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to X'LENGTH + Y'LENGTH + 1);
  begin
    Z(1) := (
	WAVES_SYSTEM.Logical_Xor,
	WAVES_SYSTEM.Event_Value_Kind,
	WAVES_SYSTEM.Unused_Value, FALSE, 0.0);
    for I in X'RANGE loop
      Z(I + 1) := X(I);
    end loop;
    for I in Y'RANGE loop
      Z(X'LENGTH + I + 1) := Y(I);
    end loop;
    return Z;
  end;

  function "+"(X, Y : EVENT_VALUE) return EVENT_VALUE
  is
    variable Z : EVENT_VALUE(1 to X'LENGTH + Y'LENGTH);
  begin
    for I in X'RANGE loop
      Z(I) := X(I);
    end loop;
    for I in Y'RANGE loop
      Z(X'LENGTH + I) := Y(I);
    end loop;
    return Z;
  end;
  
  function UNSPECIFIED return DIRECTION_SUMMARY
  is
  begin
    return WAVES_SYSTEM.Dir_Unspecified;
  end;

  function UNKNOWN return DIRECTION_SUMMARY
  is
  begin
    return WAVES_SYSTEM.Dir_Unknown;
  end;

  function STIMULUS return DIRECTION_SUMMARY
  is
  begin
    return WAVES_SYSTEM.Dir_Stimulus;
  end;

  function RESPONSE return DIRECTION_SUMMARY
  is
  begin
    return WAVES_SYSTEM.Dir_Response;
  end;

  function COMPOUND return DIRECTION_SUMMARY
  is
  begin
    return WAVES_SYSTEM.Dir_Compound;
  end;

end WAVES_STANDARD;
