-- FILE NAME:        waves_frames.vhd
--
-- Version 2.1
--
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--      
--
--        ------------------------------------------------------------------
--
--        This is a modified IEEE WAVES package.  This package was modified
--        to handle the state/strength value system used in the
--        models being tested.
--
--        ------------------------------------------------------------------

library WAVES_STANDARD ;
  use WAVES_STANDARD.WAVES_INTERFACE.all ;
  use WAVES_STANDARD.WAVES_EVENTS.all ;

package WAVES_FRAMES is

  constant PIN_CODES : string := "UX01ZWLH-PN" ;

  function INPUT_FRAMES return FRAME_SET ;
  function INPUT_FRAMES(PERIOD : time) return FRAME_SET ;
  function OUTPUT_FRAMES return FRAME_SET ;
  function DONT_CARE_FRAMES return FRAME_SET ;
  function STROBED_OUTPUT_FRAMES(DELAY : Event_Time) return FRAME_SET ;

end WAVES_FRAMES ;



package body WAVES_FRAMES is

  constant T0 : Event_Time := ETIME(0 ns) ;
  constant T1 : Event_Time := ETIME(1 ns) ;
  constant T2 : Event_Time := ETIME(10 ns) ;
  constant T3 : Event_Time := ETIME(20 ns) ;

  ------------------------------------------------------------------------

  function INPUT_FRAMES return FRAME_SET is
    begin
	return
	    FRAME_EVENT ( (Uninitialized, T0)) +        -- 'U'
	    FRAME_EVENT ( (Unknown, T0)) +              -- 'X'
	    FRAME_EVENT ( (Zero, T0)) +                 -- '0'
	    FRAME_EVENT ( (One, T0)) +                  -- '1'
	    FRAME_EVENT ( (High_Z, T0)) +               -- 'Z'
	    FRAME_EVENT ( (Undriven_Unknown, T0)) +     -- 'W'
	    FRAME_EVENT ( (Low, T0)) +                  -- 'L'
	    FRAME_EVENT ( (High, T0)) +                 -- 'H'
            FRAME_EVENT ( (Dont_Care, T0)) +            -- 'D'
            FRAME_ELIST ( ((One, T0), (Zero, T1))) +    -- 'P' (1 ns pulse)
            FRAME_ELIST ( ((Zero, T0), (One, T1))) ;    -- 'N' (1 ns pulse)
  end ;

  ------------------------------------------------------------------------

  function INPUT_FRAMES (PERIOD : Time) return FRAME_SET is
    variable P0 : Event_Time ;
    variable P1 : Event_Time ;
    variable P2 : Event_Time ;

    begin
        P0 := ETIME(PERIOD * 0.0) ;
        P1 := ETIME(PERIOD * 0.3) ;
        P2 := ETIME(PERIOD * 0.6) ;

	return
	    FRAME_EVENT ( (Uninitialized, T0)) +        -- 'U'
	    FRAME_EVENT ( (Unknown, T0)) +              -- 'X'
	    FRAME_EVENT ( (Zero, T0)) +                 -- '0'
	    FRAME_EVENT ( (One, T0)) +                  -- '1'
	    FRAME_EVENT ( (High_Z, T0)) +               -- 'Z'
	    FRAME_EVENT ( (Undriven_Unknown, T0)) +     -- 'W'
	    FRAME_EVENT ( (Low, T0)) +                  -- 'L'
	    FRAME_EVENT ( (High, T0)) +                 -- 'H'
        FRAME_EVENT ( (Dont_Care, T0)) +            -- 'D'
        FRAME_ELIST ( ((Zero, P0), (One, P1), (Zero, P2))) +  -- 'P' (positive pulse)
        FRAME_ELIST ( ((One, P0), (Zero, P1), (One, P2))) ;   -- 'N' (negative pulse)
  end ;

  ------------------------------------------------------------------------

  function OUTPUT_FRAMES return FRAME_SET is
    begin
	return
	    FRAME_EVENT ( (Uninitialized, T0)) +        -- 'U'
	    FRAME_EVENT ( (Unknown, T0)) +              -- 'X'
	    FRAME_EVENT ( (Zero, T0)) +                 -- '0'
	    FRAME_EVENT ( (One, T0)) +                  -- '1'
	    FRAME_EVENT ( (High_Z, T0)) +               -- 'Z'
	    FRAME_EVENT ( (Undriven_Unknown, T0)) +     -- 'W'
	    FRAME_EVENT ( (Low, T0)) +                  -- 'L'
	    FRAME_EVENT ( (High, T0)) +                 -- 'H'
        FRAME_EVENT ( (Dont_Care, T0)) +            -- 'D'

        -- NOTE:  The definitions of output pulses ('P' and 'N') aren't
        --        really useful if the starting time and duration of the 
        --        pulse isn't known.  The expected values defined here
        --        are 10 ns pulses starting 10 ns into the period.

        FRAME_ELIST ( ((Zero, T0), (One, T2), (Zero, T3))) +  -- 'P'
        FRAME_ELIST ( ((One, T0), (Zero, T2), (One, T3))) ;   -- 'N'
  end ;

  ------------------------------------------------------------------------

  function DONT_CARE_FRAMES return FRAME_SET is
    begin
	return
	    FRAME_EVENT ( (Dont_Care, T0)) +        -- 'U'
	    FRAME_EVENT ( (Dont_Care, T0)) +        -- 'X'
	    FRAME_EVENT ( (Dont_Care, T0)) +        -- '0'
	    FRAME_EVENT ( (Dont_Care, T0)) +        -- '1'
	    FRAME_EVENT ( (Dont_Care, T0)) +        -- 'Z'
	    FRAME_EVENT ( (Dont_Care, T0)) +        -- 'W'
	    FRAME_EVENT ( (Dont_Care, T0)) +        -- 'L'
        FRAME_EVENT ( (Dont_Care, T0)) +        -- 'H'
        FRAME_EVENT ( (Dont_Care, T0)) +        -- 'D'
        FRAME_EVENT ( (Dont_Care, T0)) +        -- 'P'
        FRAME_EVENT ( (Dont_Care, T0)) ;        -- 'N'
  end ;

  ------------------------------------------------------------------------

  function STROBED_OUTPUT_FRAMES(DELAY : Event_Time) return FRAME_SET is
    begin
	return
	    FRAME_ELIST (((Dont_Care, T0),(Uninitialized, Delay))) +    -- 'U'
	    FRAME_ELIST (((Dont_Care, T0),(Unknown, Delay))) +          -- 'X'
	    FRAME_ELIST (((Dont_Care, T0),(Zero, Delay))) +             -- '0'
	    FRAME_ELIST (((Dont_Care, T0),(One, Delay))) +              -- '1'
	    FRAME_ELIST (((Dont_Care, T0),(High_Z, Delay))) +           -- 'Z'
	    FRAME_ELIST (((Dont_Care, T0),(Undriven_Unknown, Delay))) + -- 'W'
	    FRAME_ELIST (((Dont_Care, T0),(Low, Delay))) +              -- 'L'
	    FRAME_ELIST (((Dont_Care, T0),(High, Delay))) +             -- 'H'
	    FRAME_EVENT (((Dont_Care, T0))) +                           -- 'D'

        -- NOTE:  Again, the following two definitions are really useless.

        FRAME_ELIST ( ((Zero, T0), (One, T2), (Zero, Delay))) +     -- 'P'
        FRAME_ELIST ( ((One, T0), (Zero, T2), (One, Delay))) ;      -- 'N'
  end ;

end WAVES_FRAMES ;


