-- FILE NAME:        waves_events.vhd
--
--
-- Version 2.1
--
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--      
--
--        ------------------------------------------------------------------
--
--        This is a modified IEEE WAVES package.  This package was modified
--        to handle the state/strength value system used in the 
--        models being tested.
--
--        ------------------------------------------------------------------

library WAVES_STANDARD ;
  use WAVES_STANDARD.WAVES_STANDARD.all ;

package WAVES_EVENTS is

  -- The type Logic_Value is modeled after the proposed IEEE 9-state logic system

  type Logic_Value is (
    Uninitialized,      -- 'U'
    Unknown,            -- 'X'
    Zero,               -- '0'
    One,                -- '1'
    High_Z,             -- 'Z'
    Undriven_Unknown,   -- 'W'
    Low,                -- 'L'
    High,               -- 'H'
    Dont_Care);         -- '-'

  function VALUE_DICTIONARY ( VALUE : in Logic_Value) return Event_Value ;

end WAVES_EVENTS ;

-- ======================================================================

package body WAVES_EVENTS is
  
  function VALUE_DICTIONARY ( VALUE : in Logic_Value ) return Event_Value is
    begin
      case VALUE is

        when Uninitialized     => return relevance =  REQUIRED ;

        when Unknown           => return state = UNKNOWN 
                                  and strength = DRIVE 
                                  and relevance = REQUIRED ;

        when Zero              => return state = LOW 
                                  and strength = DRIVE  
                                  and relevance = REQUIRED;

        when One               => return state = HIGH 
                                  and strength = DRIVE  
                                  and relevance = REQUIRED;

        when High_Z            => return strength = DISCONNECTED  
                                  and relevance = REQUIRED;

        when Undriven_Unknown  => return state = UNKNOWN 
                                  and strength = RESISTIVE  
                                  and relevance = REQUIRED;

        when Low               => return state = LOW 
                                  and strength = RESISTIVE  
                                  and relevance = REQUIRED;

        when High              => return state = HIGH 
                                  and strength = RESISTIVE  
                                  and relevance = REQUIRED;

        when Dont_Care         => return relevance = OBSERVED ;

      end case ;

    end VALUE_DICTIONARY ;

end WAVES_EVENTS ;
