-- Filename:     TTL_TIMING.vhd
-- Description:  Contains voltage/temperature/capacitance derating
--               coefficients for STD, S, and LS families
--
-- Version 2.1
--
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--      
--
--      ------------------------------------------------------------------

package TTL_TIMING is

  type Tech_Type is (STD_FAMILY,S_FAMILY,LS_FAMILY);

  type Four_Coeffs is array (4 downto 1) of Real;
  type Coeff_Type is array (Tech_Type) of Four_Coeffs;

  -- Environmental Derating Coefficients
  -- note:  all references are to 1988 TTL Data Book (Texas Instruments)

----------------------------------------------------------------------
  constant TLH_COEFFICIENT : Coeff_Type :=
  (
    -- derived from  Figure A5, page 1-51 
    (1.191617e-07, -8.411414e-06, 2.592953e-03, 9.385714e-01), -- STD

    -- derived from Figure E7, p 1-54 
    (0.000000,      1.314286e-05, 3.285715e-04, 9.835714e-01), -- S

    -- derived from Figure D7, p 1-52 
    (4.739047E-08,  3.851426E-06,-1.259047E-04, 1.000000E+00)  --LS
  );

----------------------------------------------------------------------
  constant THL_COEFFICIENT : Coeff_Type :=
  (
    -- derived from Figure A6, page 1-51
    (-6.346664e-08,  2.408000e-05,  -3.092334e-03,  1.063250e+00), -- STD
    -- derived from Figure E9, p 1-54 
    (-1.363809e-07,  3.508572e-05,  -3.400477e-03,  1.065214e+00), -- S
    -- derived from Figure D7, p 1-52 
    (-9.020953E-08,  2.029714E-05, -1.496762E-03,   1.026143E+00)  --LS
  );

----------------------------------------------------------------------
  constant VLH_COEFFICIENT : Coeff_Type :=
  -- note:  no data available for STD, LS families, so S coefficients are used
  (
     -- derived from Figure E8, p 1-54 
    (0.000000,  -1.999974e-03, -4.700023e-02, 1.285001e+00),  -- STD
     -- derived from Figure E8, p 1-54 
    (0.000000,  -1.999974E-03, -4.700023E-02, 1.285001E+00),  -- S
     -- derived from Figure E8, p 1-54 
    (0.000000,  -1.999974E-03, -4.700023E-02, 1.285001E+00)   -- LS
  );

----------------------------------------------------------------------
  constant VHL_COEFFICIENT : Coeff_Type :=
  (
    (0.000000, -1.999974e-03, -4.700023e-02, 1.285001e+00),  -- STD
     -- derived from Figure E10, p 1-54 
    (0.000000, -1.999974E-03, -4.700023E-02, 1.285001E+00),  -- S
    (0.000000, -1.999974E-03, -4.700023E-02, 1.285001E+00)   -- LS
  );

----------------------------------------------------------------------
  constant CLH_COEFFICIENT : Coeff_Type :=
  -- note:  all capacitance curves are normalized around the 15 pf standard load
  (
     -- derived from Figure A5, p 1-51 
    (0.000000, -2.592593e-05, 1.168519e-02, 8.305556e-01), -- STD

    -- derived from Figure E8, p 1-54 
    (0.000000, -3.915343e-05,  1.683069e-02,  7.563492e-01), -- S

    -- derived from Figure D8, p 1-52 
    (0.000000, 0.000000, 7.843530e-03, 8.823470e-01)  -- LS
  );

----------------------------------------------------------------------
  constant CHL_COEFFICIENT : Coeff_Type :=
  (
    -- derived from Figure A6, p 1-51 
    (0.000000, -5.375662e-05, 1.875133e-02, 7.308254e-01), -- STD

    -- derived from Figure E10, p 1-54 
    (0.000000, -4.960318e-05,  1.929564e-02,  7.217262e-01),  -- S

    -- derived from Figure D8, P 1-52 
    (0.000000, 0.000000, 1.058824e-02, 8.411765e-01)  -- LS
  );


end TTL_TIMING;
