-- Filename : wgenerator_SN54xx38.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
  use STD.TEXTIO.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_SYSTEM.all;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library SN54xx38;
  use SN54xx38.WAVES_DEVICE.all;
  use SN54xx38.WAVES_OBJECTS.all;
  use SN54xx38.WAVES_FRAMES.all;
  use SN54xx38.WAVES_UTILITIES.all;

package WGENERATOR_SN54xx38 is
  procedure SN54xx38_TEST
  (
    signal CONNECT   : Inout Waves_Port_List
  );

  procedure SN54xx38_TEST
  (
    signal CONNECT            : Inout Waves_Port_List;
    constant INPUT_FILE_NAME  : String;
    constant START_TOLERANCE  : Time;
    constant END_TOLERANCE    : Time 
  );

end WGENERATOR_SN54xx38;


-- ======================================================================

package body WGENERATOR_SN54xx38 is

  constant I_PINS : Pinset := NEW_PINSET
  ( 
    (TP_A1, TP_B1, TP_A2, TP_B2, TP_A3, TP_B3, TP_A4, TP_B4)
  );

  constant O_PINS : Pinset := ALL_PINS and not I_PINS;
  constant EMPTY_EVENT : Integer := -1;

  ---------------------------------------------------------------------------
  --  The following procedure is used to provide test vectors for the model.
  --  The test vectors (inputs and expected outputs) are contained within
  --  the procedure, and are analyzed with the VHDL code.  The test vectors
  --  are applied as follows:
  --
  --   Beginning of period:  Inputs set to appropriate values
  --                         Expected outputs set to "don't care"
  --
  --   After 95 ns (95% of period):  Expected outputs set to appropriate values
  --
  --   After 100 ns (end of period): Get next set of inputs and outputs
  ---------------------------------------------------------------------------
  procedure SN54xx38_TEST
  (
    signal CONNECT   : Inout Waves_Port_List) is

    constant PERIOD          : Time       := 100 ns;
    constant UNCERTAINTY_PCT : Real       := 0.95;
    constant TDELAY          : Event_Time := ETIME (UNCERTAINTY_PCT *PERIOD);

    constant FSA : Frame_Set_Array := 
          NEW_FRAME_SET_ARRAY ( INPUT_FRAMES, I_PINS) +
          NEW_FRAME_SET_ARRAY ( STROBED_OUTPUT_FRAMES(TDELAY), O_PINS);

    constant DT_BASIS : Delay_Time_Basis := (FALSE,0 ns,0 ns,TIMED_DELAY,0,0,0);

    variable TD1 : Time_Data   := NEW_TIME_DATA ( FSA );
    variable T1  : Wave_Timing := ((PERIOD, DT_BASIS), TD1);

    --        Order of signals:
    --
    --        (Y1, Y2, Y3, Y4,
    --         A1, B1, A2, B2, A3, B3, A4, B4)
    --


    variable ALL_STATES_PART1 : Wtime_Slice_List (1 to 11) := (
      (  "UUUU"
     & "UUUUUUUU", T1),

      (  "0000"
     & "11111111", T1), -- reset to normal

      (  "UUUU"
     & "1UUUUUUU", T1), -- 9 states => A1 & B1 inputs

      (  "XUUU"
     & "1XUUUUUU", T1),

      (  "ZUUU"
     & "10UUUUUU", T1),

      (  "0UUU"
     & "11UUUUUU", T1),

      (  "XUUU"
     & "1ZUUUUUU", T1),

      (  "XUUU"
     & "1WUUUUUU", T1),

      (  "ZUUU"
     & "1LUUUUUU", T1),

      (  "0UUU"
     & "1HUUUUUU", T1),

      (  "XUUU"
     & "1-UUUUUU", T1)
      );



    variable ALL_STATES_PART2 : Wtime_Slice_List (1 to 9) := (
      (  "UUUU"
     & "UU1UUUUU", T1), -- 9 states => A2 & B2 inputs

      (  "UXUU"
     & "UU1XUUUU", T1),

      (  "UZUU"
     & "UU10UUUU", T1),

      (  "U0UU"
     & "UU11UUUU", T1),

      (  "UXUU"
     & "UU1ZUUUU", T1),

      (  "UXUU"
     & "UU1WUUUU", T1),

      (  "UZUU"
     & "UU1LUUUU", T1),

      (  "U0UU"
     & "UU1HUUUU", T1),

      (  "UXUU"
     & "UU1-UUUU", T1)
      );



    variable ALL_STATES_PART3 : Wtime_Slice_List (1 to 9) := (
      (  "UUUU"
     & "UUUU1UUU", T1), -- 9 states => A3 & B3 inputs

      (  "UUXU"
     & "UUUU1XUU", T1),

      (  "UUZU"
     & "UUUU10UU", T1),

      (  "UU0U"
     & "UUUU11UU", T1),

      (  "UUXU"
     & "UUUU1ZUU", T1),

      (  "UUXU"
     & "UUUU1WUU", T1),

      (  "UUZU"
     & "UUUU1LUU", T1),

      (  "UU0U"
     & "UUUU1HUU", T1),

      (  "UUXU"
     & "UUUU1-UU", T1)
      );



    variable ALL_STATES_PART4 : Wtime_Slice_List (1 to 9) := (
      (  "UUUU"
     & "UUUUUU1U", T1), -- 9 states => A4 & B4 inputs

      (  "UUUX"
     & "UUUUUU1X", T1),

      (  "UUUZ"
     & "UUUUUU10", T1),

      (  "UUU0"
     & "UUUUUU11", T1),

      (  "UUUX"
     & "UUUUUU1Z", T1),

      (  "UUUX"
     & "UUUUUU1W", T1),

      (  "UUUZ"
     & "UUUUUU1L", T1),

      (  "UUU0"
     & "UUUUUU1H", T1),

      (  "UUUX"
     & "UUUUUU1-", T1)
      );



    variable TIMING_PARAMS : Wtime_Slice_List (1 to 3) := (
      (  "0000"
     & "11111111", T1), -- reset to normal => Timing parameters

      (  "ZZZZ"
     & "00000000", T1), -- tplz

      (  "0000"
     & "11111111", T1) -- tpzl
      );



    variable TRUTH_TABLE : Wtime_Slice_List (1 to 4) := (
      (  "0000"
     & "11111111", T1),  -- reset to normal => Truth table

      (  "0000"
     & "11111111", T1),

      (  "ZZZZ"
     & "0X0X0X0X", T1),

      (  "ZZZZ"
     & "X0X0X0X0", T1)
      );



  begin
    assert FALSE
      report "ALL_STATES_PART1 vectors"
        severity note;
      for I in ALL_STATES_PART1' range loop
        APPLY(CONNECT,ALL_STATES_PART1(I).CODES,ALL_STATES_PART1(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_PART2 vectors"
        severity note;
      for I in ALL_STATES_PART2' range loop
        APPLY(CONNECT,ALL_STATES_PART2(I).CODES,ALL_STATES_PART2(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_PART3 vectors"
        severity note;
      for I in ALL_STATES_PART3' range loop
        APPLY(CONNECT,ALL_STATES_PART3(I).CODES,ALL_STATES_PART3(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "ALL_STATES_PART4 vectors"
        severity note;
      for I in ALL_STATES_PART4' range loop
        APPLY(CONNECT,ALL_STATES_PART4(I).CODES,ALL_STATES_PART4(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "TIMING_PARAMS vectors"
        severity note;
      for I in TIMING_PARAMS' range loop
        APPLY(CONNECT,TIMING_PARAMS(I).CODES,TIMING_PARAMS(I).WTIME,ALL_PINS);
      end loop;

    assert FALSE
      report "TRUTH_TABLE vectors"
        severity note;
      for I in TRUTH_TABLE' range loop
        APPLY(CONNECT,TRUTH_TABLE(I).CODES,TRUTH_TABLE(I).WTIME,ALL_PINS);
      end loop;

    end;

  ---------------------------------------------------------------------------
  --  The following procedure is used to provide test vectors for the model.
  --  The test vectors (inputs and expected outputs, along with the period
  --  of each slice) are read in from an external file.  The test vectors 
  --  are applied as follows:
  --
  --   Beginning of period:  Inputs set to appropriate values
  --                         Expected outputs set to "don't care"
  --
  --   After <START_TOLERANCE>:  Expected outputs set to appropriate values
  --
  --   After <FS_TIME - END_TOLERANCE>: Get next set of inputs and outputs
  --
  --   After <FS_TIME> (end of period): Get next set of inputs and outputs
  ---------------------------------------------------------------------------
  procedure SN54xx38_Test
  (
    signal CONNECT            : Inout Waves_Port_List;
    constant INPUT_FILE_NAME  : String;
    constant START_TOLERANCE  : Time;
    constant END_TOLERANCE    : Time ) is


    variable TOLERANCE : Time := START_TOLERANCE + END_TOLERANCE;

    constant FSA : Frame_Set_Array :=
      NEW_FRAME_SET_ARRAY (INPUT_FRAMES, I_PINS) +
      NEW_FRAME_SET_ARRAY (OUTPUT_FRAMES, O_PINS);

    constant DT_BASIS : Delay_Time_Basis := (FALSE,0 ns,0 ns,TIMED_DELAY,0,0,0);

    variable TD : Time_Data := NEW_TIME_DATA (FSA);

    constant FSA_DONT_CARE : Frame_Set_Array :=
      NEW_FRAME_SET_ARRAY (INPUT_FRAMES, I_PINS) +
      NEW_FRAME_SET_ARRAY (DONT_CARE_FRAMES, O_PINS);

    variable TD_DONT_CARE : Time_Data := NEW_TIME_DATA (FSA_DONT_CARE);

    file INPUT_FILE : Text is in INPUT_FILE_NAME;

    -- the file slice must be allocated
    variable SN54xx38_FILE_SLICE : File_Slice := NEW_FILE_SLICE;

    begin
      loop
        READ_FILE_SLICE(INPUT_FILE, SN54xx38_FILE_SLICE);
        exit when SN54xx38_FILE_SLICE.END_OF_FILE;
        if SN54xx38_FILE_SLICE.FS_TIME > TOLERANCE then
          APPLY(CONNECT, SN54xx38_FILE_SLICE.CODES.all, 
            DELAY(START_TOLERANCE), TD_DONT_CARE);
          APPLY(CONNECT, SN54xx38_FILE_SLICE.CODES.all, 
            DELAY(SN54xx38_FILE_SLICE.FS_TIME - TOLERANCE), TD);
          APPLY(CONNECT, SN54xx38_FILE_SLICE.CODES.all, 
            DELAY(END_TOLERANCE), TD_DONT_CARE);
        else
          APPLY(CONNECT, SN54xx38_FILE_SLICE.CODES.all, 
            DELAY(SN54xx38_FILE_SLICE.FS_TIME), TD);
        end if;
      end loop;
    end;
end WGENERATOR_SN54xx38;









