-- Filename : waves_device_SN54xx368A.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_Y1, TP_Y2, TP_Y3, TP_Y4, TP_Y5, TP_Y6,
                      TP_G1, TP_A1, TP_A2, TP_A3, TP_A4, TP_A5, 
                      TP_A6, TP_G2);


  constant DEVICE_ID : string := "SN54xx368A";

  -- The following declaration is just for documentation purposes.
     constant PIN_DIRECTION : Direction_List := (Response,   -- TP_Y1
                                                 Response,   -- TP_Y2
                                                 Response,   -- TP_Y3
                                                 Response,   -- TP_Y4
                                                 Response,   -- TP_Y5
                                                 Response,   -- TP_Y6
                                                 Stimulus,   -- TP_G1
                                                 Stimulus,   -- TP_A1
                                                 Stimulus,   -- TP_A2
                                                 Stimulus,   -- TP_A3
                                                 Stimulus,   -- TP_A4
                                                 Stimulus,   -- TP_A5
                                                 Stimulus,   -- TP_A6
                                                 Stimulus);  -- TP_G2)
        
  function PIN_NAME (PIN : Test_Pins) return string;

end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return string is
  begin
    case PIN is
      when TP_y1    => return "Y1";
      when TP_y2    => return "Y2";
      when TP_y3    => return "Y3";
      when TP_y4    => return "Y4";
      when TP_y5    => return "Y5";
      when TP_y6    => return "Y6";
      when TP_g1    => return "G1";
      when TP_a1    => return "A1";
      when TP_a2    => return "A2";
      when TP_a3    => return "A3";
      when TP_a4    => return "A4";
      when TP_a5    => return "A5";
      when TP_a6    => return "A6";
      when TP_g2    => return "G2";
    end case;
  end;

end WAVES_DEVICE;
