-- Filename : SN54xx368A_TB_CON.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library STD_PACK;
  use STD_PACK.SIMFLAG.all;    -- Global simulation options
  use STD_PACK.TTL_TIMING.all; -- TTL derating coefficients

library SN54xx368A;
  use SN54xx368A.SN54xx368A_TIMING.all;  -- timing module

configuration SN54xx368A_TB_CON of SN54xx368A_TB is

for TEST_BENCH
  for UNDER_TEST : DUT use entity SN54xx368A.SN54xx368A_DIP16(STRUCTURAL)
    generic map (
      DIP_TIME_MODE => TYPICAL,      -- MIN, TYP, or MAX
      DIP_FAMILY    => STD_FAMILY,   -- STD or LS
      DIP_VCC       => 5.0,          -- Volts
      DIP_TA        => 25.0,         -- degrees Celsius
      DIP_DFACTOR   => 100.0,        -- percent
      DIP_REF       =>  "SN54xx368A",

     
      TWD_A1 =>  0 ns,  -- back-annotated input wire delays
      TWD_A2 =>  0 ns,
      TWD_A3 =>  0 ns,
      TWD_A4 =>  0 ns,
      TWD_A5 =>  0 ns,
      TWD_A6 =>  0 ns,
      TWD_G1 =>  0 ns,
      TWD_G2 =>  0 ns,

      CL_Y1 =>  50.0,  -- back-annotated output loading (picofarads)
      CL_Y2 =>  50.0,  -- (timing module will adjust times accordingly)
      CL_Y3 =>  50.0, 
      CL_Y4 =>  50.0, 
      CL_Y5 =>  50.0, 
      CL_Y6 =>  50.0  
    );

  end for;
end for;        

end SN54xx368A_TB_CON;
