-- Filename : SN54xx368A_TB.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;

library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_INTERFACE.all;

library SN54xx368A;
  use SN54xx368A.WAVES_DEVICE.all;
  use SN54xx368A.WAVES_OBJECTS.all;
  use SN54xx368A.WAVES_UTILITIES.all;
  use SN54xx368A.WGENERATOR_SN54xx368A.all;

entity SN54xx368A_TB is
  begin
end SN54xx368A_TB;

-- ======================================================================

architecture TEST_BENCH of SN54xx368A_TB is

  component DUT 
    port (Y1, Y2, Y3, Y4, Y5, Y6         : out Std_Ulogic;
          G1, A1, A2, A3, A4, A5, A6, G2 : in  Std_Ulogic );
  end component;

  subtype Test_Pin_Range is integer range
          Test_Pins'pos(TP_y1) + 1 to Test_Pins'pos(TP_G2) + 1;

  -- Input and Output traffic of DUT
          signal TRAFFIC : Std_Ulogic_Vector(Test_Pin_Range);

  -- Test program options
  constant IN_FILE_NAME    : String := "SN54xx368A_waves.dat"; 
  constant START_TOLERANCE : Time   := 2 ns;
  constant END_TOLERANCE   : Time   := 2 ns;

  -- Comparator options
  signal COMPARE           : Boolean           := true;
  constant HOW_TO_REPORT   : Comparison_Format := DO_ASSERTION;
  constant ASSERTION_LEVEL : Severity_Level    := WARNING;

  -- Signal monitor options
  constant HOW_TO_PRINT  : Output_Format := STANDARD;
  constant OUT_FILE_NAME : String        := "SN54xx368A_out.dat";

  --    signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range) := (others.M_VALUE => TRUE);
  signal SMATCH : WAVES_MATCH_LIST(Test_Pin_Range);

  -- Connection to WAVES dataset
  signal CONNECT : Waves_Port_List (Test_Pin_Range);

  subtype Compare_Pin_Range is integer range
          Test_Pins'pos(TP_y1) + 1 to Test_Pins'pos(TP_y6) + 1;

------------------------------------------------------------------------------

  begin

    -- Call the waveform generator (i.e., the WAVES dataset)
    process begin
      --      SN54xx368A_TEST(CONNECT, IN_FILE_NAME, START_TOLERANCE, END_TOLERANCE);
      SN54xx368A_TEST(CONNECT);
      wait ;
    end process ;

------------------------------------------------------------------------------

  -- Instantiate the Device under test

  UNDER_TEST : DUT
    port map (
      TRAFFIC(Test_Pins'pos(TP_y1) + 1),
      TRAFFIC(Test_Pins'pos(TP_y2) + 1),
      TRAFFIC(Test_Pins'pos(TP_y3) + 1),
      TRAFFIC(Test_Pins'pos(TP_y4) + 1),
      TRAFFIC(Test_Pins'pos(TP_y5) + 1),
      TRAFFIC(Test_Pins'pos(TP_y6) + 1),
      TRAFFIC(Test_Pins'pos(TP_g1) + 1),
      TRAFFIC(Test_Pins'pos(TP_a1) + 1),
      TRAFFIC(Test_Pins'pos(TP_a2) + 1),
      TRAFFIC(Test_Pins'pos(TP_a3) + 1),
      TRAFFIC(Test_Pins'pos(TP_a4) + 1),
      TRAFFIC(Test_Pins'pos(TP_a5) + 1),
      TRAFFIC(Test_Pins'pos(TP_a6) + 1),
      TRAFFIC(Test_Pins'pos(TP_g2) + 1)
    );

----------------------------------------------------------------------------

  -- Collect all signals (inputs and output of DUT) into signal TRAFFIC

  COLLECT_INPUTS:
    for I in Test_Pins'pos(TP_g1) + 1 to Test_Pins'pos(TP_G2) + 1 generate
      TRAFFIC(I) <= LOGIC_VALUE_TO_STD_ULOGIC
                    (WAVES_PORT_TO_LOGIC_VALUE(CONNECT(I)));
  end generate COLLECT_INPUTS;

------------------------------------------------------------------------------

  SIGNAL_TRAFFIC : SIGNAL_MONITOR(OUT_FILE_NAME, TRAFFIC, HOW_TO_PRINT) ;

------------------------------------------------------------------------------

  GEN_COMPARATOR:
    for I in Compare_Pin_Range generate
      COMPARATOR : CHECK_RESPONSE(
        WHICH_ONE => I,
        RESPONSE => TRAFFIC(I),
        PREDICTION => CONNECT(I),
        COMPARE => COMPARE,
        HOW_TO_REPORT => HOW_TO_REPORT,
        ASSERTION_LEVEL => ASSERTION_LEVEL,
        MATCH => SMATCH(I).M_VALUE );
  end generate GEN_COMPARATOR;

end TEST_BENCH;
