-- Filename : SN54xx368A.vhd
--
-- Version 2.1
--
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--      
--
--
--        ------------------------------------------------------------------

library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;       -- Defines logic types, operators, functions

library STD_PACK; 
  use STD_PACK.MISC_FUNC.all;          -- Miscellaneous functions
  use STD_PACK.TIME_FUNC.all;          -- Timing functions
  use STD_PACK.TTL_TIMING.all;       -- TTL derating coefficients

library SN54xx368A;
  use SN54xx368A.SN54xx368A_TIMING.all ;         -- SN54xx368A timing module

entity SN54xx368A is
  generic
  (
    GEN_PROP_TIMES : Prop_Times;
    GEN_FAMILY     : Tech_Type ;

    TWD_A : Time;
    TWD_G : Time;

    CL_Y : Real ;

    REF : String
  );

  port
  (
    Y     : out Std_Ulogic;
    A     : in  Std_Ulogic;
    G     : in  Std_Ulogic
  );

end SN54xx368A;

-- ======================================================================

architecture BEHAVIORAL of SN54xx368A is

  constant MODEL_TIMES : Prop_Times := BACK_ANNOTATE(GEN_PROP_TIMES,GEN_FAMILY,CL_Y) ;
  -- Local signal declarations

  signal AIN,GIN  : UX01  := 'U' ;
  signal YOUT     : UX01Z := 'U';

  begin

    -- assign pin values to internal signals after wire delay

    AIN <= transport CONVERT_TO_UX01(A) after TWD_A;
    GIN <= transport CONVERT_TO_UX01(G) after TWD_G;

    -- Assign internal values to output pins

    Y <= YOUT;

    -- Check for invalid inputs on control input ports

    assert not (G'event and
      ((G = 'U') or (G = 'X') or (G = 'Z') or (G = 'W') or (G = '-')))
    report "{" & REF & "} " & STD_ULOGIC_TO_CHAR(G) & 
      " state on G input" severity warning;

------------------------------------------------------------------------

A_BUF : process (GIN,AIN)

variable OUTPUT_VALUE : Std_Ulogic;

begin

  if (GIN = '0') then
    OUTPUT_VALUE := not AIN;
    YOUT <= transport OUTPUT_VALUE after TP_DELAY(YOUT,OUTPUT_VALUE,
        MODEL_TIMES.TPLH, MODEL_TIMES.TPHL, MODEL_TIMES.TPLZ,
        MODEL_TIMES.TPHZ, MODEL_TIMES.TPZH, MODEL_TIMES.TPZL );
  elsif (GIN = '1') then
    if (YOUT = '0') then
      YOUT <= transport 'Z' after MODEL_TIMES.TPLZ;
    elsif (YOUT = '1') then
      YOUT <= transport 'Z' after MODEL_TIMES.TPHZ;
    elsif (YOUT = 'U' or YOUT = 'X') then
      YOUT <= transport 'Z' after MAXTIME(MODEL_TIMES.TPHZ,
         MODEL_TIMES.TPLZ);
    elsif (YOUT = 'Z') then
      null;  -- output is already 'Z'
    else
      YOUT <= 'X';
    end if;

    elsif (GIN = 'U') then
      YOUT <= 'U';
    elsif (AIN = 'U') then
      YOUT <= 'U';
    else
      YOUT <= 'X';
    end if;


end process A_BUF;

----------------------------------------------------------------------

end BEHAVIORAL ;
