-- Filename : waves_device_SN54xx30.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

  type Test_Pins is ( TP_Y, TP_A, TP_B, TP_C, TP_D, 
                      TP_E, TP_F, TP_G, TP_H);

  constant DEVICE_ID : string := "SN54xx30";

  -- The following declaration is just for documentation purposes.

  constant PIN_DIRECTION : Direction_List := (Response,   -- TP_Y
                                              Stimulus,   -- TP_A
                                              Stimulus,   -- TP_B
                                              Stimulus,   -- TP_C
                                              Stimulus,   -- TP_D
                                              Stimulus,   -- TP_E
                                              Stimulus,   -- TP_F
                                              Stimulus,   -- TP_G
                                              Stimulus);   -- TP_H)
        
  function PIN_NAME (PIN : Test_Pins) return String;
    
end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

  function PIN_NAME (PIN : Test_Pins) return String is
  begin
    case PIN is
      when TP_Y    => return "Y";
      when TP_A    => return "A";
      when TP_B    => return "B";
      when TP_C    => return "C";
      when TP_D    => return "D";
      when TP_E    => return "E";
      when TP_F    => return "F";
      when TP_G    => return "G";
      when TP_H    => return "H";
    end case;
  end;
end WAVES_DEVICE;




