-- Filename : SN54xx30_TB_CON.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library STD_PACK;
  use STD_PACK.SIMFLAG.all;    -- Global simulation options
  use STD_PACK.TTL_TIMING.all; -- TTL derating coefficients

library SN54xx30;
  use SN54xx30.SN54xx30_TIMING.all;  -- timing module

configuration SN54xx30_TB_CON of SN54xx30_TB is

for TEST_BENCH
  for UNDER_TEST : DUT use entity SN54xx30.SN54xx30_DIP14(STRUCTURAL)
    generic map (
      DIP_TIME_MODE => TYPICAL,      -- MIN, TYP, or MAX
      DIP_FAMILY    => STD_FAMILY,   -- STD, S, or LS
      DIP_VCC       => 5.0,          -- Volts
      DIP_TA        => 25.0,         -- degrees Celsius
      DIP_DFACTOR   => 100.0,        -- percent
      DIP_REF       => "SN54xx30",   -- component reference designator

      TWD_A => 0 ns,  -- back-annotated input wire delays
      TWD_B => 0 ns,
      TWD_C => 0 ns,
      TWD_D => 0 ns,
      TWD_E => 0 ns,
      TWD_F => 0 ns,
      TWD_G => 0 ns,
      TWD_H => 0 ns,

      CL_Y => 15.0   -- back-annotated output loading (picofarads)
                      -- (timing module will adjust time accordingly)
    );

  end for;
end for;        

end SN54xx30_TB_CON;
