-- Filename : waves_device_SN54xx280.vhd
--
-- Version 2.1
----------------------------------------------------------------------
--
library WAVES_STANDARD;
  use WAVES_STANDARD.WAVES_STANDARD.all;

package WAVES_DEVICE is

    type Test_Pins is ( TP_EVEN, TP_ODD,
                        TP_A, TP_B, TP_C, TP_D, TP_E, TP_F, TP_G, TP_H, TP_I);


    constant DEVICE_ID : String := "SN54xx280";

  -- The following declaration is just for documentation purposes.

    constant PIN_DIRECTION : Direction_List := (Response,   -- TP_EVEN
                                                Response,   -- TP_ODD
                                                Response,   -- TP_A
                                                Response,   -- TP_B
                                                Response,   -- TP_C
                                                Response,   -- TP_D
                                                Stimulus,   -- TP_E
                                                Stimulus,   -- TP_F
                                                Stimulus,   -- TP_G
                                                Stimulus,   -- TP_H
                                                Stimulus);   -- TP_I)
        
    function PIN_NAME (PIN : Test_Pins) return String;
    
end WAVES_DEVICE;

-- ======================================================================

package body WAVES_DEVICE is

    function PIN_NAME (PIN : Test_Pins) return String is
    begin
        case PIN is
            when TP_EVEN => return "EVEN";
            when TP_ODD => return "ODD";
            when TP_A => return "A";
            when TP_B => return "B";
            when TP_C => return "C";
            when TP_D => return "D";
            when TP_E => return "E";
            when TP_F => return "F";
            when TP_G => return "G";
            when TP_H => return "H";
            when TP_I => return "I";
        end case;
    end;

end WAVES_DEVICE;

