-- Filename : SN54xx280_DIP14.vhd
--
-- Version 2.1
--
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--      
-- Part Name:          SN54xx280
-- Manufacturer:       Texas Instruments
-- Other Sources:      None
-- Reference:          Data Sheet - The 1988 TTL Data Book (p. 2-778)
-- Packaging:          J Suffix (ceramic 14 pin DIP), or
--                     W Suffix (ceramic flat package)
--
-- Description:       The bipolar SSI SN54xx280 is a 9-bit even/odd parity generator/checker.
--                    This generator offers the designer a trade-off between reduced
--                    power consumption and high performance.  This device is fully
--                    compatible with most other TTL circuits.  All inputs are buffered
--                    to lower the drive requirements to one standard load.
--                    The '54 series meets military specifications.
--
-- Developer:         Institute for Technology Development
--                    VHDL Modeling Group
--                    1 Research Boulevard, Suite 205
--                    Starkville, MS 39759
--
-- Contact:           Dan Johnson
--                    CAD Section Manager
--                    (601) 325-2240
--                    danj@itd.msstate.edu
--
-- Version            2.1
-- Date:              07-12-91
--
-- Date of Formal
-- Verification:      TBD
--
--
--        ------------------------------------------------------------------
--
--
-- Recommended operating conditions:
--
--
--   S_FAMILY
--    _____________________________________________
--   |      |  minimum  nominal  maximum  |  unit  |
--   |______|_____________________________|________|
--   | VCC  |  4.5      5.0      5.5      | V      |
--   | IOH  |                   -1.0      | mA     |
--   | IOL  |                     20      | mA     |
--   | TA   | -55        25      125      | deg. C |
--   | VIH  |  2.0                        | V      |
--   | VIL  |                    0.8      | V      |
--   |______|_____________________________|________|
--
--
--   LS_FAMILY
--    _____________________________________________
--   |      |  minimum  nominal  maximum  |  unit  |
--   |______|_____________________________|________|
--   | VCC  |  4.5      5.0      5.5      | V      |
--   | VIH  |  2.0                        | V      |
--   | VIL  |                    0.7      | V      |
--   | IOH  |                   -0.4      | mA     |
--   | IOL  |                      4      | mA     |
--   | TA   | -55        25      125      | deg. C |
--   |______|_____________________________|________|
--
--
-- Worst case operating conditions:
--    _________________________________
--   |        | voltage   temperature  |
--   | _______|________________________|
--   | tphl   | 5.5 V     -55 deg. C   |
--   | tplh   | 4.5 V     125 deg. C   |
--   |________|________________________|
--
-- Note: High capacitive loading also degrades propagation delays of the part.


library IEEE;                       -- Logic system
  use IEEE.STD_LOGIC_1164.all ;   -- Defines logic types, operators, functions

library STD_PACK ;                  -- Standard library for all models
  use STD_PACK.SIMFLAG.all;         -- Global simulation options
  use STD_PACK.TTL_TIMING.all;      -- TTL derating coefficients

library SN54xx280;
  use SN54xx280.SN54xx280_timing.all; -- timing module

------------------------------------------------------------
entity SN54xx280_DIP14 is 

  generic
  -- defaults are from SIMFLAG package
  (
    DIP_TIME_MODE : Time_Modes := TYPICAL;
    DIP_FAMILY    : Tech_Type  := STD_FAMILY;
    DIP_VCC       : Real       := VCC;
    DIP_TA        : Real       := TA;
    DIP_DFACTOR   : Real       := DERATE_FACTOR;
    DIP_REF       : String     := "SN54xx00";

    TWD_A : Time := 0 ns;
    TWD_B : Time := 0 ns;
    TWD_C : Time := 0 ns;
    TWD_D : Time := 0 ns;
    TWD_E : Time := 0 ns;
    TWD_F : Time := 0 ns;
    TWD_G : Time := 0 ns;
    TWD_H : Time := 0 ns;
    TWD_I : Time := 0 ns;

    CL_EVEN : Real := 15.0;  -- pf
    CL_ODD  : Real := 15.0
  );

  port
  ( 
     EVEN      : out std_ulogic ;
     ODD       : out Std_Ulogic ;

     A         : in Std_Ulogic ;
     B         : in Std_Ulogic ;
     C         : in Std_Ulogic ;
     D         : in Std_Ulogic ;
     E         : in Std_Ulogic ;
     F         : in Std_Ulogic ;
     G         : in Std_Ulogic ;
     H         : in Std_Ulogic ;
     I         : in Std_Ulogic ;


     VCC       : in Real := 5.0;  -- volts
     GND       : in Real := 0.0   -- volts

    ) ;

     -- PIN MAPPING

     attribute PIN_NO          : positive ;
     attribute PIN_NO of G     : signal is 1 ;
     attribute PIN_NO of H     : signal is 2 ;
     attribute PIN_NO of I     : signal is 4 ;
     attribute PIN_NO of EVEN  : signal is 5 ;
     attribute PIN_NO of ODD   : signal is 6 ;
     attribute PIN_NO of GND   : signal is 7 ;
     attribute PIN_NO of A     : signal is 8 ;
     attribute PIN_NO of B     : signal is 9 ;
     attribute PIN_NO of C     : signal is 10 ;
     attribute PIN_NO of D     : signal is 11 ;
     attribute PIN_NO of E     : signal is 12 ;
     attribute PIN_NO of F     : signal is 13 ;
     attribute PIN_NO of VCC   : signal is 14 ;

end SN54xx280_DIP14;

------------------------------------------------------------
architecture STRUCTURAL of SN54xx280_DIP14 is

  component PAR_GEN

  generic 
  (
     GEN_PROP_TIMES  : Prop_Times := GET_TIMING(DIP_FAMILY,
                                                DIP_TIME_MODE,
                                                DIP_VCC,
                                                DIP_TA,
                                                DIP_DFACTOR);
     GEN_FAMILY : Tech_Type := DIP_FAMILY;
  
     TWD_A : Time := 0 ns;
     TWD_B : Time := 0 ns;
     TWD_C : Time := 0 ns;
     TWD_D : Time := 0 ns;
     TWD_E : Time := 0 ns;
     TWD_F : Time := 0 ns;
     TWD_G : Time := 0 ns;
     TWD_H : Time := 0 ns;
     TWD_I : Time := 0 ns;

     CL_EVEN : Real := 15.0;  -- pf
     CL_ODD  : Real := 15.0;

     REF : String := DIP_REF
  );

  port (
     EVEN      : out Std_Ulogic ;
     ODD       : out Std_Ulogic ;

     A         : in Std_Ulogic ;
     B         : in Std_Ulogic ;
     C         : in Std_Ulogic ;
     D         : in Std_Ulogic ;
     E         : in Std_Ulogic ;
     F         : in Std_Ulogic ;
     G         : in Std_Ulogic ;
     H         : in Std_Ulogic ;
     I         : in Std_Ulogic 
  );

  end component;

  for PART1 : PAR_GEN use entity SN54xx280.SN54xx280(BEHAVIORAL);

----------------------------------------

begin

  PART1: PAR_GEN 
  generic map (
     TWD_A => TWD_A,
     TWD_B => TWD_B,
     TWD_C => TWD_C,
     TWD_D => TWD_D,
     TWD_E => TWD_E,
     TWD_F => TWD_F,
     TWD_G => TWD_G,
     TWD_H => TWD_H,
     TWD_I => TWD_I,

     CL_EVEN => CL_EVEN,
     CL_ODD  => CL_ODD 
  )

  port map (
     EVEN  => EVEN,
     ODD   => ODD,

     A     => A,
     B     => B,
     C     => C,
     D     => D,
     E     => E,
     F     => F,
     G     => G,
     H     => H,
     I     => I
  );

----------------------------------------

end STRUCTURAL;
