-- Filename : SN54xx280.vhd
--
-- Version 2.1
--
--
--                                   NOTICE
--
--      LICENSEE acknowledges that it has read and executed the
--      Institute for Technology Development, VHDL Standard Component
--      Library Software Standard License Agreement.  Licensee may not
--      sublicense, assign or transfer the Software, the Documentation or its
--      rights under the Agreement.
--      
--      The Agreement authorizes Licensee to use at any one time only
--      one copy of the Software (either the original Software or the
--      Archival Copy but never both.)  Licensee may make one (1) copy
--      of the Software (the "Archival Copy") and one (1) copy of the
--      Documentation for archival purposes.  Licensee may not otherwise copy,
--      modify, transfer or disclose in any manner the Software or
--      Documentation.  Licensee shall store the Archival Copy in a secure
--      location to which access shall be restricted.  Licensee shall maintain
--      a written record of the data on which the Archival Copy is created and
--      its location.
--      
--      Licensee expressly recognizes that the Software is the proprietary
--      property of ITD.  Licensee warrants that it will not take any action
--      which would result in the impairment or loss of proprietary rights of
--      ITD in the Software.  Licensee warrants that the Software will
--      not be incorporated into any Licensee product.  Licensee warrants 
--      that it will not decompile, disassemble or reverse engineer the 
--      Software or attempt to do so for other than internal applications.
--      Licensee warrants that it will never divulge to any person without the
--      prior written consent of ITD the Software source code or Software
--      object code.
--      
--      The Software is provided "AS IS" WITHOUT WARRANTY of any kind, either
--      express or implied, including but not limited to implied warranties of
--      merchantability and fitness for a particular purpose.
--      
--      RIGHT TO ACCESS OF THIS SOFTWARE IS DENIED IF THIS NOTICE IS REMOVED.
--      
--
--        ------------------------------------------------------------------

library IEEE;                        -- Logic system
  use IEEE.STD_LOGIC_1164.all;     -- Defines logic types, operators, functions

library STD_PACK;                    -- Standard library for all models
  use STD_PACK.MISC_FUNC.all;        -- Miscellaneous functions
  use STD_PACK.TIME_FUNC.all;        -- Timing functions
  use STD_PACK.TTL_TIMING.all;       -- TTL derating coefficients

library SN54xx280;
  use SN54xx280.SN54xx280_TIMING.all;     -- timing module


entity SN54xx280 is
  generic
  (
   GEN_PROP_TIMES : Prop_Times ;
   GEN_FAMILY : Tech_Type ;

   TWD_A : Time;
   TWD_B : Time;
   TWD_C : Time;
   TWD_D : Time;
   TWD_E : Time;
   TWD_F : Time;
   TWD_G : Time;
   TWD_H : Time;
   TWD_I : Time;

   CL_EVEN  : Real ;
   CL_ODD  : Real ;

   REF : String
  );

  port
  (
     EVEN      : out Std_Ulogic;
     ODD       : out Std_Ulogic;

     A         : in Std_Ulogic;
     B         : in Std_Ulogic;
     C         : in Std_Ulogic;
     D         : in Std_Ulogic;
     E         : in Std_Ulogic;
     F         : in Std_Ulogic;
     G         : in Std_Ulogic;
     H         : in Std_Ulogic;
     I         : in Std_Ulogic
  );
 
end SN54xx280;

-- ======================================================================

architecture BEHAVIORAL of SN54xx280 is

  constant CL_OUT : Cload_Out := (
    PIN_EVEN => CL_EVEN,
    PIN_ODD  => CL_ODD
  );

  constant MODEL_TIMES : Prop_Times := BACK_ANNOTATE(GEN_PROP_TIMES,GEN_FAMILY,CL_OUT);

  -- Local signal declarations

  signal AIN,BIN,CIN,DIN,EIN,FIN,GIN,HIN,IIN : Std_Ulogic := 'U';
  signal EVENOUT, ODDOUT                     : UX01Z      := 'U';

begin

    -- assign pin values to local signals after wire delay

    AIN   <= transport A after TWD_A;
    BIN   <= transport B after TWD_B;
    CIN   <= transport C after TWD_C;
    DIN   <= transport D after TWD_D;
    EIN   <= transport E after TWD_E;
    FIN   <= transport F after TWD_F;
    GIN   <= transport G after TWD_G;
    HIN   <= transport H after TWD_H;
    IIN   <= transport I after TWD_I;

    -- Assign local values to output pins

    EVEN <= EVENOUT;
    ODD  <= ODDOUT;

-------------------------------------------------------------------------

PARITY : process (AIN,BIN,CIN,DIN,EIN,FIN,GIN,HIN,IIN)

variable PAR : Std_Ulogic;

begin

    PAR := (AIN xor BIN xor CIN xor DIN xor EIN xor 
            FIN xor GIN xor HIN xor IIN);

    ODDOUT <= transport PAR after TP_DELAY (PAR,
        MODEL_TIMES.TPLH_ODD, MODEL_TIMES.TPHL_ODD);

    EVENOUT <= transport not PAR after TP_DELAY (not PAR,
        MODEL_TIMES.TPLH_EVEN, MODEL_TIMES.TPHL_EVEN);

end process PARITY;

----------------------------------------
    
end BEHAVIORAL;
  
